/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.BreakIterator;
import java.text.CharacterIterator;

class SimpleBreakIterator
extends BreakIterator {
    private CharacterIterator iterator;
    private String bounderies;

    public Object clone() {
        SimpleBreakIterator sbi = (SimpleBreakIterator)super.clone();
        if (this.iterator != null) {
            sbi.iterator = (CharacterIterator)this.iterator.clone();
        }
        return sbi;
    }

    public int current() {
        if (this.iterator == null) {
            return -1;
        }
        return this.iterator.getIndex();
    }

    public int first() {
        if (this.iterator == null) {
            return -1;
        }
        this.iterator.first();
        return this.iterator.getIndex();
    }

    public int following(int pos) {
        if (this.iterator == null) {
            return -1;
        }
        this.iterator.setIndex(pos);
        return this.next();
    }

    public CharacterIterator getText() {
        return this.iterator;
    }

    public int last() {
        if (this.iterator == null) {
            return -1;
        }
        this.iterator.last();
        return this.iterator.getIndex();
    }

    public int next() {
        if (this.iterator == null) {
            return -1;
        }
        if (this.bounderies == null) {
            char next = this.iterator.next();
            if (next != (char)-1) {
                return this.iterator.getIndex();
            }
        } else {
            char next = this.iterator.next();
            while (next != (char)-1) {
                if (this.bounderies.indexOf(next) != -1) {
                    return this.iterator.getIndex();
                }
                next = this.iterator.next();
            }
        }
        return -1;
    }

    public int next(int pos) {
        if (pos > 0) {
            --pos;
            int i = 0;
            while (i < pos) {
                this.next();
                ++i;
            }
            return this.next();
        }
        if (pos < 0) {
            pos = -pos - 1;
            int i = 0;
            while (i < pos) {
                this.previous();
                ++i;
            }
            return this.previous();
        }
        return this.current();
    }

    public int previous() {
        if (this.iterator == null) {
            return -1;
        }
        if (this.bounderies == null) {
            char prev = this.iterator.previous();
            if (prev != (char)-1) {
                return this.iterator.getIndex();
            }
        } else {
            char prev = this.iterator.previous();
            while (prev != (char)-1) {
                if (this.bounderies.indexOf(prev) != -1) {
                    return this.iterator.getIndex();
                }
                prev = this.iterator.previous();
            }
        }
        return -1;
    }

    public void setText(CharacterIterator newText) {
        this.iterator = newText;
    }

    SimpleBreakIterator(String bounds) {
        this.bounderies = bounds;
    }
}

