/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class NumberFormat
extends Format
implements Cloneable {
    public static final int FRACTION_FIELD = 1;
    public static final int INTEGER_FIELD = 0;
    private static final long serialVersionUID = -2308460125733713944L;
    private boolean groupingUsed;
    private byte maxFractionDigits;
    int maximumFractionDigits;
    int maximumIntegerDigits;
    private byte maxIntegerDigits;
    private byte minFractionDigits;
    int minimumFractionDigits;
    int minimumIntegerDigits;
    private byte minIntegerDigits;
    private boolean parseIntegerOnly;
    private int serialVersionOnStream = 1;

    public static Locale[] getAvailableLocales() {
        return new Locale[0];
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getCurrencyInstance(Locale.getDefault());
    }

    public static NumberFormat getCurrencyInstance(Locale loc) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
        DecimalFormat df = new DecimalFormat(dfs);
        dfs.setDecimalSeparator(dfs.getMonetaryDecimalSeparator());
        df.setNegativeSuffix(")");
        String cur = dfs.getCurrencySymbol();
        df.setPositivePrefix(cur);
        df.setNegativePrefix("(" + cur);
        DecimalFormat nf = df;
        nf.minimumIntegerDigits = 1;
        nf.maximumIntegerDigits = 340;
        nf.maximumFractionDigits = 2;
        nf.minimumFractionDigits = 2;
        nf.groupingUsed = true;
        return df;
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault());
    }

    public static NumberFormat getInstance(Locale loc) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
        DecimalFormat nf = new DecimalFormat(dfs);
        nf.minimumIntegerDigits = 1;
        nf.maximumIntegerDigits = 340;
        nf.maximumFractionDigits = 3;
        nf.minimumFractionDigits = 0;
        return nf;
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getInstance(Locale.getDefault());
    }

    public static NumberFormat getNumberInstance(Locale loc) {
        return NumberFormat.getInstance(loc);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getPercentInstance(Locale.getDefault());
    }

    public static NumberFormat getPercentInstance(Locale loc) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(loc);
        DecimalFormat df = new DecimalFormat(dfs);
        df.setMultiplier(100);
        String per = "" + dfs.getPercent();
        df.setPositiveSuffix(per);
        df.setNegativeSuffix(per);
        df.setDecimalSeparatorAlwaysShown(false);
        DecimalFormat nf = df;
        nf.minimumIntegerDigits = 1;
        nf.maximumIntegerDigits = 340;
        nf.minimumFractionDigits = 0;
        nf.maximumFractionDigits = 0;
        nf.groupingUsed = true;
        nf.parseIntegerOnly = true;
        return df;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.serialVersionOnStream < 1) {
            this.serialVersionOnStream = 1;
            this.maximumFractionDigits = this.maxFractionDigits;
            this.maximumIntegerDigits = this.maxIntegerDigits;
            this.minimumFractionDigits = this.minFractionDigits;
            this.minimumIntegerDigits = this.minIntegerDigits;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int max = 127;
        this.maxFractionDigits = (byte)(this.maximumFractionDigits > max ? max : this.maximumFractionDigits);
        this.maxIntegerDigits = (byte)(this.maximumIntegerDigits > max ? max : this.maximumIntegerDigits);
        this.minFractionDigits = (byte)(this.minimumFractionDigits > max ? max : this.minimumFractionDigits);
        this.minIntegerDigits = (byte)(this.minimumIntegerDigits > max ? max : this.minimumIntegerDigits);
        out.defaultWriteObject();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public abstract Number parse(String var1, ParsePosition var2);

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NumberFormat)) {
            return false;
        }
        NumberFormat nf = (NumberFormat)obj;
        return this.groupingUsed == nf.groupingUsed && this.parseIntegerOnly == nf.parseIntegerOnly && this.maximumFractionDigits == nf.maximumFractionDigits && this.maximumIntegerDigits == nf.maximumIntegerDigits && this.minimumFractionDigits == nf.minimumFractionDigits && this.minimumIntegerDigits == nf.minimumIntegerDigits;
    }

    public final String format(double number) {
        return this.format(number, new StringBuffer(), new FieldPosition(1)).toString();
    }

    public final String format(long number) {
        return this.format(number, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final StringBuffer format(Object number, StringBuffer buf, FieldPosition pos) {
        if (number instanceof Long) {
            return this.format((Long)number, buf, pos);
        }
        if (number instanceof Double) {
            return this.format((Double)number, buf, pos);
        }
        throw new IllegalArgumentException("Got Bad Class");
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public int hashCode() {
        int hash = this.groupingUsed ? -65536 : 0;
        return (hash ^= this.parseIntegerOnly ? 65535 : 0) ^ this.maximumFractionDigits ^ this.maximumIntegerDigits ^ this.minimumFractionDigits ^ this.minimumIntegerDigits;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public Number parse(String s) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Number n = this.parse(s, pos);
        if (n == null) {
            throw new ParseException("error during parsing", pos.getErrorIndex());
        }
        return n;
    }

    public final Object parseObject(String srcStr, ParsePosition pos) {
        return this.parse(srcStr, pos);
    }

    public void setGroupingUsed(boolean use) {
        this.groupingUsed = use;
    }

    public void setParseIntegerOnly(boolean only) {
        this.parseIntegerOnly = only;
    }

    public void setMaximumFractionDigits(int val) {
        if (val < 0) {
            val = 0;
        }
        if (val < this.minimumFractionDigits) {
            this.minimumFractionDigits = val;
        }
        this.maximumFractionDigits = val;
    }

    public void setMaximumIntegerDigits(int val) {
        if (val < 0) {
            val = 0;
        }
        if (val < this.minimumIntegerDigits) {
            this.minimumIntegerDigits = val;
        }
        this.maximumIntegerDigits = val;
    }

    public void setMinimumFractionDigits(int val) {
        if (val < 0) {
            this.minimumFractionDigits = 0;
        } else {
            if (val > this.maximumFractionDigits) {
                this.maximumFractionDigits = val;
            }
            this.minimumFractionDigits = val;
        }
    }

    public void setMinimumIntegerDigits(int val) {
        if (val < 0) {
            this.minimumIntegerDigits = 0;
        } else {
            if (val > this.maximumIntegerDigits) {
                this.maximumIntegerDigits = val;
            }
            this.minimumIntegerDigits = val;
        }
    }
}

