/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.io.ByteArrayInputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;

public abstract class Certificate
implements Serializable {
    private static final long serialVersionUID = -6751606818319535583L;
    private String type;

    protected Certificate(String type) {
        this.type = type;
    }

    public final String getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Certificate)) {
            return false;
        }
        Certificate cert = (Certificate)other;
        try {
            return Arrays.equals(cert.getEncoded(), this.getEncoded());
        }
        catch (CertificateEncodingException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.getEncoded().hashCode();
        }
        catch (CertificateEncodingException e) {
            return 0;
        }
    }

    public abstract byte[] getEncoded() throws CertificateEncodingException;

    public abstract void verify(PublicKey var1) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract void verify(PublicKey var1, String var2) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException;

    public abstract String toString();

    public abstract PublicKey getPublicKey();

    protected Object writeReplace() throws ObjectStreamException {
        try {
            return new CertificateRep(this.type, this.getEncoded());
        }
        catch (CertificateEncodingException cee) {
            throw new InvalidObjectException(cee.toString());
        }
    }

    protected static class CertificateRep
    implements Serializable {
        private String type;
        private byte[] data;

        protected CertificateRep(String type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return CertificateFactory.getInstance(this.type).generateCertificate(new ByteArrayInputStream(this.data));
            }
            catch (Exception e) {
                throw new InvalidObjectException(e.toString());
            }
        }
    }
}

