/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import com.acunia.wonka.security.DefaultProvider;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;

class CertAction
implements PrivilegedAction {
    private static final Provider defaultProvider = DefaultProvider.getInstance();
    Provider provider;
    Object spi;

    public Object run() {
        return this.provider.getClass().getClassLoader();
    }

    private final String getAliasName(String aliasName, String type) {
        String alias = this.provider.getProperty(aliasName);
        if (alias != null) {
            alias = defaultProvider.getProperty(aliasName);
        }
        if (alias != null) {
            return this.provider.getProperty(type + alias);
        }
        return null;
    }

    private CertAction(Provider prov) {
        this.provider = prov;
    }

    CertAction(String algorithm, String type) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        String propName = type + algorithm;
        String aliasName = "Alg.Alias." + propName;
        int i = 0;
        while (i < p.length) {
            this.provider = p[i];
            String classname = this.provider.getProperty(propName);
            if (classname != null) {
                try {
                    this.spi = Class.forName(classname, true, (ClassLoader)AccessController.doPrivileged(this)).newInstance();
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((classname = this.getAliasName(aliasName, type)) != null) {
                try {
                    this.spi = Class.forName(classname, true, (ClassLoader)AccessController.doPrivileged(this)).newInstance();
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw new NoSuchAlgorithmException("couldn't find " + algorithm + " of type " + type);
    }

    CertAction(String algorithm, String providerName, String type) throws NoSuchAlgorithmException, NoSuchProviderException {
        this.provider = Security.getProvider(providerName);
        if (this.provider == null) {
            throw new NoSuchProviderException("couldn't find " + this.provider);
        }
        String propName = type + algorithm;
        String classname = this.provider.getProperty(propName);
        if (classname != null) {
            try {
                this.spi = Class.forName(classname, true, (ClassLoader)AccessController.doPrivileged(this)).newInstance();
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((classname = this.getAliasName("Alg.Alias." + propName, type)) != null) {
            try {
                this.spi = Class.forName(classname, true, (ClassLoader)AccessController.doPrivileged(this)).newInstance();
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new NoSuchAlgorithmException("couldn't find " + algorithm + " of type " + type);
    }
}

