/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class Provider
extends Properties {
    private static final long serialVersionUID = -4298000515446427739L;
    private String info;
    private String name;
    private double version;

    private static void permissionCheck(String permission) {
    }

    protected Provider(String name, double version, String info) {
        this.info = info;
        this.name = name;
        this.version = version;
    }

    public String getInfo() {
        return this.info;
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String toString() {
        return this.name + " version: " + this.version;
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    public Set keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(super.values());
    }

    public void clear() {
        Provider.permissionCheck("clearProviderProperties." + this.name);
        super.clear();
    }

    public void load(InputStream in) throws IOException {
        super.load(in);
    }

    public Object put(Object key, Object value) {
        Provider.permissionCheck("putProviderProperty." + this.name);
        return super.put(key, value);
    }

    public void putAll(Map t) {
        Provider.permissionCheck("putProviderProperty." + this.name);
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            super.put(me.getKey(), me.getValue());
        }
    }

    public String getProperty(String nm) {
        return super.getProperty(nm);
    }

    public Object remove(Object key) {
        Provider.permissionCheck("removeProviderProperty." + this.name);
        return super.remove(key);
    }
}

