/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecurityAction;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParameters {
    private AlgorithmParametersSpi paramSpi;
    private Provider provider;
    private String algorithm;

    public static AlgorithmParameters getInstance(String algorithm) throws NoSuchAlgorithmException {
        SecurityAction action = new SecurityAction(algorithm, "AlgorithmParameters.");
        return new AlgorithmParameters((AlgorithmParametersSpi)action.spi, action.provider, algorithm);
    }

    public static AlgorithmParameters getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityAction action = new SecurityAction(algorithm, provider, "AlgorithmParameters.");
        return new AlgorithmParameters((AlgorithmParametersSpi)action.spi, action.provider, algorithm);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final byte[] getEncoded() throws IOException {
        return this.paramSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String format) throws IOException {
        return this.paramSpi.engineGetEncoded(format);
    }

    public final AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        return this.paramSpi.engineGetParameterSpec(paramSpec);
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.paramSpi.engineInit(paramSpec);
    }

    public final void init(byte[] params) throws IOException {
        this.paramSpi.engineInit(params);
    }

    public final void init(byte[] params, String format) throws IOException {
        this.paramSpi.engineInit(params, format);
    }

    public final String toString() {
        return this.paramSpi.engineToString();
    }

    protected AlgorithmParameters(AlgorithmParametersSpi paramSpi, Provider provider, String algorithm) {
        this.paramSpi = paramSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }
}

