/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecurityAction;
import java.security.spec.AlgorithmParameterSpec;

public class AlgorithmParameterGenerator {
    private AlgorithmParameterGeneratorSpi paramGenSpi;
    private Provider provider;
    private String algorithm;

    public static AlgorithmParameterGenerator getInstance(String algorithm) throws NoSuchAlgorithmException {
        SecurityAction action = new SecurityAction(algorithm, "AlgorithmParameterGenerator.");
        return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)action.spi, action.provider, algorithm);
    }

    public static AlgorithmParameterGenerator getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        SecurityAction action = new SecurityAction(algorithm, provider, "AlgorithmParameterGenerator.");
        return new AlgorithmParameterGenerator((AlgorithmParameterGeneratorSpi)action.spi, action.provider, algorithm);
    }

    public final AlgorithmParameters generateParameters() {
        return this.paramGenSpi.engineGenerateParameters();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec genParamSpec) throws InvalidAlgorithmParameterException {
        this.init(genParamSpec, new SecureRandom());
    }

    public final void init(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.paramGenSpi.engineInit(genParamSpec, random);
    }

    public final void init(int size) {
        this.init(size, new SecureRandom());
    }

    public final void init(int size, SecureRandom random) {
        this.paramGenSpi.engineInit(size, random);
    }

    protected AlgorithmParameterGenerator(AlgorithmParameterGeneratorSpi paramGenSpi, Provider provider, String algorithm) {
        this.paramGenSpi = paramGenSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }
}

