/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;

public final class AccessController {
    private static native void initialize();

    private static native Object doPrivileged0(PrivilegedAction var0, AccessControlContext var1);

    private static native Object doPrivileged0(PrivilegedExceptionAction var0, AccessControlContext var1) throws Exception;

    public static Object doPrivileged(PrivilegedAction action) {
        return AccessController.doPrivileged(action, AccessController.getContext());
    }

    public static Object doPrivileged(PrivilegedAction action, AccessControlContext context) {
        return AccessController.doPrivileged0(action, new AccessControlContext(AccessController.get_calling_domains(), AccessController.get_inherited_context(), context));
    }

    public static Object doPrivileged(PrivilegedExceptionAction action) throws PrivilegedActionException {
        try {
            return AccessController.doPrivileged0(action, AccessController.getContext());
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public static Object doPrivileged(PrivilegedExceptionAction action, AccessControlContext context) throws PrivilegedActionException {
        try {
            return AccessController.doPrivileged0(action, new AccessControlContext(AccessController.get_calling_domains(), AccessController.get_inherited_context(), context));
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public static AccessControlContext getContext() {
        return new AccessControlContext(AccessController.get_calling_domains(), AccessController.get_inherited_context());
    }

    private static native ProtectionDomain[] get_calling_domains();

    private static native AccessControlContext get_inherited_context();

    public static void checkPermission(Permission perm) throws AccessControlException {
        try {
            AccessController.getContext().checkPermission(perm);
        }
        catch (AccessControlException e) {
            throw new AccessControlException("Context: " + AccessController.getContext() + "   Permission: " + perm);
        }
    }

    private AccessController() {
    }

    static {
        AccessController.initialize();
    }
}

