/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;

public final class AccessControlContext {
    HashSet domains;
    int hashcode;
    Permission o_k_perm;
    private DomainCombiner domainCombiner;

    public AccessControlContext(ProtectionDomain[] context) {
        this.domains = new HashSet(context.length * 4 / 3 + 4);
        for (int i = 0; i < context.length; ++i) {
            this.domains.add(context[i]);
        }
    }

    public AccessControlContext(AccessControlContext context, DomainCombiner combiner) {
        Security.permissionCheck("createAccessControlContext");
        this.domains = (HashSet)context.domains.clone();
        this.domainCombiner = combiner;
    }

    AccessControlContext(ProtectionDomain[] context, AccessControlContext acc) {
        if (acc == null) {
            this.domains = new HashSet();
        } else if (this.domainCombiner != null) {
            this.domains = new HashSet();
            context = this.domainCombiner.combine(context, (ProtectionDomain[])acc.domains.toArray(new ProtectionDomain[acc.domains.size()]));
        } else {
            this.domains = (HashSet)acc.domains.clone();
        }
        for (int i = 0; i < context.length; ++i) {
            ProtectionDomain pd = context[i];
            if (this.domains.contains(pd)) continue;
            this.domains.add(pd);
        }
    }

    AccessControlContext(ProtectionDomain[] context, AccessControlContext acc1, AccessControlContext acc2) {
        ProtectionDomain pd;
        this.domains = acc1 == null ? new HashSet() : (HashSet)acc1.domains.clone();
        if (acc2 != null) {
            Iterator acc2enum = acc2.domains.iterator();
            while (acc2enum.hasNext()) {
                pd = (ProtectionDomain)acc2enum.next();
                if (this.domains.contains(pd)) continue;
                this.domains.add(pd);
            }
        }
        for (int i = 0; i < context.length; ++i) {
            pd = context[i];
            if (this.domains.contains(pd)) continue;
            this.domains.add(pd);
        }
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        if (perm.equals(this.o_k_perm)) {
            return;
        }
        Iterator pdenum = this.domains.iterator();
        while (pdenum.hasNext()) {
            ProtectionDomain pd = (ProtectionDomain)pdenum.next();
            if (pd.implies(perm)) continue;
            throw new AccessControlException("Not implied by " + pd, perm);
        }
        this.o_k_perm = perm;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext that = (AccessControlContext)o;
        if (this.domains.size() != that.domains.size()) {
            return false;
        }
        Iterator pdenum = this.domains.iterator();
        while (pdenum.hasNext()) {
            ProtectionDomain pd = (ProtectionDomain)pdenum.next();
            if (that.domains.contains(pd)) continue;
            return false;
        }
        return true;
    }

    public DomainCombiner getDomainCombiner() {
        Security.permissionCheck("getDomainCombiner");
        return this.domainCombiner;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            Iterator pdenum = this.domains.iterator();
            while (pdenum.hasNext()) {
                ProtectionDomain pd = (ProtectionDomain)pdenum.next();
                this.hashcode ^= pd.hashCode();
            }
        }
        return this.hashcode;
    }
}

