/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.acunia.wonka.rmi.ObjIDData;
import com.acunia.wonka.rmi.RMIAcceptThread;
import com.acunia.wonka.rmi.RMIConnection;
import com.acunia.wonka.rmi.UnicastRef;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;

public class UnicastRemoteObject
extends RemoteServer {
    private static final long serialVersionUID = 4974527148936298033L;
    static final Hashtable exports = new Hashtable(13);
    private transient int port;
    private transient RMIClientSocketFactory csf;
    private transient RMIServerSocketFactory ssf;
    static /* synthetic */ Class class$java$rmi$server$RemoteRef;

    protected UnicastRemoteObject() throws RemoteException {
        this(0, null, null);
    }

    protected UnicastRemoteObject(int port) throws RemoteException {
        this(port, null, null);
    }

    protected UnicastRemoteObject(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this.csf = csf == null ? RMISocketFactory.getRMISocketFactory() : csf;
        this.ssf = ssf == null ? RMISocketFactory.getRMISocketFactory() : ssf;
        UnicastRemoteObject.exportObject(this, port, this.csf, this.ssf);
        this.port = ((ObjIDData)UnicastRemoteObject.exports.get((Object)this)).server.getLocalPort();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            UnicastRemoteObject myClone = (UnicastRemoteObject)super.clone();
            UnicastRemoteObject.exportObject(myClone);
            return myClone;
        }
        catch (RemoteException e) {
            throw new ServerCloneException("Couldn't clone UnicastRemoteObject: " + this, e);
        }
    }

    public static RemoteStub exportObject(Remote obj) throws RemoteException {
        return (RemoteStub)UnicastRemoteObject.exportObject(obj, 0, null, null);
    }

    public static Remote exportObject(Remote obj, int port) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, port, null, null);
    }

    public static Remote exportObject(Remote obj, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        csf = csf == null ? RMISocketFactory.getRMISocketFactory() : csf;
        ssf = ssf == null ? RMISocketFactory.getRMISocketFactory() : ssf;
        ServerSocket ss = null;
        do {
            try {
                ss = ssf.createServerSocket(port);
            }
            catch (IOException ioe) {
                RMIFailureHandler fh = RMISocketFactory.theFailureHandler;
                if (fh == null || fh.failure(ioe)) continue;
                throw new RemoteException("failed to create ServerSocket", ioe);
            }
        } while (ss == null);
        if (exports.containsKey(obj)) {
            ObjIDData data = (ObjIDData)exports.get(obj);
            try {
                data.server.close();
                new RegisterAction(data.id, null);
            }
            catch (IOException ioe) {
                throw new RemoteException("exportObject failed", ioe);
            }
        }
        try {
            Class remoteClass = obj.getClass();
            String name = remoteClass.getName() + "_Stub";
            RemoteStub stub = null;
            Class cl = Class.forName(name, true, remoteClass.getClassLoader());
            ObjID id = new ObjID();
            UnicastRef ref = new UnicastRef(UnicastRemoteObject.getAddress(ss), ss.getLocalPort(), id, csf);
            RemoteObject myRemoteObj = (RemoteObject)obj;
            myRemoteObj.ref = ref;
            try {
                Constructor constr = cl.getDeclaredConstructor(new Class[]{class$java$rmi$server$RemoteRef == null ? (class$java$rmi$server$RemoteRef = UnicastRemoteObject.class$("java.rmi.server.RemoteRef")) : class$java$rmi$server$RemoteRef});
                stub = (RemoteStub)constr.newInstance(new Object[]{ref});
            }
            catch (NoSuchMethodException nsme) {
                stub = (RemoteStub)cl.newInstance();
                stub.ref = ref;
            }
            ObjIDData idData = new ObjIDData(ss, obj, stub, id);
            exports.put(obj, idData);
            new RegisterAction(id, idData);
            new RMIAcceptThread(ss);
            return stub;
        }
        catch (Exception e) {
            throw new RemoteException("export failed", e);
        }
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        ObjIDData data = (ObjIDData)exports.get(obj);
        if (data == null) {
            throw new NoSuchObjectException("object " + obj + " not found");
        }
        try {
            data.server.close();
            new RegisterAction(data.id, null);
        }
        catch (IOException ioe) {
            return false;
        }
        exports.remove(obj);
        return true;
    }

    private static String getAddress(ServerSocket ss) {
        String address = ss.getInetAddress().getHostAddress();
        if (address.equals("0.0.0.0")) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe) {
                address = "127.0.0.1";
            }
        }
        return address;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                RMIConnection.setupTable(exports);
                return null;
            }
        });
    }

    static final class RegisterAction
    implements PrivilegedExceptionAction {
        private ObjID id;
        private ObjIDData data;

        RegisterAction(ObjID id, ObjIDData data) throws RemoteException {
            this.id = id;
            this.data = data;
            try {
                AccessController.doPrivileged(this);
            }
            catch (PrivilegedActionException pae) {
                throw (RemoteException)pae.getException();
            }
        }

        public Object run() throws RemoteException {
            if (this.data == null) {
                RMIConnection.deregisterObjIDData(this.id);
            } else {
                RMIConnection.registerObjIDData(this.id, this.data);
            }
            return null;
        }
    }
}

