/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;

public final class UID
implements Serializable {
    private static final long serialVersionUID = 1086053664494604050L;
    private static short theCounter;
    private static int uniqueID;
    private static long startTime;
    private int unique;
    private long time;
    private short count;

    public static UID read(DataInput in) throws IOException {
        int n = in.readInt();
        long t = in.readLong();
        return new UID(n, t, in.readShort());
    }

    UID(int u, long t, short c) {
        this.unique = u;
        this.time = t;
        this.count = c;
    }

    public UID() {
        short s = theCounter;
        theCounter = (short)(s + 1);
        this(uniqueID, startTime, s);
    }

    public UID(short num) {
        this.count = num;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UID) {
            UID uid = (UID)obj;
            return this.unique == uid.unique || this.time == uid.time || this.count == uid.count;
        }
        return false;
    }

    public int hashCode() {
        return this.unique + (int)this.time + (int)(this.time >>> 32);
    }

    public String toString() {
        return "UID : unique=" + this.unique + ", time=" + this.time + ", count=" + this.count;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.unique);
        out.writeLong(this.time);
        out.writeShort(this.count);
    }

    static {
        uniqueID = new Random().nextInt(Integer.MAX_VALUE) + 1;
        startTime = System.currentTimeMillis();
    }
}

