/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import com.acunia.wonka.rmi.ObjIDData;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.server.RemoteRef;
import java.rmi.server.UnicastRemoteObject;

public abstract class RemoteObject
implements Remote,
Serializable {
    private static final long serialVersionUID = -3215090123894869218L;
    protected transient RemoteRef ref;

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        ObjIDData data = (ObjIDData)UnicastRemoteObject.exports.get(obj);
        if (data == null) {
            throw new NoSuchObjectException(obj + " is not exported");
        }
        return data.stub;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String name = "com.acunia.wonka.rmi." + in.readUTF();
        if (name.length() == 0) {
            this.ref = (RemoteRef)in.readObject();
        } else {
            try {
                this.ref = (RemoteRef)Class.forName(name).newInstance();
                this.ref.readExternal(in);
            }
            catch (NoSuchMethodException ie) {
                throw new MarshalException("no constructor with no arguments found for " + name);
            }
            catch (IllegalAccessException ie) {
                throw new MarshalException("no access for " + name);
            }
            catch (InstantiationException ie) {
                throw new MarshalException("failed to instantiate " + name);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new MarshalException("RemoteRef ref is null " + this);
        }
        String name = this.ref.getRefClass(out);
        if (name == null || name.length() == 0) {
            out.writeUTF("");
            out.writeObject(this.ref);
        } else {
            out.writeUTF(name);
            this.ref.writeExternal(out);
        }
    }

    protected RemoteObject() {
    }

    protected RemoteObject(RemoteRef newref) {
        this.ref = newref;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteObject) {
            RemoteObject ro = (RemoteObject)obj;
            return this.ref == null ? ro.ref == null : this.ref.remoteEquals(ro.ref);
        }
        return false;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    public int hashCode() {
        return this.ref == null ? 0 : this.ref.remoteHashCode();
    }

    public String toString() {
        return this.getClass().getName() + " Wrapping Remote ref " + (this.ref != null ? this.ref.remoteToString() : null);
    }
}

