/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import com.acunia.wonka.security.SocketPermissionCollection;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Permission;
import java.security.PermissionCollection;

public final class SocketPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -7204263841984476862L;
    private static final String DNS_CHARS = "abcdefghijklmnopqrstuvwxyz-0123456789";
    private static final int ACCEPT = 1;
    private static final int CONNECT = 2;
    private static final int LISTEN = 4;
    private static final int RESOLVE = 8;
    private String action;
    private String host_suffix;
    private boolean has_wild_prefix;
    private boolean numeric;
    private int lo_port;
    private int hi_port;
    private int bitmap;

    public SocketPermission(String host, String action) {
        super("".equals(host) ? "localhost" : host);
        int colon;
        if ("".equals(host)) {
            host = "localhost";
        }
        if ((colon = host.indexOf(58)) < 0) {
            this.parseHostName(host);
            this.lo_port = 0;
            this.hi_port = 65535;
        } else {
            this.parseHostName(host.substring(0, colon));
            String ranges = host.substring(colon + 1);
            int hyphen = ranges.indexOf(45);
            if (hyphen < 0) {
                this.hi_port = this.lo_port = Integer.parseInt(ranges);
            } else {
                String s = ranges.substring(0, hyphen);
                this.lo_port = "".equals(s) ? 0 : Integer.parseInt(s);
                s = ranges.substring(hyphen + 1);
                int n = this.hi_port = "".equals(s) ? 65535 : Integer.parseInt(s);
            }
        }
        if (this.hi_port < this.lo_port || this.lo_port < 0 || this.hi_port > 65535) {
            throw new IllegalArgumentException("bad port Numbers specified");
        }
        this.parseActions(action);
    }

    private void parseHostName(String name) throws IllegalArgumentException {
        int octet = 0;
        if (name.equals("")) {
            throw new IllegalArgumentException("bad hostname specified");
        }
        if (name.charAt(0) == '*') {
            if (name.length() > 3 && (name.charAt(1) != '.' || Character.isDigit(name.charAt(2)))) {
                throw new IllegalArgumentException("Attempt to use wildcard in numeric IP address");
            }
            int start = name.length() > 1 ? 2 : 1;
            this.host_suffix = name.substring(start).toLowerCase();
            this.has_wild_prefix = true;
            this.numeric = false;
        } else {
            this.host_suffix = name.toLowerCase();
            this.has_wild_prefix = false;
            this.numeric = Character.isDigit(name.charAt(0));
        }
        int dotcount = 0;
        for (int i = 0; i < this.host_suffix.length(); ++i) {
            char c = this.host_suffix.charAt(i);
            if (c == '.') {
                if (!this.numeric) continue;
                if (++dotcount > 3) {
                    throw new IllegalArgumentException("Too many dots in hostname");
                }
                octet = 0;
                continue;
            }
            if (this.numeric) {
                if (!Character.isDigit(c)) {
                    throw new IllegalArgumentException("Non-digit '" + c + "'in numeric IP address");
                }
                if ((octet = octet * 10 + Character.digit(c, 10)) <= 255 && octet >= 0) continue;
                throw new IllegalArgumentException("Illegal octet '" + octet + "'in numeric IP address");
            }
            if (DNS_CHARS.indexOf(c) >= 0) continue;
            throw new IllegalArgumentException("Bad character '" + c + "'in hostname");
        }
    }

    private void parseActions(String s) {
        String sx = s.toLowerCase();
        while (sx != "") {
            String s0;
            int i = sx.indexOf(44);
            if (i < 0) {
                s0 = sx.trim();
                sx = "";
            } else {
                s0 = sx.substring(0, i).trim();
                sx = sx.substring(i + 1);
            }
            if (s0.equals("accept")) {
                this.bitmap |= 9;
                continue;
            }
            if (s0.equals("connect")) {
                this.bitmap |= 0xA;
                continue;
            }
            if (s0.equals("listen")) {
                this.bitmap |= 0xC;
                continue;
            }
            if (s0.equals("resolve")) {
                this.bitmap |= 8;
                continue;
            }
            throw new IllegalArgumentException("bad action specified -->" + s0);
        }
        if (this.bitmap == 0) {
            throw new IllegalArgumentException("no actions specified");
        }
        StringBuffer buf = new StringBuffer();
        if ((this.bitmap & 2) > 0) {
            buf.append("connect,");
        }
        if ((this.bitmap & 4) > 0) {
            buf.append("listen,");
        }
        if ((this.bitmap & 1) > 0) {
            buf.append("accept,");
        }
        if ((this.bitmap & 8) > 0) {
            buf.append("resolve");
        }
        this.action = buf.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SocketPermission)) {
            return false;
        }
        SocketPermission p = (SocketPermission)obj;
        if (!this.has_wild_prefix) {
            try {
                return !p.has_wild_prefix && this.lo_port == p.lo_port && this.hi_port == p.hi_port && this.action.equals(p.action) && InetAddress.getByName(this.host_suffix).equals(InetAddress.getByName(p.host_suffix));
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.getName().equals(p.getName()) && this.action.equals(p.action);
    }

    public int hashCode() {
        if (!this.has_wild_prefix) {
            try {
                return InetAddress.getByName(this.host_suffix).hashCode() ^ this.lo_port ^ this.hi_port << 16;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return this.getName().hashCode();
    }

    public String getActions() {
        return this.action;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof SocketPermission)) {
            return false;
        }
        SocketPermission that = (SocketPermission)p;
        return (that.bitmap & ~this.bitmap) == 0 && that.lo_port >= this.lo_port && that.hi_port <= this.hi_port && this.nameImplies(this, that);
    }

    private boolean nameImplies(SocketPermission a, SocketPermission b) {
        String b_as_numeric = b.host_suffix;
        String b_as_hostname = b.host_suffix;
        if (!a.has_wild_prefix && !b.has_wild_prefix && a.host_suffix.equals(b.host_suffix)) {
            return true;
        }
        if (a.has_wild_prefix && b.has_wild_prefix) {
            return b.host_suffix.endsWith(a.host_suffix);
        }
        if (!a.has_wild_prefix && b.has_wild_prefix) {
            return false;
        }
        try {
            if (b.numeric) {
                b_as_hostname = InetAddress.getByName(b.host_suffix).getHostName();
            } else if (!b.has_wild_prefix) {
                b_as_numeric = InetAddress.getByName(b.host_suffix).getHostAddress();
                b_as_hostname = InetAddress.getByName(b.host_suffix).getHostName();
                if (b_as_hostname != b.host_suffix) {
                    return false;
                }
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (!a.has_wild_prefix && !b.has_wild_prefix) {
            InetAddress[] translations;
            if (a.numeric) {
                return false;
            }
            try {
                translations = InetAddress.getAllByName(a.host_suffix);
            }
            catch (UnknownHostException e) {
                return false;
            }
            for (int i = 0; i < translations.length; ++i) {
                if (!translations[i].getHostAddress().equals(b_as_numeric)) continue;
                return true;
            }
            return false;
        }
        return b_as_hostname.endsWith(a.host_suffix);
    }

    public PermissionCollection newPermissionCollection() {
        return new SocketPermissionCollection();
    }
}

