/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.PlainDatagramSocketImpl;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;

class PlainSocketImpl
extends SocketImpl {
    private InputStream in;
    private OutputStream out;
    private int timeout = 0;
    private boolean open;

    public synchronized Object getOption(int opt) throws SocketException {
        if (opt == 4102) {
            return new Integer(this.timeout);
        }
        if (opt == 8) {
            return new Boolean(this.getKeepAlive());
        }
        return PlainDatagramSocketImpl.Options(opt, null, this.getSocket());
    }

    public synchronized void setOption(int opt, Object value) throws SocketException {
        if (value == null) {
            throw new SocketException("a non 'null' option value is required");
        }
        if (opt == 4102) {
            if (value instanceof Integer) {
                this.timeout = (Integer)value;
            }
        } else if (opt == 8) {
            if (value instanceof Boolean) {
                this.setKeepAlive((Boolean)value);
            }
        } else {
            PlainDatagramSocketImpl.Options(opt, value, this.getSocket());
        }
    }

    protected void connect(String host, int port) throws IOException {
        this.connect(InetAddress.getByName(host), port);
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (!this.open) {
            throw new IOException("SocketImpl has been closed");
        }
        if (this.in == null) {
            this.in = new SocketInputStream(this);
        }
        return this.in;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (!this.open) {
            throw new IOException("SocketImpl has been closed");
        }
        if (this.out == null) {
            this.out = new SocketOutputStream(this);
        }
        return this.out;
    }

    protected synchronized void create(boolean stream) throws IOException {
        if (!stream) {
            throw new IOException("datagram services not supported");
        }
        this.fd = new FileDescriptor();
        this.nativeCreate();
    }

    protected synchronized void accept(SocketImpl s) throws IOException {
        int ip = this.nativeAccept((PlainSocketImpl)s);
        s.address = InetAddress.createInetAddress(ip);
    }

    protected synchronized void shutdownInput() throws IOException {
        this.shutdown(true);
    }

    protected synchronized void shutdownOutput() throws IOException {
        this.shutdown(false);
    }

    native int read(byte[] var1, int var2, int var3) throws IOException;

    native void write(byte[] var1, int var2, int var3) throws IOException;

    protected native void finalize();

    private native int getSocket() throws SocketException;

    private native void nativeCreate();

    private native int nativeAccept(SocketImpl var1) throws IOException;

    private native void shutdown(boolean var1) throws IOException;

    private native boolean getKeepAlive() throws SocketException;

    private native void setKeepAlive(Boolean var1) throws SocketException;

    protected synchronized native void listen(int var1) throws IOException;

    protected synchronized native int available() throws IOException;

    protected synchronized native void bind(InetAddress var1, int var2) throws IOException;

    protected synchronized native void close() throws IOException;

    protected synchronized native void connect(InetAddress var1, int var2) throws IOException;
}

