/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

public final class Array {
    private Array() {
    }

    public static native Object newInstance(Class var0, int var1) throws NullPointerException, NegativeArraySizeException;

    public static native Object newInstance(Class var0, int[] var1) throws NullPointerException, IllegalArgumentException, NegativeArraySizeException;

    public static native int getLength(Object var0) throws NullPointerException, IllegalArgumentException;

    public static native Object get(Object var0, int var1) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException;

    public static boolean getBoolean(Object array, int index) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        boolean[] za;
        try {
            za = (boolean[])array;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException();
        }
        return za[index];
    }

    public static byte getByte(Object array, int index) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        byte[] ba;
        try {
            ba = (byte[])array;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException();
        }
        return ba[index];
    }

    public static char getChar(Object array, int index) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        char[] ca;
        try {
            ca = (char[])array;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException();
        }
        return ca[index];
    }

    public static short getShort(Object array, int index) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Number nm;
        Class arrayclass = array.getClass().getComponentType();
        if (arrayclass == null) {
            throw new IllegalArgumentException("Object is not an Array");
        }
        if (!arrayclass.isPrimitive()) {
            throw new IllegalArgumentException("Object is not an Array of primitive types");
        }
        if (!arrayclass.toString().equals("byte") && !arrayclass.toString().equals("short")) {
            throw new IllegalArgumentException("Object is not an Array of short or byte");
        }
        try {
            nm = (Number)Array.get(array, index);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Object is not an Array of numeric primitive types");
        }
        return nm.shortValue();
    }

    public static int getInt(Object array, int index) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Number nm;
        Class arrayclass = array.getClass().getComponentType();
        if (arrayclass == null) {
            throw new IllegalArgumentException("Object is not an Array");
        }
        if (!arrayclass.isPrimitive()) {
            throw new IllegalArgumentException("Object is not an Array of primitive types");
        }
        if (arrayclass.toString().equals("char")) {
            return Array.getChar(array, index);
        }
        if (!(arrayclass.toString().equals("byte") || arrayclass.toString().equals("short") || arrayclass.toString().equals("int"))) {
            throw new IllegalArgumentException("wrong primitive array type");
        }
        try {
            nm = (Number)Array.get(array, index);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Object is not an Array of numeric primitive types");
        }
        return nm.intValue();
    }

    public static long getLong(Object array, int index) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Number nm;
        Class arrayclass = array.getClass().getComponentType();
        if (arrayclass == null) {
            throw new IllegalArgumentException("Object is not an Array");
        }
        if (!arrayclass.isPrimitive()) {
            throw new IllegalArgumentException("Object is not an Array of primitive types");
        }
        if (arrayclass.toString().equals("char")) {
            return Array.getChar(array, index);
        }
        if (arrayclass.toString().equals("float") || arrayclass.toString().equals("double")) {
            throw new IllegalArgumentException("wrong primitive array type");
        }
        try {
            nm = (Number)Array.get(array, index);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Object is not an Array of numeric primitive types");
        }
        return nm.longValue();
    }

    public static float getFloat(Object array, int index) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Number nm;
        Class arrayclass = array.getClass().getComponentType();
        if (arrayclass == null) {
            throw new IllegalArgumentException("Object is not an Array");
        }
        if (!arrayclass.isPrimitive()) {
            throw new IllegalArgumentException("Object is not an Array of primitive types");
        }
        if (arrayclass.toString().equals("char")) {
            return Array.getChar(array, index);
        }
        if (arrayclass.toString().equals("double")) {
            throw new IllegalArgumentException("wrong primitive array type");
        }
        try {
            nm = (Number)Array.get(array, index);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Object is not an Array of numeric primitive types");
        }
        return nm.floatValue();
    }

    public static double getDouble(Object array, int index) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
        Number nm;
        Class arrayclass = array.getClass().getComponentType();
        if (arrayclass == null) {
            throw new IllegalArgumentException("Object is not an Array");
        }
        if (!arrayclass.isPrimitive()) {
            throw new IllegalArgumentException("Object is not an Array of primitive types");
        }
        if (arrayclass.toString().equals("char")) {
            return Array.getChar(array, index);
        }
        try {
            nm = (Number)Array.get(array, index);
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Object is not an Array of numeric primitive types");
        }
        return nm.doubleValue();
    }

    public static void set(Object array, int index, Object value) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public static void setBoolean(Object array, int index, boolean z) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public static void setByte(Object array, int index, byte b) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public static void setChar(Object array, int index, char c) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public static void setShort(Object array, int index, short s) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public static void setInt(Object array, int index, int i) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public static void setLong(Object array, int index, long l) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public static void setFloat(Object array, int index, float f) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }

    public static void setDouble(Object array, int index, double d) throws NullPointerException, IllegalArgumentException, ArrayIndexOutOfBoundsException {
    }
}

