/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import java.util.LinkedList;

public class ReferenceQueue {
    private LinkedList q = new LinkedList();

    public synchronized Reference poll() {
        if (this.q.size() > 0) {
            Reference ref = (Reference)this.q.removeFirst();
            ref.queued = false;
            return ref;
        }
        return null;
    }

    public synchronized Reference remove(long timeout) throws IllegalArgumentException, InterruptedException {
        long now = System.currentTimeMillis();
        long deadline = now + timeout;
        long remaining = timeout;
        while (remaining > 0L) {
            if (this.q.size() > 0) {
                Reference ref = (Reference)this.q.removeFirst();
                ref.queued = false;
                return ref;
            }
            this.wait(remaining);
            remaining = deadline - System.currentTimeMillis();
        }
        return null;
    }

    public synchronized Reference remove() throws IllegalArgumentException, InterruptedException {
        while (true) {
            if (this.q.size() > 0) {
                Reference ref = (Reference)this.q.removeFirst();
                ref.queued = false;
                return ref;
            }
            this.wait();
        }
    }

    synchronized void append(Reference item) {
        this.q.addLast(item);
        this.notify();
    }
}

