/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

public class StringBuffer
implements Serializable {
    private static final long serialVersionUID = 3388685877147921107L;
    private char[] value;
    private int count;
    private boolean shared;

    public StringBuffer() {
        this.value = new char[16];
        this.count = 0;
    }

    public StringBuffer(int length) throws NegativeArraySizeException {
        this.value = new char[length];
        this.count = 0;
    }

    private native void createFromString(String var1);

    public StringBuffer(String string) {
        this.createFromString(string);
    }

    public int length() {
        return this.count;
    }

    public int capacity() {
        return this.value.length;
    }

    public native void ensureCapacity(int var1);

    public native void setLength(int var1) throws StringIndexOutOfBoundsException;

    public char charAt(int index) throws IndexOutOfBoundsException {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.value[index];
    }

    public native void getChars(int var1, int var2, char[] var3, int var4) throws IndexOutOfBoundsException;

    public void setCharAt(int index, char ch) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        this.value[index] = ch;
    }

    public StringBuffer append(Object obj) {
        if (obj == null) {
            return this.append("null");
        }
        return this.append(obj.toString());
    }

    public native StringBuffer append(String var1);

    public StringBuffer append(char[] str) throws NullPointerException {
        return this.append(new String(str));
    }

    public StringBuffer append(char[] str, int offset, int len) throws NullPointerException, StringIndexOutOfBoundsException {
        return this.append(new String(str, offset, len));
    }

    public StringBuffer append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public StringBuffer append(char c) {
        int idx = this.count;
        if (idx >= this.value.length) {
            this.ensureCapacity(idx + 1);
        }
        this.value[idx++] = c;
        this.count = idx;
        return this;
    }

    public StringBuffer append(int i) {
        return this.append(String.valueOf(i));
    }

    public StringBuffer append(long l) {
        return this.append(String.valueOf(l));
    }

    public StringBuffer append(float f) {
        return this.append(String.valueOf(f));
    }

    public StringBuffer append(double d) {
        return this.append(String.valueOf(d));
    }

    public native StringBuffer deleteCharAt(int var1) throws StringIndexOutOfBoundsException;

    public StringBuffer replace(int start, int end, String str) throws StringIndexOutOfBoundsException {
        if (str == null) {
            throw new NullPointerException();
        }
        if (end > this.count) {
            end = this.count;
        }
        if (start < 0 || start >= this.count || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        int l = this.count - end;
        char[] temp = null;
        if (l > 0) {
            temp = new char[l];
            this.getChars(end, this.count, temp, 0);
        }
        this.count = start;
        this.append(str);
        if (l > 0) {
            this.append(temp, 0, l);
        }
        return this;
    }

    public String substring(int start) {
        return this.substring(start, this.count);
    }

    public native String substring(int var1, int var2) throws StringIndexOutOfBoundsException;

    public StringBuffer insert(int offset, String str) throws StringIndexOutOfBoundsException {
        if (str == null) {
            str = "null";
        }
        if (offset < 0 || offset > this.count) {
            throw new StringIndexOutOfBoundsException("offset " + offset + " into StringBuffer of length " + this.count);
        }
        int l = this.count - offset;
        char[] temp = null;
        if (l > 0) {
            temp = new char[l];
            this.getChars(offset, this.count, temp, 0);
        }
        this.count = offset;
        this.append(str);
        if (l > 0) {
            this.append(temp, 0, l);
        }
        return this;
    }

    public StringBuffer insert(int offset, Object obj) throws StringIndexOutOfBoundsException {
        return this.insert(offset, String.valueOf(obj));
    }

    public StringBuffer insert(int offset, char[] str, int stroffset, int strlen) throws NullPointerException, StringIndexOutOfBoundsException {
        return this.insert(offset, new String(str, stroffset, strlen));
    }

    public StringBuffer insert(int offset, char[] str) throws NullPointerException, StringIndexOutOfBoundsException {
        return this.insert(offset, new String(str));
    }

    public StringBuffer insert(int offset, boolean b) throws StringIndexOutOfBoundsException {
        return this.insert(offset, String.valueOf(b));
    }

    public StringBuffer insert(int offset, char c) throws StringIndexOutOfBoundsException {
        return this.insert(offset, String.valueOf(c));
    }

    public StringBuffer insert(int offset, int i) throws StringIndexOutOfBoundsException {
        return this.insert(offset, String.valueOf(i));
    }

    public StringBuffer insert(int offset, long l) throws StringIndexOutOfBoundsException {
        return this.insert(offset, String.valueOf(l));
    }

    public StringBuffer insert(int offset, float f) throws StringIndexOutOfBoundsException {
        return this.insert(offset, String.valueOf(f));
    }

    public StringBuffer insert(int offset, double d) throws StringIndexOutOfBoundsException {
        return this.insert(offset, String.valueOf(d));
    }

    public native StringBuffer reverse();

    public native String toString();

    public synchronized native StringBuffer delete(int var1, int var2);
}

