/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Short
extends Number
implements Comparable {
    private static final long serialVersionUID = 7515723908773894738L;
    private final short value;
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final Class TYPE = Short.getWrappedClass();

    public Short(short value) {
        this.value = value;
    }

    public Short(String s) throws NumberFormatException {
        this.value = Short.parseShort(s);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Short) {
            return this.value == (Short)obj;
        }
        return false;
    }

    public int compareTo(Short anotherShort) {
        short other = anotherShort.value;
        if (this.value == other) {
            return 0;
        }
        if (this.value < other) {
            return -1;
        }
        return 1;
    }

    public int compareTo(Object obj) throws ClassCastException {
        return this.compareTo((Short)obj);
    }

    public int intValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public short shortValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public static String toHexString(short i) {
        return Short.unsignedToString(i, 16);
    }

    public static String toOctalString(short i) {
        return Short.unsignedToString(i, 8);
    }

    public static String toBinaryString(short i) {
        return Short.unsignedToString(i, 2);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static short parseShort(String s, int radix) throws NumberFormatException {
        int i = Integer.parseInt(s, radix);
        if (i < Short.MIN_VALUE || i > Short.MAX_VALUE) {
            throw new NumberFormatException();
        }
        return (short)i;
    }

    public static short parseShort(String s) throws NumberFormatException {
        return Short.parseShort(s, 10);
    }

    public static Short valueOf(String s, int radix) throws NumberFormatException {
        return new Short(Short.parseShort(s, radix));
    }

    public static Short valueOf(String s) throws NumberFormatException {
        return new Short(Short.parseShort(s, 10));
    }

    public static Short decode(String nm) throws NumberFormatException {
        int sign = 1;
        int skip = 0;
        int radix = 10;
        String str = "";
        if (nm.startsWith("-")) {
            sign = -1;
            skip = 1;
            str = "-";
        }
        if (nm.substring(skip).startsWith("0x")) {
            radix = 16;
            if (nm.substring(skip += 2).startsWith("-")) {
                throw new NumberFormatException("wrong position of sign");
            }
        } else if (nm.substring(skip).startsWith("#")) {
            radix = 16;
            if (nm.substring(++skip).startsWith("-")) {
                throw new NumberFormatException("wrong position of sign");
            }
        } else if (nm.substring(skip).startsWith("0")) {
            radix = 8;
            if (nm.substring(++skip).startsWith("-")) {
                throw new NumberFormatException("wrong position of sign");
            }
        }
        return new Short(Short.parseShort(str.concat(nm.substring(skip)), radix));
    }

    public static String toString(short i) {
        return String.valueOf(i);
    }

    public static String toString(short i, int radix) {
        return "wrong value";
    }

    public static String unsignedToString(short i, int radix) {
        return "wrong value";
    }

    private static native Class getWrappedClass();
}

