/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number
implements Comparable {
    private static final long serialVersionUID = -2671257302660747028L;
    private final float value;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final Class TYPE = Float.getWrappedClass();

    public Float(float value) {
        this.value = value;
    }

    public Float(double value) {
        this.value = (float)value;
    }

    public Float(String s) throws NumberFormatException {
        this(Math.floatValue(s));
    }

    public String toString() {
        return Math.toString(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            return Float.floatToIntBits(((Float)obj).value) == Float.floatToIntBits(this.value);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public int compareTo(Float anotherFloat) {
        float other_float = anotherFloat.value;
        if (this.value < other_float) {
            return -1;
        }
        if (this.value > other_float) {
            return 1;
        }
        return 0;
    }

    public int compareTo(Object obj) throws ClassCastException {
        return this.compareTo((Float)obj);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public static boolean isNaN(float v) {
        return v != v;
    }

    public boolean isNaN() {
        return this.value != this.value;
    }

    public static native boolean isInfinite(float var0);

    public boolean isInfinite() {
        return Float.isInfinite(this.value);
    }

    public static String toString(float f) {
        return Math.toString(f);
    }

    public static float parseFloat(String s) {
        return Math.floatValue(s);
    }

    public static Float valueOf(String s) throws NullPointerException, NumberFormatException {
        return new Float(Math.floatValue(s));
    }

    public static int floatToIntBits(float value) {
        return Float.floatToRawIntBits(value == value ? value : Float.NaN);
    }

    public static native int floatToRawIntBits(float var0);

    public static native float intBitsToFloat(int var0);

    private static native Class getWrappedClass();
}

