/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class StringReader
extends Reader {
    private String string;
    private int len;
    private int pos;
    private int markpos;

    public StringReader(String str) {
        this.len = str.length();
        this.string = str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.string = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int ignored) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.string == null) {
                throw new IOException("Reader is closed");
            }
            this.pos = this.markpos;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.string == null) {
                throw new IOException("Reader is closed");
            }
            if (this.pos >= this.len) {
                return -1;
            }
            return this.string.charAt(this.pos++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] chars, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.string == null) {
                throw new IOException("Reader is closed");
            }
            if (len < 0 || off < 0 || chars.length < off + len) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int rd = this.len - this.pos;
            if (rd <= 0) {
                return -1;
            }
            rd = rd > len ? len : rd;
            this.string.getChars(this.pos, this.pos + rd, chars, off);
            this.pos += rd;
            return rd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() {
        Object object = this.lock;
        synchronized (object) {
            return this.string != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.string == null) {
                throw new IOException("Reader is closed");
            }
            this.markpos = this.pos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long skip) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.string == null) {
                throw new IOException("Reader is closed");
            }
            if (skip <= 0L) {
                return 0L;
            }
            int rd = this.len - this.pos;
            rd = skip > (long)rd ? rd : (int)skip;
            this.pos += rd;
            return rd;
        }
    }
}

