/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class StringBufferInputStream
extends InputStream {
    protected String buffer;
    protected int pos;
    protected int count;
    private char[] chars;

    public int read() throws IOException {
        if (this.pos == this.count) {
            return -1;
        }
        return this.chars[this.pos++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.pos == this.count) {
            return -1;
        }
        int k = len < this.count - this.pos ? len : this.count - this.pos;
        int i = 0;
        while (i < k) {
            b[i + off] = (byte)(this.chars[this.pos++] & 0xFF);
            ++i;
        }
        return k;
    }

    public long skip(long n) throws IOException {
        long k = n < (long)(this.count - this.pos) ? n : (long)(this.count - this.pos);
        this.pos += (int)k;
        return k;
    }

    public int available() throws IOException {
        return this.count - this.pos;
    }

    public void reset() {
        this.pos = 0;
    }

    public StringBufferInputStream(String s) throws NullPointerException {
        this.buffer = s;
        this.pos = 0;
        this.count = s.length();
        this.chars = s.toCharArray();
    }
}

