/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class RandomAccessFile
implements DataOutput,
DataInput {
    private FileDescriptor fd;
    private String mode;
    private byte[] buffer = new byte[64];

    private native int createFromString(String var1, String var2);

    public RandomAccessFile(String name, String mode) throws FileNotFoundException {
        if (!mode.equals("r") && !mode.equals("rw")) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
        if (this.createFromString("." + new File(name).getAbsolutePath(), this.mode == "r" ? this.mode : "r+") != 0) {
            throw new FileNotFoundException(name + " (" + mode + ")");
        }
    }

    public RandomAccessFile(File file, String mode) throws IOException {
        if (!mode.equals("r") && !mode.equals("rw")) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
        if (this.createFromString("." + file.getAbsolutePath(), this.mode == "r" ? this.mode : "r+") != 0) {
            throw new FileNotFoundException("" + file + " (" + mode + ")");
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public native int read() throws IOException;

    private native int readIntoBuffer(byte[] var1, int var2, int var3);

    public int read(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.readIntoBuffer(b, off, len);
    }

    public int read(byte[] b) throws IOException, NullPointerException {
        if (b.length == 0) {
            return 0;
        }
        return this.readIntoBuffer(b, 0, b.length);
    }

    public final void readFully(byte[] b) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException, EOFException {
        if (this.read(b) == -1) {
            throw new EOFException();
        }
    }

    public final void readFully(byte[] b, int off, int len) throws IOException, NullPointerException, EOFException {
        if (this.read(b, off, len) == -1) {
            throw new EOFException();
        }
    }

    public native int skipBytes(int var1) throws IOException;

    public native void write(int var1) throws IOException;

    private native void writeFromBuffer(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] b) throws IOException, NullPointerException {
        if (b == null) {
            throw new NullPointerException();
        }
        this.writeFromBuffer(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.writeFromBuffer(b, off, len);
    }

    public native long getFilePointer() throws IOException;

    public native void seek(long var1) throws IOException;

    public native long length() throws IOException;

    public native void setLength(long var1) throws IOException;

    public native void close() throws IOException;

    public final boolean readBoolean() throws IOException {
        this.readFully(this.buffer, 0, 1);
        return this.buffer[0] != 0;
    }

    public final byte readByte() throws IOException {
        this.readFully(this.buffer, 0, 1);
        return this.buffer[0];
    }

    public final int readUnsignedByte() throws IOException {
        this.readFully(this.buffer, 0, 1);
        return 0 | this.buffer[0];
    }

    public final short readShort() throws IOException {
        this.readFully(this.buffer, 0, 2);
        return (short)(this.buffer[0] << 8 | this.buffer[1]);
    }

    public final int readUnsignedShort() throws IOException {
        this.readFully(this.buffer, 0, 2);
        return this.buffer[0] << 8 | this.buffer[1];
    }

    public final char readChar() throws IOException {
        this.readFully(this.buffer, 0, 2);
        return (char)(this.buffer[0] << 8 | this.buffer[1]);
    }

    public final int readInt() throws IOException {
        this.readFully(this.buffer, 0, 4);
        return (this.buffer[0] & 0xFF) << 24 | (this.buffer[1] & 0xFF) << 16 | (this.buffer[2] & 0xFF) << 8 | this.buffer[3] & 0xFF;
    }

    public final long readLong() throws IOException {
        this.readFully(this.buffer, 0, 8);
        return (long)this.buffer[0] << 56 | (long)this.buffer[1] << 48 | (long)this.buffer[2] << 40 | (long)this.buffer[3] << 32 | (long)this.buffer[4] << 24 | (long)this.buffer[5] << 16 | (long)this.buffer[6] << 8 | (long)this.buffer[7];
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final void writeBoolean(boolean v) throws IOException {
        if (v) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public final void writeByte(int v) throws IOException {
        this.write(v);
    }

    public final void writeShort(int v) throws IOException {
        this.write(v >> 8);
        this.write(v & 0xFF);
    }

    public final void writeChar(int v) throws IOException {
        this.write(v >> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public final void writeInt(int v) throws IOException {
        this.write(v >> 24 & 0xFF);
        this.write(v >> 16 & 0xFF);
        this.write(v >> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public final void writeLong(long v) throws IOException {
        this.write((int)(v >> 56 & 0xFFL));
        this.write((int)(v >> 48 & 0xFFL));
        this.write((int)(v >> 40 & 0xFFL));
        this.write((int)(v >> 32 & 0xFFL));
        this.write((int)(v >> 24 & 0xFFL));
        this.write((int)(v >> 16 & 0xFFL));
        this.write((int)(v >> 8 & 0xFFL));
        this.write((int)(v & 0xFFL));
    }

    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final String readLine() throws IOException {
        return null;
    }

    public final String readUTF() throws IOException {
        int UTFlength = this.readUnsignedShort();
        if (UTFlength < 0) {
            throw new UTFDataFormatException();
        }
        byte[] bytes = new byte[UTFlength];
        this.readFully(bytes);
        return new String(bytes, "UTF8");
    }

    public final void writeBytes(String s) throws IOException {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            this.write((byte)c[i]);
        }
    }

    public final void writeChars(String s) throws IOException {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            this.writeChar(c[i]);
        }
    }

    public final void writeUTF(String str) throws IOException {
        byte[] b = str.getBytes("UTF8");
        this.writeShort(b.length);
        this.write(b, 0, b.length);
    }

    protected void finalize() {
        try {
            if (this.fd != null) {
                this.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

