/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedWriter;
import java.io.Reader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PipedReader
extends Reader {
    private static final int pSize = 1024;
    private char[] pipe;
    private int[] pointers;
    private boolean closed;
    private Thread thread;
    private PipedWriter srcW;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                this.pipe = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(PipedWriter src) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            src.connect(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed || this.pipe == null) {
                throw new IOException();
            }
            do {
                if (this.pointers[0] != this.pointers[1]) {
                    char i = this.pipe[this.pointers[0]];
                    this.pointers[0] = (this.pointers[0] + 1) % 1024;
                    return i;
                }
                Thread.yield();
                if (!this.srcW.closed()) continue;
                return -1;
            } while (this.thread.isAlive());
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] buff, int offset, int count) throws IOException {
        if (offset < 0 || count < 0 || offset + count > buff.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            int available;
            if (this.closed || this.pipe == null) {
                throw new IOException();
            }
            while (this.pointers[0] == this.pointers[1]) {
                Thread.yield();
                if (this.srcW.closed()) {
                    if (this.pointers[0] != this.pointers[1]) break;
                    return -1;
                }
                if (this.thread.isAlive()) continue;
                throw new IOException();
            }
            available = (available = (1024 + this.pointers[1] - this.pointers[0]) % 1024) > count ? count : available;
            this.internalread(buff, offset, available);
            offset += available;
            count -= available;
            return available;
        }
    }

    private final void internalread(char[] buff, int offset, int count) {
        if (count + this.pointers[0] <= 1024) {
            System.arraycopy(this.pipe, this.pointers[0], buff, offset, count);
            this.pointers[0] = this.pointers[0] + count;
        } else {
            int nr = 1024 - this.pointers[0];
            System.arraycopy(this.pipe, this.pointers[0], buff, offset, nr);
            this.pointers[0] = 0;
            this.internalread(buff, offset + nr, count - nr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) throw new IOException();
            if (this.pipe == null) throw new IOException();
            if (!this.thread.isAlive()) {
                throw new IOException();
            }
            boolean bl = false;
            if (this.pointers[1] == this.pointers[0]) return bl;
            return true;
        }
    }

    void setPipe(char[] pp) {
        this.pipe = pp;
    }

    void setPointers(int[] ptrs) throws IOException {
        if (this.closed || this.pointers != null) {
            throw new IOException();
        }
        this.pointers = ptrs;
    }

    Thread switchThreads(Thread trd, PipedWriter src) {
        this.srcW = src;
        Thread t = this.thread;
        this.thread = trd;
        return t;
    }

    boolean closed() {
        return this.closed;
    }

    private final /* synthetic */ void this() {
        this.pipe = null;
        this.pointers = null;
        this.closed = false;
    }

    public PipedReader() {
        this.this();
        this.thread = Thread.currentThread();
    }

    public PipedReader(PipedWriter src) throws IOException {
        this.this();
        this.thread = Thread.currentThread();
        src.connect(this);
    }
}

