/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.PipedOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PipedInputStream
extends InputStream {
    protected static final int PIPE_SIZE = 1024;
    protected byte[] buffer;
    private byte[] onebuffer;
    protected int in;
    protected int out;
    PipedOutputStream src;
    private Thread producer;
    private Thread consumer;
    int readable;
    int storable;
    private boolean consumerclosed;
    volatile boolean producerclosed;

    public void connect(PipedOutputStream src) throws IOException {
        if (this.src != null || src.dst != null) {
            throw new IOException("allready connected");
        }
        this.src = src;
        src.dst = this;
    }

    public synchronized int available() throws IOException {
        if (this.consumerclosed) {
            return 0;
        }
        return this.readable;
    }

    public void close() throws IOException {
        this.consumerclosed = true;
    }

    public synchronized int read(byte[] buffer, int offset, int count) throws IOException {
        int result = 0;
        if (this.consumerclosed) {
            throw new IOException("closed");
        }
        if (this.src == null) {
            throw new IOException("unconnected");
        }
        if (this.consumer == null) {
            this.consumer = Thread.currentThread();
        }
        if (count < 0 || offset < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (count == 0) {
            return 0;
        }
        try {
            while (this.readable == 0) {
                this.wait(500L);
                if (this.producer != null && !this.producer.isAlive()) {
                    throw new IOException("no producer");
                }
                if (this.producerclosed) break;
            }
            while (this.readable > 0 && count > 0) {
                int chunk = this.in <= this.out ? 1024 - this.out : this.in - this.out;
                if (chunk > count) {
                    chunk = count;
                }
                System.arraycopy(this.buffer, this.out, buffer, offset, chunk);
                offset += chunk;
                count -= chunk;
                this.readable -= chunk;
                this.storable += chunk;
                result += chunk;
                this.out += chunk;
                if (this.out == 1024) {
                    this.out = 0;
                }
                if (this.out != this.in) continue;
                this.out = 0;
                this.in = -1;
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptedIOException();
        }
        this.notify();
        return result == 0 ? -1 : result;
    }

    public synchronized int read() throws IOException {
        int result = this.read(this.onebuffer, 0, 1);
        if (result == 1) {
            return 0xFF & this.onebuffer[0];
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    synchronized void receive(byte[] buffer, int offset, int count) throws IOException {
        if (this.consumerclosed) {
            throw new IOException("closed");
        }
        if (this.producer == null) {
            this.producer = Thread.currentThread();
        }
        if (this.consumer == null || this.consumer.isAlive()) ** GOTO lbl33
        this.consumerclosed = true;
        throw new IOException("consumer dead");
lbl-1000:
        // 1 sources

        {
            try {
                while (this.storable == 0) {
                    this.readable = 1024;
                    this.notify();
                    this.wait(500L);
                    if (this.consumerclosed) {
                        throw new IOException("closed");
                    }
                    if (this.consumer == null || this.consumer.isAlive()) continue;
                    this.consumerclosed = true;
                    throw new IOException("consumer dead");
                }
                if (this.in < 0) {
                    this.in = 0;
                }
                if (count < (chunk = this.in < this.out ? this.out - this.in : 1024 - this.in)) {
                    chunk = count;
                }
                System.arraycopy(buffer, offset, this.buffer, this.in, chunk);
                offset += chunk;
                count -= chunk;
                this.readable += chunk;
                this.storable -= chunk;
                this.in += chunk;
                if (this.in != 1024) continue;
                this.in = 0;
                continue;
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException();
            }
lbl33:
            // 3 sources

            ** while (count > 0)
        }
lbl34:
        // 1 sources

    }

    protected synchronized void receive(int oneByte) throws IOException {
        this.onebuffer[0] = (byte)(oneByte & 0xFF);
        this.receive(this.onebuffer, 0, 1);
    }

    private final /* synthetic */ void this() {
        this.buffer = new byte[1024];
        this.onebuffer = new byte[1];
        this.storable = 1024;
    }

    public PipedInputStream(PipedOutputStream src) throws IOException {
        this.this();
        this.connect(src);
    }

    public PipedInputStream() {
        this.this();
    }
}

