/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Vector;
import wonka.decoders.UTF8Decoder;
import wonka.vm.ArrayUtil;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int BUFFERSIZE = 1024;
    private int dataPointer;
    private byte[] buffer;
    private int available;
    private InputStream in;
    private Vector objectCache;
    private Vector objectValidaters;
    private boolean enableReplaceObject;
    private boolean override;
    private final Object[] args;
    private Object current;
    private ObjectStreamClass currentOSC;
    private ClassLoader currentLoader;

    protected ObjectInputStream() throws IOException {
        this.args = new Object[1];
        this.args[0] = this;
        this.override = true;
    }

    public ObjectInputStream(InputStream in) throws IOException, StreamCorruptedException {
        this.in = in;
        this.buffer = new byte[1024];
        this.objectCache = new Vector();
        this.args = new Object[1];
        this.args[0] = this;
        this.readStreamHeader();
    }

    public int available() throws IOException {
        if (this.dataPointer >= this.available) {
            return 0;
        }
        return this.available - this.dataPointer;
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - void declaration
     */
    public void defaultReadObject() throws IOException, NotActiveException, ClassNotFoundException {
        ObjectStreamClass osc = this.currentOSC;
        Object obj = this.current;
        ObjectStreamField[] fields = osc.osFields;
        int length = fields.length;
        byte[] buf = this.buffer;
        for (int i = 0; i < length; ++i) {
            ObjectStreamField field = fields[i];
            switch (field.code) {
                case 'L': 
                case '[': {
                    Object value = this.readObject();
                    break;
                }
                case 'I': {
                    this.available = 0;
                    this.getBytes(buf, 4);
                    Object value = new Integer(ArrayUtil.bArrayToI(buf, 0));
                    break;
                }
                case 'Z': {
                    this.available = 0;
                    int iv = this.in.read();
                    if (iv == -1) {
                        throw new EOFException();
                    }
                    Object value = new Boolean(iv != 0);
                    break;
                }
                case 'F': {
                    this.available = 0;
                    this.getBytes(buf, 4);
                    Object value = new Float(ArrayUtil.bArrayToF(buf, 0));
                    break;
                }
                case 'B': {
                    this.available = 0;
                    int iv = this.in.read();
                    if (iv == -1) {
                        throw new EOFException();
                    }
                    Object value = new Byte((byte)iv);
                    break;
                }
                case 'J': {
                    this.available = 0;
                    this.getBytes(buf, 8);
                    Object value = new Long(ArrayUtil.bArrayToL(buf, 0));
                    break;
                }
                case 'C': {
                    this.available = 0;
                    this.getBytes(buf, 2);
                    int iv = buf[0] << 8 | buf[1] & 0xFF;
                    Object value = new Character((char)iv);
                    break;
                }
                case 'S': {
                    this.available = 0;
                    this.getBytes(buf, 2);
                    int iv = buf[0] << 8 | buf[1] & 0xFF;
                    Object value = new Short((short)iv);
                    break;
                }
                case 'D': {
                    this.available = 0;
                    this.getBytes(buf, 8);
                    Object value = new Double(ArrayUtil.bArrayToD(buf, 0));
                    break;
                }
                default: {
                    throw new IOException("unexpected field code " + field.code);
                }
            }
            Field f = field.field;
            if (f == null) continue;
            try {
                void var8_8;
                f.set(obj, var8_8);
                continue;
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        boolean b = this.enableReplaceObject;
        this.enableReplaceObject = enable;
        return b;
    }

    public int read() throws IOException {
        int dp;
        if (this.available <= this.dataPointer) {
            try {
                this.fill();
            }
            catch (EOFException eof) {
                return -1;
            }
        }
        if (this.available <= (dp = this.dataPointer++)) {
            return -1;
        }
        return this.buffer[dp] & 0xFF;
    }

    public int read(byte[] b, int off, int size) throws IOException {
        int dp;
        int total;
        if (this.available <= this.dataPointer) {
            try {
                this.fill();
            }
            catch (EOFException eof) {
                return -1;
            }
        }
        if (size > (total = this.available - (dp = this.dataPointer))) {
            size = total;
        }
        System.arraycopy(this.buffer, dp, b, off, size);
        this.dataPointer += size;
        return size;
    }

    public boolean readBoolean() throws IOException {
        int dp;
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        if ((dp = this.dataPointer++) >= this.available) {
            throw new EOFException();
        }
        return this.buffer[dp] != 0;
    }

    public byte readByte() throws IOException {
        int dp;
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        if ((dp = this.dataPointer++) >= this.available) {
            throw new EOFException();
        }
        return this.buffer[dp];
    }

    public char readChar() throws IOException {
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        int dp = this.dataPointer;
        byte[] buf = this.buffer;
        int total = this.available - dp;
        this.dataPointer += 2;
        if (total < 2) {
            throw new EOFException();
        }
        int ch = buf[dp++] << 8;
        return (char)(ch | buf[dp] & 0xFF);
    }

    /*
     * WARNING - void declaration
     */
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        byte[] buf = this.buffer;
        this.getBytes(buf, 2);
        int len = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
        if (len + 11 > buf.length) {
            this.buffer = buf = new byte[len + 11];
        }
        this.getBytes(buf, len + 11);
        String name = UTF8Decoder.bToString(buf, 0, len);
        long suid = ArrayUtil.bArrayToL(buf, len);
        len += 8;
        ObjectStreamClass osc = new ObjectStreamClass(name, suid, buf[len++]);
        this.objectCache.addElement(osc);
        int mask = 255;
        int nrFields = (buf[len++] & mask) << 8;
        ObjectStreamField[] fields = new ObjectStreamField[nrFields |= buf[len] & mask];
        for (int i = 0; i < nrFields; ++i) {
            void var13_12;
            this.getBytes(buf, 3);
            byte b = buf[0];
            len = (buf[1] & mask) << 8 | buf[2] & mask;
            if (len > buf.length) {
                this.buffer = buf = new byte[len];
            }
            this.getBytes(buf, len);
            String fname = UTF8Decoder.bToString(buf, 0, len);
            switch (b) {
                case 76: 
                case 91: {
                    String desc = this.desc2Name((String)this.readObject());
                    break;
                }
                case 73: {
                    String desc = "int";
                    break;
                }
                case 74: {
                    String desc = "long";
                    break;
                }
                case 90: {
                    String desc = "boolean";
                    break;
                }
                case 70: {
                    String desc = "float";
                    break;
                }
                case 66: {
                    String desc = "byte";
                    break;
                }
                case 67: {
                    String desc = "char";
                    break;
                }
                case 83: {
                    String desc = "short";
                    break;
                }
                case 68: {
                    String desc = "double";
                    break;
                }
                default: {
                    throw new StreamCorruptedException("bad field type " + Integer.toHexString(b));
                }
            }
            fields[i] = new ObjectStreamField(fname, (String)var13_12, (char)b);
        }
        osc.osFields = fields;
        osc.clazz = this.resolveClass(osc);
        int rd = this.in.read();
        if (rd != 120) {
            throw new StreamCorruptedException("TC_ENDBLOCKDATA not found got " + Integer.toHexString(rd));
        }
        osc.verifyInput();
        osc.parent = (ObjectStreamClass)this.readObject();
        return osc;
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public GetField readFields() throws NotActiveException, IOException, ClassNotFoundException {
        return null;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public void readFully(byte[] data) throws IOException {
        this.readFully(data, 0, data.length);
    }

    public void readFully(byte[] data, int offset, int size) throws IOException {
        int dp;
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        if (size > this.available - (dp = this.dataPointer)) {
            throw new EOFException();
        }
        System.arraycopy(this.buffer, dp, data, offset, size);
        this.dataPointer += size;
    }

    public int readInt() throws IOException {
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        int dp = this.dataPointer;
        byte[] buf = this.buffer;
        int total = this.available - dp;
        this.dataPointer += 4;
        if (total < 4) {
            throw new EOFException();
        }
        return ArrayUtil.bArrayToI(buf, dp);
    }

    public String readLine() throws IOException {
        return null;
    }

    public long readLong() throws IOException {
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        int dp = this.dataPointer;
        byte[] buf = this.buffer;
        int total = this.available - dp;
        this.dataPointer += 8;
        if (total < 8) {
            throw new EOFException();
        }
        return ArrayUtil.bArrayToL(buf, dp);
    }

    /*
     * WARNING - void declaration
     */
    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        void var1_9;
        void var4_19;
        void var7_20;
        if (this.override) {
            return this.readObjectOverride();
        }
        int rd = this.in.read();
        this.available = 0;
        switch (rd) {
            case 112: {
                return null;
            }
            case 113: {
                byte[] buf = this.buffer;
                this.getBytes(buf, 4);
                int handle = ArrayUtil.bArrayToI(buf, 0);
                return this.objectCache.get(handle - 0x7E0000);
            }
            case 114: {
                ClassLoader cl = this.currentLoader;
                if (cl == null) {
                    this.currentLoader = this.getCallingClassLoader();
                }
                ObjectStreamClass osc = this.readClassDescriptor();
                this.currentLoader = cl;
                return osc;
            }
            case 117: {
                Object o;
                ClassLoader cl = this.currentLoader;
                if (cl == null) {
                    this.currentLoader = this.getCallingClassLoader();
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                this.available = 0;
                byte[] buf = this.buffer;
                this.getBytes(buf, 4);
                int length = ArrayUtil.bArrayToI(buf, 0);
                Class clz = osc.clazz.getComponentType();
                if (clz == null) {
                    throw new StreamCorruptedException("TC_ARRAY encountered but no Array on the stream");
                }
                Vector cache = this.objectCache;
                int place = cache.size();
                Method readResolve = null;
                if (clz.isPrimitive()) {
                    o = this.createPrimitiveArray(clz, length);
                    cache.addElement(o);
                } else {
                    o = Array.newInstance(clz, length);
                    cache.addElement(o);
                    Object[] oa = (Object[])o;
                    for (int i = 0; i < length; ++i) {
                        oa[i] = this.readObject();
                    }
                }
                this.currentLoader = cl;
                break;
            }
            case 124: {
                byte[] buf = this.buffer;
                ClassLoader cl = this.currentLoader;
                this.getBytes(buf, 8);
                int size = ArrayUtil.bArrayToI(buf, 4);
                byte[] bytes = new byte[size];
                this.getBytes(bytes, size);
                Object o = UTF8Decoder.bToString(bytes, 0, size);
                Vector cache = this.objectCache;
                int place = cache.size();
                cache.addElement(o);
                Method readResolve = null;
                break;
            }
            case 116: {
                byte[] buf = this.buffer;
                ClassLoader cl = this.currentLoader;
                this.getBytes(buf, 2);
                int size = (buf[0] & 0xFF) << 8 | buf[1] & 0xFF;
                if (size > buf.length) {
                    this.buffer = buf = new byte[size];
                }
                this.getBytes(buf, size);
                Object o = UTF8Decoder.bToString(buf, 0, size);
                Vector cache = this.objectCache;
                int place = cache.size();
                cache.addElement(o);
                Method readResolve = null;
                break;
            }
            case 115: {
                ClassLoader cl = this.currentLoader;
                if (cl == null) {
                    this.currentLoader = this.getCallingClassLoader();
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                Object o = this.allocNewInstance(osc.clazz);
                Method readResolve = osc.readResolve;
                Vector cache = this.objectCache;
                int place = cache.size();
                cache.addElement(o);
                Object tmp = this.current;
                ObjectStreamClass tmpOSC = this.currentOSC;
                this.currentOSC = osc;
                this.current = o;
                if ((osc.flags & 4) > 0) {
                    ((Externalizable)o).readExternal(this);
                } else {
                    int size = 128;
                    ObjectStreamClass[] array = new ObjectStreamClass[size];
                    int i = 0;
                    do {
                        if (i == size) {
                            ObjectStreamClass[] newArray = new ObjectStreamClass[size *= 2];
                            System.arraycopy(array, 0, newArray, 0, i);
                            array = newArray;
                        }
                        array[i++] = osc;
                    } while ((osc = osc.parent) != null);
                    do {
                        this.currentOSC = osc = array[--i];
                        Method readObject = osc.readObject;
                        this.currentOSC = osc;
                        if (readObject == null) {
                            this.defaultReadObject();
                        } else {
                            try {
                                readObject.invoke(o, this.args);
                            }
                            catch (InvocationTargetException ite) {
                                this.handleException(ite.getTargetException());
                            }
                            catch (IllegalAccessException iae) {
                                this.handleException(iae);
                            }
                        }
                        if ((osc.flags & 1) <= 0 || this.in.read() == 120) continue;
                        throw new StreamCorruptedException("TC_ENDBLOCKDATA not found");
                    } while (i > 0);
                }
                this.currentLoader = cl;
                this.current = tmp;
                this.currentOSC = tmpOSC;
                break;
            }
            case 118: {
                ClassLoader cl = this.currentLoader;
                if (cl == null) {
                    this.currentLoader = this.getCallingClassLoader();
                }
                ObjectStreamClass osc = (ObjectStreamClass)this.readObject();
                Class clazz = osc.clazz;
                this.objectCache.addElement(clazz);
                this.currentLoader = cl;
                return clazz;
            }
            case 119: {
                rd = this.in.read();
                if (rd == -1) {
                    throw new EOFException();
                }
                throw new OptionalDataException(rd);
            }
            case 122: {
                byte[] buf = this.buffer;
                this.getBytes(buf, 4);
                throw new OptionalDataException(ArrayUtil.bArrayToI(buf, 0));
            }
            case 121: {
                ClassLoader cl = this.currentLoader;
                if (cl == null) {
                    this.currentLoader = this.getCallingClassLoader();
                }
                this.objectCache.clear();
                return this.readObject();
            }
            case 123: {
                this.objectCache.clear();
                Exception e = (Exception)this.readObject();
                throw new WriteAbortedException("Aborting serialization ", e);
            }
            case -1: {
                throw new EOFException("no objects on stream");
            }
            default: {
                throw new StreamCorruptedException("unkown case in readObject: byte " + Integer.toHexString(rd));
            }
        }
        Object rplc = var7_20;
        if (var4_19 != null) {
            try {
                rplc = var4_19.invoke(var7_20, ObjectOutputStream.NO_ARGS);
            }
            catch (Exception ite) {
                // empty catch block
            }
        }
        if (this.enableReplaceObject) {
            rplc = this.resolveObject(rplc);
        }
        if (rplc != var7_20) {
            void var6_18;
            void var5_17;
            var5_17.setElementAt(rplc, (int)var6_18);
        }
        if (var1_9 == null && this.objectValidaters != null) {
            Vector list = this.objectValidaters;
            int l = list.size();
            Object[] array = new ObjectInputValidation[l];
            list.toArray(array);
            for (int i = 0; i < l; ++i) {
                array[i].validateObject();
            }
        }
        return rplc;
    }

    protected Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        return null;
    }

    public short readShort() throws IOException {
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        int dp = this.dataPointer;
        byte[] buf = this.buffer;
        int total = this.available - dp;
        this.dataPointer += 2;
        if (total < 2) {
            throw new EOFException();
        }
        int sh = buf[dp++] << 8;
        return (short)(sh | buf[dp] & 0xFF);
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        byte[] buf = this.buffer;
        this.getBytes(buf, 4);
        if (buf[0] != -84 || buf[1] != -19 || buf[2] != 0 || buf[3] != 5) {
            throw new StreamCorruptedException("bad stream header encountered");
        }
    }

    public int readUnsignedByte() throws IOException {
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        int dp = this.dataPointer++;
        byte[] buf = this.buffer;
        if (this.available <= dp) {
            throw new EOFException();
        }
        return buf[dp] & 0xFF;
    }

    public int readUnsignedShort() throws IOException {
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        int dp = this.dataPointer;
        byte[] buf = this.buffer;
        int total = this.available - dp;
        this.dataPointer += 2;
        if (total < 2) {
            throw new EOFException();
        }
        int sh = (buf[dp++] & 0xFF) << 8;
        return sh | buf[dp] & 0xFF;
    }

    public String readUTF() throws IOException {
        if (this.available <= this.dataPointer) {
            this.fill();
        }
        int dp = this.dataPointer;
        byte[] buf = this.buffer;
        int total = this.available - dp;
        if (total < 2) {
            this.available = 0;
            throw new EOFException();
        }
        int length = (buf[dp++] & 0xFF) << 8;
        if (total - 2 < (length |= buf[dp++] & 0xFF)) {
            this.available = 0;
            throw new EOFException();
        }
        this.dataPointer = dp + length;
        return UTF8Decoder.bToString(buf, dp, length);
    }

    public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        if (this.currentLoader == null) {
            throw new NotActiveException();
        }
        if (obj == null) {
            throw new InvalidObjectException("null object is not allowed as ObjectInputValidation");
        }
        if (this.objectValidaters == null) {
            this.objectValidaters = new Vector();
        }
        this.objectValidaters.addElement(obj);
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        return Class.forName(osc.name, false, this.currentLoader);
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        int length = interfaces.length;
        Class[] classes = new Class[length];
        ClassLoader cl = this.currentLoader;
        for (int i = 0; i < length; ++i) {
            Class.forName(interfaces[i], false, cl);
        }
        return Proxy.getProxyClass(cl, classes);
    }

    public int skipBytes(int len) throws IOException {
        int skip;
        if (this.available <= this.dataPointer) {
            try {
                this.fill();
            }
            catch (EOFException eof) {
                return 0;
            }
        }
        if (len < (skip = this.available - this.dataPointer)) {
            skip = len;
        }
        this.dataPointer += skip;
        return skip;
    }

    private void fill() throws IOException {
        this.dataPointer = 0;
        int rd = this.in.read();
        switch (rd) {
            case 119: {
                rd = this.in.read();
                if (rd == -1) {
                    throw new EOFException();
                }
                this.getBytes(this.buffer, rd);
                this.available = rd;
                break;
            }
            case 122: {
                byte[] buf = this.buffer;
                this.getBytes(buf, 4);
                int size = ArrayUtil.bArrayToI(buf, 0);
                if (size > buf.length) {
                    this.buffer = buf = new byte[size];
                }
                this.getBytes(buf, size);
                this.available = size;
                break;
            }
            default: {
                throw new StreamCorruptedException("expected TC_BLOCKDATA or TC_BLOCKDATALONG but got " + rd);
            }
        }
    }

    private void getBytes(byte[] buf, int len) throws IOException {
        int off = 0;
        int rd = this.in.read(buf, off, len);
        while (rd < len) {
            if (rd == -1) {
                throw new EOFException();
            }
            rd = this.in.read(buf, off += rd, len -= rd);
        }
    }

    private native Object createPrimitiveArray(Class var1, int var2);

    private native ClassLoader getCallingClassLoader();

    private native Object allocNewInstance(Class var1) throws IOException;

    private void handleException(Throwable e) throws IOException {
        throw new StreamCorruptedException("stream got corrupted by " + e);
    }

    private String desc2Name(String desc) {
        if (desc.charAt(0) != '[') {
            desc = desc.substring(1, desc.length() - 1);
        }
        String name = desc.replace('/', '.');
        return name;
    }

    public static abstract class GetField {
        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract ObjectStreamClass getObjectStreamClass();
    }
}

