/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.GetSystemProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import wonka.decoders.Decoder;

public class InputStreamReader
extends Reader {
    private static final String default_encoding = GetSystemProperty.FILE_ENCODING;
    private InputStream in;
    private Decoder decoder;

    public InputStreamReader(InputStream bytestream) {
        super(bytestream);
        this.decoder = Decoder.getDefault(default_encoding);
        this.in = bytestream;
    }

    public InputStreamReader(InputStream bytestream, String enc) throws UnsupportedEncodingException {
        super(bytestream);
        this.decoder = Decoder.get(enc);
        this.in = bytestream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
    }

    public String getEncoding() {
        return this.decoder.getEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException();
            }
            return this.decoder.getChar(this.in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException();
            }
            return this.decoder.cFromStream(this.in, buf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException();
            }
            return this.in.available() > 0;
        }
    }
}

