/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;

    private native int createFromString(String var1, boolean var2);

    private native void createFromFileDescriptor(FileDescriptor var1) throws SecurityException;

    private static void permissionCheck(String path) {
    }

    public FileOutputStream(String path) throws SecurityException, FileNotFoundException {
        FileOutputStream.permissionCheck(path);
        if (this.createFromString("." + new File(path).getAbsolutePath(), false) != 0) {
            throw new FileNotFoundException(path);
        }
    }

    public FileOutputStream(String path, boolean append) throws SecurityException, FileNotFoundException {
        FileOutputStream.permissionCheck(path);
        if (this.createFromString("." + new File(path).getAbsolutePath(), append) != 0) {
            throw new FileNotFoundException(path + " (" + append + ")");
        }
    }

    public FileOutputStream(File file) throws SecurityException, FileNotFoundException {
        FileOutputStream.permissionCheck(file.toString());
        if (this.createFromString("." + file.getAbsolutePath(), false) != 0) {
            throw new FileNotFoundException("" + file);
        }
    }

    public FileOutputStream(FileDescriptor fdObj) throws SecurityException {
        this.fd = fdObj;
        this.createFromFileDescriptor(fdObj);
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    public synchronized native void write(int var1) throws IOException;

    private synchronized native void writeFromBuffer(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] b) throws IOException, NullPointerException {
        this.writeFromBuffer(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException, NullPointerException, ArrayIndexOutOfBoundsException {
        this.writeFromBuffer(b, off, len);
    }

    public synchronized native void close() throws IOException;

    protected void finalize() throws IOException {
        if (this.fd != null) {
            this.close();
        }
    }

    public native void flush() throws IOException;
}

