/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import wonka.vm.ArrayUtil;

public class DataOutputStream
extends FilterOutputStream
implements DataOutput {
    protected int written;
    private byte[] buffer = new byte[8];

    public DataOutputStream(OutputStream out) {
        super(out);
    }

    public synchronized void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.written += len;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public final void writeBoolean(boolean bool) throws IOException {
        this.out.write(bool ? 1 : 0);
        ++this.written;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeByte(int v) throws IOException {
        this.out.write(v);
        ++this.written;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeShort(int sh) throws IOException {
        this.out.write(sh >> 8 & 0xFF);
        this.out.write(sh & 0xFF);
        this.written += 2;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeChar(int ch) throws IOException {
        this.out.write(ch >> 8);
        this.out.write(ch);
        this.written += 2;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeInt(int i) throws IOException {
        ArrayUtil.iInBArray(i, this.buffer, 0);
        this.out.write(this.buffer, 0, 4);
        this.written += 4;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeLong(long l) throws IOException {
        ArrayUtil.lInBArray(l, this.buffer, 0);
        this.out.write(this.buffer, 0, 8);
        this.written += 8;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeFloat(float f) throws IOException {
        ArrayUtil.fInBArray(f, this.buffer, 0);
        this.out.write(this.buffer, 0, 4);
        this.written += 4;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeDouble(double f) throws IOException {
        ArrayUtil.dInBArray(f, this.buffer, 0);
        this.out.write(this.buffer, 0, 8);
        this.written += 8;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeBytes(String s) throws IOException {
        byte[] b = s.getBytes("latin1");
        int len = b.length;
        this.out.write(b, 0, len);
        this.written += len;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeChars(String s) throws IOException {
        char[] ca = s.toCharArray();
        int len = ca.length;
        for (int i = 0; i < len; ++i) {
            this.out.write(ca[i] >> 8);
            this.out.write(ca[i]);
        }
        this.written += 2 * len;
        if (this.written < 0) {
            this.written = Integer.MAX_VALUE;
        }
    }

    public final void writeUTF(String s) throws IOException {
        byte[] b = s.getBytes("UTF8");
        this.writeShort(b.length);
        this.write(b, 0, b.length);
    }

    public final int size() {
        return this.written;
    }
}

