/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int count;
    protected int markedPos;
    protected int pos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("cannot read from a closed Stream");
            }
            if (this.pos >= this.count) {
                return -1;
            }
            return this.buf[this.pos++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(char[] chars, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > chars.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("cannot read from a closed Stream");
            }
            if (this.pos >= this.count) {
                return -1;
            }
            int rd = this.count - this.pos;
            rd = rd > len ? len : rd;
            System.arraycopy(this.buf, this.pos, chars, off, rd);
            this.pos += rd;
            return rd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("cannot read from a closed Stream");
            }
            if (this.pos >= this.count) {
                return 0L;
            }
            int skip = this.count - this.pos;
            skip = (long)skip > n ? (int)n : skip;
            this.pos += skip;
            return skip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("cannot read from a closed Stream");
            }
            boolean bl = false;
            if (this.pos >= this.count) return bl;
            return true;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mark(int readAheadLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("cannot read from a closed Stream");
            }
            this.markedPos = this.pos;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.buf == null) {
                throw new IOException("cannot read from a closed Stream");
            }
            this.pos = this.markedPos;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.buf = null;
            return;
        }
    }

    public CharArrayReader(char[] chars) {
        this(chars, 0, chars.length);
    }

    public CharArrayReader(char[] chars, int off, int len) {
        if (off < 0 || len < 0 || off > chars.length) {
            throw new IllegalArgumentException();
        }
        this.buf = chars;
        this.count = chars.length < len + off ? chars.length : len + off;
        this.pos = off;
        this.markedPos = off;
    }
}

