/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.GetSystemProperty;
import java.io.IOException;
import java.io.Writer;

public class BufferedWriter
extends Writer {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private int bufsize;
    private int bufcounter;
    private char[] buf;
    private boolean closed = false;
    private Writer out;
    private String line_separator;

    public BufferedWriter(Writer out) {
        this(out, 8192);
    }

    public BufferedWriter(Writer out, int size) {
        super(out);
        if (size < 1) {
            throw new IllegalArgumentException();
        }
        this.out = out;
        this.bufsize = size;
        this.bufcounter = 0;
        this.buf = new char[this.bufsize];
        this.line_separator = GetSystemProperty.LINE_SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                this.buf = null;
                this.out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException();
            }
            this.out.write(this.buf, 0, this.bufcounter);
            this.bufcounter = 0;
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException();
            }
            this.write(this.line_separator, 0, this.line_separator.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int oneChar) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException();
            }
            if (this.bufcounter == this.bufsize) {
                this.out.write(this.buf);
                this.buf[0] = (char)oneChar;
                this.bufcounter = 1;
            } else {
                this.buf[this.bufcounter++] = (char)oneChar;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cbuf, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException();
            }
            if (offset < 0 || count < 0 || offset + count > cbuf.length) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (count >= this.bufsize) {
                if (this.bufcounter != 0) {
                    this.out.write(this.buf, 0, this.bufcounter);
                    this.bufcounter = 0;
                }
                this.out.write(cbuf, offset, count);
            } else if (this.bufcounter + count < this.bufsize) {
                System.arraycopy(cbuf, offset, this.buf, this.bufcounter, count);
                this.bufcounter += count;
                if (this.bufcounter >= this.bufsize) {
                    this.out.write(this.buf);
                    this.bufcounter = 0;
                }
            } else {
                int help = this.bufsize - this.bufcounter;
                System.arraycopy(cbuf, offset, this.buf, this.bufcounter, help);
                this.out.write(this.buf);
                this.bufcounter = count - help;
                System.arraycopy(cbuf, offset + help, this.buf, 0, this.bufcounter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String str, int offset, int count) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException();
            }
            if (offset < 0 || count < 0 || offset + count > str.length()) {
                throw new StringIndexOutOfBoundsException();
            }
            if (this.bufcounter + count < this.bufsize) {
                str.getChars(offset, offset + count, this.buf, this.bufcounter);
                this.bufcounter += count;
                if (this.bufcounter >= this.bufsize) {
                    this.out.write(this.buf);
                    this.bufcounter = 0;
                }
            } else {
                int help = this.bufsize - this.bufcounter;
                str.getChars(offset, offset + help, this.buf, this.bufcounter);
                this.out.write(this.buf);
                count -= help;
                offset += help;
                while (count >= this.bufsize) {
                    str.getChars(offset, offset + this.bufsize, this.buf, 0);
                    this.out.write(this.buf);
                    count -= this.bufsize;
                    offset += this.bufsize;
                }
                str.getChars(offset, offset + count, this.buf, 0);
                this.bufcounter = count;
            }
        }
    }
}

