/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

public abstract class DataBuffer {
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_SHORT = 4;
    public static final int TYPE_UNDEFINED = 5;
    public static final int TYPE_USHORT = 6;
    protected int banks;
    protected int dataType;
    protected int offset;
    protected int[] offsets;
    protected int size;

    public abstract int getElem(int var1, int var2);

    public abstract void setElem(int var1, int var2, int var3);

    public int getDataType() {
        return this.dataType;
    }

    public static int getDataTypeSize(int type) {
        int size = 0;
        switch (type) {
            case 0: {
                size = 8;
                break;
            }
            case 1: {
                size = 64;
                break;
            }
            case 2: 
            case 3: {
                size = 32;
                break;
            }
            case 4: 
            case 6: {
                size = 16;
                break;
            }
        }
        return size;
    }

    public int getElem(int i) {
        return 0;
    }

    public double getElemDouble(int i) {
        return this.getElem(i);
    }

    public double getElemDouble(int bank, int i) {
        return this.getElem(bank, i);
    }

    public float getElemFloat(int i) {
        return this.getElem(i);
    }

    public float getElemFloat(int bank, int i) {
        return this.getElem(bank, i);
    }

    public int getNumBanks() {
        return this.banks;
    }

    public int getOffset() {
        return this.offset;
    }

    public int[] getOffsets() {
        return this.offsets;
    }

    public int getSize() {
        return this.size;
    }

    public void setElem(int i, int val) {
    }

    public void setElemDouble(int i, double val) {
        this.setElem(i, (int)val);
    }

    public void setElemDouble(int bank, int i, double val) {
        this.setElem(bank, i, (int)val);
    }

    public void setElemFloat(int i, float val) {
        this.setElem(i, (int)val);
    }

    public void setElemFloat(int bank, int i, float val) {
        this.setElem(bank, i, (int)val);
    }

    protected DataBuffer(int dataType, int size, int numBanks, int[] offsets) {
        this.dataType = dataType;
        this.size = size;
        this.banks = numBanks;
        this.offset = offsets[0];
        this.offsets = offsets;
    }

    protected DataBuffer(int dataType, int size, int numBanks, int offset) {
        this(dataType, size, numBanks, new int[]{offset});
    }

    protected DataBuffer(int dataType, int size, int numBanks) {
        this(dataType, size, numBanks, 0);
    }

    protected DataBuffer(int dataType, int size) {
        this(dataType, size, 1);
    }
}

