/*
 * Decompiled with CFR 0.152.
 */
package java.awt.event;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;

public class MouseEvent
extends InputEvent {
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_LAST = 506;
    public static final int MOUSE_RELEASED_AFTER_DRAG = 510;
    private int x;
    private int y;
    private int clickCount;
    private boolean popupTrigger;

    public MouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger) {
        super(source, id);
        this.timeStamp = when;
        this.modifiers = modifiers;
        this.x = x;
        this.y = y;
        this.clickCount = clickCount;
        this.popupTrigger = popupTrigger;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public synchronized void translatePoint(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public boolean isPopupTrigger() {
        return this.popupTrigger;
    }

    public String toString() {
        String descriptor = this.getClass().getName();
        descriptor = this.id == 500 ? descriptor + "[MOUSE_CLICKED" : (this.id == 501 ? descriptor + "[MOUSE_PRESSED" : (this.id == 502 ? descriptor + "[MOUSE_RELEASED" : (this.id == 503 ? descriptor + "[MOUSE_MOVED" : (this.id == 504 ? descriptor + "[MOUSE_ENTERED" : (this.id == 505 ? descriptor + "[MOUSE_EXITED" : (this.id == 506 ? descriptor + "[MOUSE_DRAGGED" : descriptor + "[UNKNOWN EVENT " + this.id))))));
        descriptor = descriptor + " position (" + this.x + ", " + this.y + ")] on " + this.source;
        return descriptor;
    }

    public String paramString() {
        return this.getClass().getName() + "[source=" + this.source + ", id=" + this.id + ", time=" + this.timeStamp + ", position=(" + this.x + ", " + this.y + "), modifiers=" + this.modifiers + ", popup=" + this.popupTrigger + "]";
    }
}

