/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.WindowPeer;
import java.util.Vector;

public class Window
extends Container {
    private WindowListener windowListener;
    private String warningString;
    private Vector windowList;
    private boolean showed;
    private Frame owner;
    private Component focusOwner;
    private boolean disposed = false;

    public Window() {
        this.setVisible(false);
        this.windowList = new Vector();
        this.warningString = "";
        this.owner = null;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public Color getForeground() {
        Color result = super.getForeground();
        return result != null ? result : new SystemColor(9);
    }

    public Color getBackground() {
        Color result = super.getBackground();
        return result != null ? result : new SystemColor(7);
    }

    public Window(Frame frame) {
        this();
        if (frame == null) {
            throw new IllegalArgumentException("the owner frame is null");
        }
        this.owner = frame;
        this.parent = this.owner;
        frame.addWindow(this);
        this.postWindowEvent(200);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validateTree();
            this.toFront();
            if (!this.showed) {
                this.showed = true;
                this.postWindowEvent(200);
            } else {
                this.postWindowEvent(204);
            }
        } else {
            this.postWindowEvent(203);
        }
    }

    public boolean isShowing() {
        return this.visible;
    }

    public synchronized void addWindowListener(WindowListener listener) {
        if (listener != null) {
            this.windowListener = AWTEventMulticaster.add(this.windowListener, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        Object object = this.getTreeLock();
        synchronized (object) {
            this.setVisible(false);
            if (this.owner != null) {
                this.owner.removeWindow(this);
            }
            ((WindowPeer)this.peer).dispose();
            this.postWindowEvent(202);
        }
    }

    protected void dispatchEventImpl(AWTEvent event) {
        super.dispatchEventImpl(event);
        if (event instanceof FocusEvent) {
            switch (event.getID()) {
                case 1004: {
                    this.postWindowEvent(205);
                    this.focusOwner = this;
                    break;
                }
                case 1005: {
                    this.postWindowEvent(206);
                    this.focusOwner = null;
                }
            }
        }
    }

    public Component getFocusOwner() {
        return this.focusOwner;
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    public void pack() {
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    synchronized void postWindowEvent(int id) {
        if (this.windowListener != null) {
            this.processWindowEvent(new WindowEvent(this, id));
        }
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processWindowEvent(WindowEvent event) {
        if (this.windowListener != null) {
            switch (event.getID()) {
                case 205: {
                    this.windowListener.windowActivated(event);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(event);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(event);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(event);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(event);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(event);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(event);
                }
            }
        }
    }

    public synchronized void removeWindowListener(WindowListener listener) {
        if (listener != null) {
            this.windowListener = AWTEventMulticaster.remove(this.windowListener, listener);
        }
    }

    public void toBack() {
        ((WindowPeer)this.peer).toBack();
    }

    public void toFront() {
        ((WindowPeer)this.peer).toFront();
    }

    protected void addWindow(Window window) {
        this.windowList.add(window);
    }

    protected void removeWindow(Window window) {
        this.windowList.remove(window);
    }

    public Window getOwner() {
        return this.owner;
    }

    public Window[] getOwnedWindows() {
        return (Window[])this.windowList.toArray();
    }

    public void enableAllEvents() {
        super.enableAllEvents();
        for (int i = 0; i < this.windowList.size(); ++i) {
            Window w = (Window)this.windowList.elementAt(i);
            w.enableAllEvents();
        }
    }

    public void disableAllEvents() {
        super.disableAllEvents();
        for (int i = 0; i < this.windowList.size(); ++i) {
            Window w = (Window)this.windowList.elementAt(i);
            w.disableAllEvents();
        }
    }
}

