/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;

public class TextField
extends TextComponent {
    private int cols;
    private char echo;

    public TextField() {
        this("", 0);
    }

    public TextField(int cols) {
        this("", cols);
    }

    public TextField(String text) {
        this(text, 0);
    }

    public TextField(String text, int cols) {
        if (text == null) {
            text = "";
        }
        this.text = text;
        this.cols = cols;
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        ((TextFieldPeer)this.peer).setText(text);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createTextField(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    public synchronized void addActionListener(ActionListener newlistener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, newlistener);
    }

    public synchronized void removeActionListener(ActionListener oldlistener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, oldlistener);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(event);
        }
    }

    public boolean echoCharIsSet() {
        return this.echo != '\u0000';
    }

    public char getEchoChar() {
        return this.echo;
    }

    public void setEchoChar(char ch) {
        ((TextFieldPeer)this.peer).setEchoChar(ch);
        this.echo = ch;
    }

    public int getColumns() {
        return this.cols;
    }

    public void setColumns(int cols) {
        this.cols = cols;
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.cols);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.cols);
    }

    public Dimension getMinimumSize(int cols) {
        return ((TextFieldPeer)this.peer).getMinimumSize(cols);
    }

    public Dimension getPreferredSize(int cols) {
        return ((TextFieldPeer)this.peer).getPreferredSize(cols);
    }

    public String toString() {
        String display = this.getClass().getName() + " length = " + this.cols + " cols text = [" + this.text;
        display = display + (this.editable ? "] editable selection <" : "] not editable selection <");
        return display + this.selectionStart + ", " + this.selectionStop + ">";
    }

    protected String paramString() {
        return this.getClass().getName() + " cols=" + this.cols + " text[" + this.text + "], caret(" + this.position + ") selection<" + this.selectionStart + ", " + this.selectionStop + ">";
    }
}

