/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.peer.TextComponentPeer;

public class TextComponent
extends Component {
    protected String text;
    protected int position;
    protected int selectionStart;
    protected int selectionStop;
    protected boolean editable = true;
    public transient TextListener textListener;

    public void setCaretPosition(int newposition) {
        ((TextComponentPeer)this.peer).setCaretPosition(newposition);
        this.position = ((TextComponentPeer)this.peer).getCaretPosition();
    }

    public int getCaretPosition() {
        this.position = ((TextComponentPeer)this.peer).getCaretPosition();
        return this.position;
    }

    public synchronized void setSelectionStart(int newstart) {
        this.selectionStop = ((TextComponentPeer)this.peer).getSelectionEnd();
        ((TextComponentPeer)this.peer).select(newstart, this.selectionStop);
        this.selectionStart = ((TextComponentPeer)this.peer).getSelectionStart();
    }

    public synchronized int getSelectionStart() {
        this.selectionStart = ((TextComponentPeer)this.peer).getSelectionStart();
        return this.selectionStart;
    }

    public synchronized void setSelectionEnd(int newstop) {
        this.selectionStart = ((TextComponentPeer)this.peer).getSelectionStart();
        ((TextComponentPeer)this.peer).select(this.selectionStart, newstop);
        this.selectionStop = ((TextComponentPeer)this.peer).getSelectionEnd();
    }

    public synchronized int getSelectionEnd() {
        this.selectionStop = ((TextComponentPeer)this.peer).getSelectionEnd();
        return this.selectionStop;
    }

    public synchronized void select(int newstart, int newstop) {
        ((TextComponentPeer)this.peer).select(newstart, newstop);
    }

    public synchronized void selectAll() {
        this.selectionStart = 0;
        this.text = ((TextComponentPeer)this.peer).getText();
        this.selectionStop = this.text.length();
        ((TextComponentPeer)this.peer).select(this.selectionStart, this.selectionStop);
    }

    public synchronized void setText(String newtext) {
        if (newtext == null) {
            newtext = "";
        }
        ((TextComponentPeer)this.peer).setText(newtext);
        this.text = newtext;
        if (this.position > this.text.length()) {
            this.position = this.text.length();
        }
    }

    public synchronized String getText() {
        this.text = ((TextComponentPeer)this.peer).getText();
        return this.text;
    }

    public synchronized String getSelectedText() {
        this.selectionStart = ((TextComponentPeer)this.peer).getSelectionStart();
        this.selectionStop = ((TextComponentPeer)this.peer).getSelectionEnd();
        this.text = ((TextComponentPeer)this.peer).getText();
        if (this.selectionStart >= this.selectionStop) {
            return "";
        }
        return this.text.substring(this.selectionStart, this.selectionStop);
    }

    public synchronized void setEditable(boolean condition) {
        ((TextComponentPeer)this.peer).setEditable(condition);
        this.editable = condition;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public String toString() {
        String display = this.getClass().getName() + " text[" + this.text;
        display = display + (this.editable ? "] editable selection <" : "] not editable selection <");
        return display + this.selectionStart + ", " + this.selectionStop + ">";
    }

    protected String paramString() {
        return this.getClass().getName() + " text[" + this.text + "], caret(" + this.position + ") selection<" + this.selectionStart + ", " + this.selectionStop + ">";
    }

    public synchronized void addTextListener(TextListener newlistener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, newlistener);
    }

    public void removeTextListener(TextListener oldlistener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, oldlistener);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof TextEvent) {
            if (this.textListener != null) {
                this.textListener.textValueChanged((TextEvent)e);
            }
        } else {
            super.processEvent(e);
        }
    }

    protected void processTextEvent(TextEvent e) {
        if (this.textListener != null) {
            this.textListener.textValueChanged(e);
        }
    }
}

