/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.peer.TextAreaPeer;

public class TextArea
extends TextComponent {
    public static final int SCROLLBARS_VERTICAL_ONLY = 1;
    public static final int SCROLLBARS_HORIZONTAL_ONLY = 2;
    public static final int SCROLLBARS_NONE = 3;
    public static final int SCROLLBARS_BOTH = 0;
    private int scrollbarVisible;
    private int preferredChars;
    private int preferredLines;

    public TextArea() {
        this("", 5, 20, 0);
    }

    public TextArea(String text) {
        this(text, 5, 20, 0);
    }

    public TextArea(int lines, int chars) {
        this("", lines, chars, 0);
    }

    public TextArea(String text, int lines, int chars) {
        this(text, lines, chars, 0);
    }

    public TextArea(String starttext, int lines, int chars, int scrollbarVis) {
        this.scrollbarVisible = scrollbarVis;
        this.text = starttext;
        this.setText(this.text);
        this.editable = true;
        this.preferredChars = chars;
        this.preferredLines = lines;
        this.validate();
        this.setVisible(true);
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createTextArea(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    public void setColumns(int columns) {
        this.preferredChars = columns;
    }

    public int getColumns() {
        return this.preferredChars;
    }

    public void setRows(int rows) {
        this.preferredLines = rows;
    }

    public int getRows() {
        return this.preferredLines;
    }

    public int getScrollbarVisibility() {
        return this.scrollbarVisible;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize(this.preferredLines, this.preferredChars);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.preferredLines, this.preferredChars);
    }

    public Dimension getMinimumSize(int lines, int chars) {
        return ((TextAreaPeer)this.peer).getMinimumSize(lines, chars);
    }

    public Dimension getPreferredSize(int lines, int chars) {
        return ((TextAreaPeer)this.peer).getPreferredSize(lines, chars);
    }

    public synchronized void append(String newtext) {
        this.text = this.getText();
        this.insert(newtext, this.text.length());
        this.text = this.getText();
        this.setCaretPosition(this.text.length());
    }

    public void insert(String newtext, int pos) {
        ((TextAreaPeer)this.peer).insert(newtext, pos);
        this.text = this.getText();
    }

    public void replaceRange(String newtext, int start, int stop) {
        ((TextAreaPeer)this.peer).replaceRange(newtext, start, stop);
        this.text = this.getText();
    }

    public String toString() {
        String display = this.getClass().getName();
        Rectangle r = this.getBounds();
        display = display + " (" + r.x + ", " + r.y + ", " + r.width + ", " + r.height + ") lines(" + this.preferredChars + ", " + this.preferredLines + ")text=[" + this.text;
        display = display + (this.editable ? "] editable scrollbars = " : "] non-editable scrollbars = ");
        switch (this.scrollbarVisible) {
            case 0: {
                display = display + "SCROLLBARS_BOTH";
                break;
            }
            case 2: {
                display = display + "SCROLLBARS_HORIZONTAL_ONLY";
                break;
            }
            case 1: {
                display = display + "SCROLLBARS_VERTICAL_ONLY";
                break;
            }
            case 3: {
                display = display + "SCROLLBARS_NONE";
                break;
            }
        }
        return display;
    }

    protected String paramString() {
        String display = this.getClass().getName();
        Rectangle r = this.getBounds();
        display = display + " (" + r.x + "," + r.y + "," + r.width + "," + r.height + ") [" + this.text + "] " + this.preferredLines + "lines ";
        display = display + (this.editable ? " editable scrollbars=" : " non-editable scrollbars=");
        switch (this.scrollbarVisible) {
            case 0: {
                display = display + "SCROLLBARS_BOTH";
                break;
            }
            case 2: {
                display = display + "SCROLLBARS_HORIZONTAL_ONLY";
                break;
            }
            case 1: {
                display = display + "SCROLLBARS_VERTICAL_ONLY";
                break;
            }
            case 3: {
                display = display + "SCROLLBARS_NONE";
                break;
            }
        }
        return display;
    }
}

