/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;

public class List
extends Component
implements ItemSelectable,
Serializable {
    private int rows;
    private boolean multipleMode;
    private Vector items;
    private int visibleIndex = 0;
    private int[] selected;
    private static final long serialVersionUID = -3304312411574666869L;
    private int listSerializedDataVersion = 0;
    public transient ActionListener aMultiListener;
    public transient ItemListener iMultiListener;

    public List(int rows, boolean allowmultipleselections) {
        this.rows = rows;
        this.multipleMode = allowmultipleselections;
        this.items = new Vector();
        this.selected = null;
        this.setMultipleMode(this.multipleMode);
        this.iMultiListener = null;
        this.aMultiListener = null;
    }

    public List(int rows) {
        this(rows, false);
    }

    public List() {
        this(4, false);
    }

    public int getRows() {
        return this.rows;
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createList(this);
        }
        if (!this.notified) {
            super.addNotify();
        }
    }

    public void addActionListener(ActionListener newlistener) {
        this.aMultiListener = AWTEventMulticaster.add(this.aMultiListener, newlistener);
    }

    public void removeActionListener(ActionListener oldlistener) {
        this.aMultiListener = AWTEventMulticaster.remove(this.aMultiListener, oldlistener);
    }

    public void addItemListener(ItemListener newlistener) {
        this.iMultiListener = AWTEventMulticaster.add(this.iMultiListener, newlistener);
    }

    public void removeItemListener(ItemListener oldlistener) {
        this.iMultiListener = AWTEventMulticaster.remove(this.iMultiListener, oldlistener);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            if (this.aMultiListener != null) {
                this.aMultiListener.actionPerformed((ActionEvent)e);
            }
        } else if (e instanceof ItemEvent) {
            if (this.iMultiListener != null) {
                this.iMultiListener.itemStateChanged((ItemEvent)e);
            }
        } else {
            super.processEvent(e);
        }
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.aMultiListener != null) {
            this.aMultiListener.actionPerformed(e);
        }
    }

    protected void processItemEvent(ItemEvent e) {
        if (this.iMultiListener != null) {
            this.iMultiListener.itemStateChanged(e);
        }
    }

    public void select(int index) {
        ((ListPeer)this.peer).select(index);
    }

    public void deselect(int index) {
        ((ListPeer)this.peer).deselect(index);
    }

    public boolean isIndexSelected(int index) throws ArrayIndexOutOfBoundsException {
        int[] selected = this.getSelectedIndexes();
        for (int i = 0; i < selected.length; ++i) {
            if (selected[i] != index) continue;
            return true;
        }
        return false;
    }

    public synchronized int getSelectedIndex() {
        int[] a = ((ListPeer)this.peer).getSelectedIndexes();
        if (a.length == 1) {
            return a[0];
        }
        return -1;
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized int[] getSelectedIndexes() {
        return ((ListPeer)this.peer).getSelectedIndexes();
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    public boolean AllowsMultipleSelections() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean newmode) {
        this.multipleMode = newmode;
        ((ListPeer)this.peer).setMultipleMode(newmode);
    }

    public void setMultipleSelections(boolean mode) {
        this.setMultipleMode(mode);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public String getItem(int index) {
        return (String)this.items.elementAt(index);
    }

    public String[] getItems() {
        String[] copy = new String[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            copy[i] = (String)this.items.elementAt(i);
        }
        return copy;
    }

    public synchronized String getSelectedItem() {
        int[] selected = this.getSelectedIndexes();
        if (selected.length != 1) {
            return null;
        }
        return (String)this.items.elementAt(selected[0]);
    }

    public synchronized String[] getSelectedItems() {
        int[] selected = this.getSelectedIndexes();
        String[] copy = new String[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            copy[i] = (String)this.items.elementAt(selected[i]);
        }
        return copy;
    }

    public synchronized Object[] getSelectedObjects() {
        int[] selected = this.getSelectedIndexes();
        Object[] copy = new String[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            copy[i] = (String)this.items.elementAt(selected[i]);
        }
        return copy;
    }

    public void add(String newitem) {
        this.add(newitem, this.items.size());
    }

    public void addItem(String newitem) {
        this.add(newitem);
    }

    public void add(String newitem, int pos) {
        if (pos > this.items.size() || pos == -1) {
            pos = this.items.size();
        }
        this.items.insertElementAt(newitem, pos);
        ((ListPeer)this.peer).add(newitem, pos);
    }

    public void addItem(String newitem, int pos) {
        this.add(newitem, pos);
    }

    public void replaceItem(String newitem, int pos) {
        this.add(newitem, pos + 1);
        this.remove(pos);
    }

    public void remove(int index) {
        this.removeElement(index, index + 1);
    }

    public void delItem(int index) {
        this.delItems(index, index + 1);
    }

    public void delItems(int start, int stop) {
        this.removeElement(start, stop);
    }

    public void remove(String element) {
        this.remove(this.items.indexOf(element));
    }

    public void removeAll() {
        this.items.removeAllElements();
        ((ListPeer)this.peer).removeAll();
    }

    public void clear() {
        this.removeAll();
    }

    public void removeElement(int start, int stop) {
        for (int i = start; i < stop; ++i) {
            this.items.remove(start);
        }
        ((ListPeer)this.peer).delItems(start, stop);
    }

    public void replaceElement(String newitem, int pos) {
        this.remove(pos);
        this.add(newitem, pos);
    }

    public void makeVisible(int target) {
        this.visibleIndex = target;
        ((ListPeer)this.peer).makeVisible(target);
    }

    public String toString() {
        Rectangle b = this.getBounds();
        String text = "List (" + b.x + ", " + b.y + ", " + b.width + ", " + b.height + ") " + this.items.size() + " items";
        text = this.multipleMode ? "Multiple " + text : text + " selected: " + this.getSelectedIndex();
        return text;
    }

    protected String paramString() {
        Rectangle b = this.getBounds();
        String text = "List " + this.getName() + " ( " + b.x + ", " + b.y + ", " + b.width + ", " + b.height + ") selected: " + this.items.size() + " items";
        if (this.multipleMode) {
            text = "Multiple " + text;
            String[] items = this.getSelectedItems();
            if (items.length > 0) {
                text = text + "[" + items[0];
                for (int i = 1; i < items.length; ++i) {
                    text = text + "],[" + items[i];
                }
                text = text + "]";
            } else {
                text = text + "NONE";
            }
        } else {
            text = text + ") selected: " + this.getSelectedItem();
        }
        return text;
    }

    private void readObject(ObjectInputStream s) {
    }

    private void writeObject(ObjectOutputStream s) {
    }
}

