/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class FlowLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -7262534875583282631L;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int LEADING = 3;
    public static final int TRAILING = 4;
    private int align;
    private int hgap;
    private int vgap;

    public FlowLayout() {
        this(1, 2, 2);
    }

    public FlowLayout(int align) {
        this(align, 2, 2);
    }

    public FlowLayout(int align, int hgap, int vgap) {
        if (align != 0 && align != 1 && align != 2) {
            throw new IllegalArgumentException("invalid alignment specified");
        }
        if (hgap < 0 || vgap < 0) {
            throw new IllegalArgumentException("invalid gap value");
        }
        this.align = align;
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int align) {
        if (align != 0 && align != 1 && align != 2) {
            throw new IllegalArgumentException("invalid alignment specified");
        }
        this.align = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        if (hgap < 0) {
            throw new IllegalArgumentException("invalid gap value");
        }
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        if (vgap < 0) {
            throw new IllegalArgumentException("invalid gap value");
        }
        this.vgap = vgap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container container) {
        int plh = 0;
        int plw = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component c = container.getComponent(i);
            if (!c.visible) continue;
            Dimension d = c.getPreferredSize();
            if (d == null) {
                d = new Dimension(0, 0);
            }
            plh = Math.max(d.height, plh);
            plw = plw + this.hgap + d.width;
        }
        Insets insets = container.getInsets();
        plw = plw + insets.left + this.hgap + insets.right;
        plh = plh + insets.top + this.vgap + this.vgap + insets.bottom;
        return new Dimension(plw, plh);
    }

    public Dimension minimumLayoutSize(Container container) {
        int plh = 0;
        int plw = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component c = container.getComponent(i);
            if (!c.visible) continue;
            Dimension d = c.getPreferredSize();
            plh = Math.max(d.height, plh);
            plw = plw + this.hgap + d.width;
        }
        Insets insets = container.getInsets();
        plw = plw + insets.left + this.hgap + insets.right;
        plh = plh + insets.top + this.vgap + this.vgap + insets.bottom;
        return new Dimension(plw, plh);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int offseth = 0;
        int begin = 0;
        int x = 0;
        int y = insets.top + this.vgap;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component c = container.getComponent(i);
            if (!c.visible) continue;
            Dimension d = c.getPreferredSize();
            if (d == null) {
                d = new Dimension(0, 0);
            }
            c.setSize(Math.min(d.width, container.width - this.vgap - this.vgap), Math.min(d.height, container.height - this.hgap - this.hgap));
            if (x + c.width + this.hgap > container.width - insets.left - insets.right) {
                this.relocateRow(container, begin, i, insets.left + this.hgap, y, container.width - insets.left - insets.right - x, offseth);
                begin = i;
                x = c.width;
                y = y + offseth + this.vgap;
                offseth = c.height;
                continue;
            }
            offseth = Math.max(c.height, offseth);
            x = x + c.width + this.hgap;
        }
        this.relocateRow(container, begin, container.getComponentCount(), insets.left + this.hgap, y, container.width - insets.left - insets.right - x, offseth);
    }

    private void relocateRow(Container container, int begin, int end, int x, int y, int width, int height) {
        if (this.align == 1) {
            x += width / 2;
        }
        if (this.align == 2 || this.align == 4) {
            x += width;
        }
        for (int i = begin; i < end; ++i) {
            Component c = container.getComponent(i);
            if (!c.visible) continue;
            c.setLocation(x, y + (height - c.height) / 2);
            x = x + c.width + this.hgap;
        }
    }

    public String toString() {
        String str = new String();
        switch (this.align) {
            case 0: {
                str = ", align = left";
                break;
            }
            case 1: {
                str = ", align = center";
                break;
            }
            case 2: {
                str = ", align = right";
                break;
            }
            case 3: {
                str = ", align = leading";
                break;
            }
            case 4: {
                str = ", align = trailing";
            }
        }
        return this.getClass().getName() + "[hgap = " + this.hgap + ", vgap = " + this.vgap + str + "]";
    }
}

