/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;

public class Cursor
implements Serializable {
    private static final long serialVersionUID = 8028237497568985504L;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int DEFAULT_CURSOR = 0;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int TEXT_CURSOR = 2;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int WAIT_CURSOR = 3;
    public static final int CUSTOM_CURSOR = -1;
    private int type;
    private String name;
    private static String[] nameType = new String[]{"Default Cursor", "Crosshair Cursor", "Text Cursor", "Wait Cursor", "Southwest Resize Cursor", "Southeast Resize Cursor", "Northwest Resize Cursor", "Northeast Resize Cursor", "North Resize Cursor", "South Resize Cursor", "West Resize Cursor", "East Resize Cursor", "Hand Cursor", "Move Cursor"};
    protected static Cursor[] predefined;

    public Cursor(int type) {
        if (type < 0 || type > 13) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.name = nameType[type];
    }

    protected Cursor(String name) {
        this.name = name;
        this.type = -1;
    }

    public static Cursor getDefaultCursor() {
        return new Cursor(0);
    }

    public static Cursor getPredefinedCursor(int type) {
        return new Cursor(type);
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }
}

