/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ContainerPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;

public abstract class Container
extends Component {
    private LayoutManager layoutManager;
    private Vector componentVector;
    ContainerListener containerListener;

    public Container() {
        this.width = 0;
        this.height = 0;
        this.componentVector = new Vector();
        this.layoutManager = new BorderLayout();
        this.containerListener = null;
    }

    public Component add(Component component) {
        this.addImpl(component, null, -1);
        return component;
    }

    public void add(Component component, Object constraints) {
        this.addImpl(component, constraints, -1);
    }

    public void add(Component component, Object constraints, int position) {
        this.addImpl(component, constraints, position);
    }

    public Component add(Component component, int position) {
        this.addImpl(component, null, position);
        return component;
    }

    public Component add(String name, Component component) {
        this.addImpl(component, name, -1);
        return component;
    }

    public synchronized void addContainerListener(ContainerListener listener) {
        this.containerListener = AWTEventMulticaster.add(this.containerListener, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addImpl(Component component, Object constraints, int position) {
        if (!(component instanceof Component)) {
            throw new IllegalArgumentException("You can only add types derived from java.awt.Component.");
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (component.parent != null) {
                component.parent.removeComponent(component);
            }
            component.addNotify();
            if (component instanceof Container) {
                if (component instanceof Window) {
                    System.out.println("You can't add a java.awt.Window to a java.awt.Container.");
                    throw new IllegalArgumentException("You can't add a java.awt.Window to a java.awt.Container.");
                }
                Container container = this;
                while (container != null) {
                    if (container == component) {
                        throw new IllegalArgumentException("Container.addImpl(): attempt container's parent to itself.");
                    }
                    container = container.parent;
                }
            }
            if (position == -1) {
                this.componentVector.addElement(component);
            } else {
                this.componentVector.insertElementAt(component, position);
            }
            component.parent = this;
            if (this.layoutManager != null) {
                if (this.layoutManager instanceof LayoutManager2) {
                    ((LayoutManager2)this.layoutManager).addLayoutComponent(component, constraints);
                } else {
                    this.layoutManager.addLayoutComponent((String)constraints, component);
                }
            }
            super.dispatchEventImpl(new ContainerEvent(this, 300, component));
            if (this.valid) {
                this.invalidate();
            }
            this.invalidateChildren();
        }
    }

    public void addNotify() {
        if (!this.notified) {
            super.addNotify();
        }
    }

    public void removeNotify() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = (Component)this.componentVector.elementAt(i);
            c.removeNotify();
        }
        super.removeNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLayout() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.layoutManager != null) {
                this.layoutManager.layoutContainer(this);
            }
        }
    }

    public void layout() {
        this.doLayout();
    }

    public float getAlignmentX() {
        if (this.layoutManager == null || !(this.layoutManager instanceof LayoutManager2)) {
            return 0.5f;
        }
        return ((LayoutManager2)this.layoutManager).getLayoutAlignmentX(this);
    }

    public float getAlignmentY() {
        if (this.layoutManager == null || !(this.layoutManager instanceof LayoutManager2)) {
            return 0.5f;
        }
        return ((LayoutManager2)this.layoutManager).getLayoutAlignmentY(this);
    }

    public Component getComponent(int index) {
        return (Component)this.componentVector.elementAt(index);
    }

    public native Component getComponentAt(int var1, int var2);

    public native Component getComponentAt(Point var1);

    public int getComponentCount() {
        return this.componentVector.size();
    }

    public Component[] getComponents() {
        Object[] components = new Component[this.componentVector.size()];
        return (Component[])this.componentVector.toArray(components);
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public LayoutManager getLayout() {
        return this.layoutManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMaximumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.maximumSize == null || !this.valid) {
                this.maximumSize = this.layoutManager != null && this.layoutManager instanceof LayoutManager2 ? ((LayoutManager2)this.layoutManager).maximumLayoutSize(this) : super.getMaximumSize();
            }
            return this.maximumSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.minSize == null || !this.valid) {
                this.minSize = this.layoutManager != null ? this.layoutManager.minimumLayoutSize(this) : this.getBoundingBox();
            }
            return this.minSize;
        }
    }

    private Dimension getBoundingBox() {
        Component c = null;
        int count = this.getComponentCount();
        int wmax = 0;
        int hmax = 0;
        for (int i = 0; i < count; ++i) {
            c = (Component)this.componentVector.elementAt(i);
            Dimension d = c.getMinimumSize();
            int w = c.getX() + (int)d.getWidth();
            int h = c.getY() + (int)d.getHeight();
            if (w > wmax) {
                wmax = w;
            }
            if (h <= hmax) continue;
            hmax = h;
        }
        return new Dimension(wmax + this.getInsets().right, hmax + this.getInsets().bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.prefSize == null || !this.valid) {
                this.prefSize = this.layoutManager != null ? this.layoutManager.preferredLayoutSize(this) : this.getBoundingBox();
            }
            return this.prefSize;
        }
    }

    void invalidateChildren() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = (Component)this.componentVector.elementAt(i);
            c.invalidate();
            if (!(c instanceof Container)) continue;
            ((Container)c).invalidateChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.invalidate();
            if (this.layoutManager != null && this.layoutManager instanceof LayoutManager2) {
                ((LayoutManager2)this.layoutManager).invalidateLayout(this);
            }
        }
    }

    public boolean isAncestorOf(Component component) {
        Container parent = component.getParent();
        if (parent == null) {
            return false;
        }
        if (parent == this) {
            return true;
        }
        return this.isAncestorOf(parent);
    }

    public native void list(PrintStream var1, int var2);

    public native void list(PrintWriter var1, int var2);

    public native void paintComponents(Graphics var1);

    protected native String paramString();

    public native void print(Graphics var1);

    public native void printComponents(Graphics var1);

    protected void processContainerEvent(ContainerEvent event) {
        if (this.containerListener != null) {
            switch (event.getID()) {
                case 300: {
                    this.containerListener.componentAdded(event);
                    break;
                }
                case 301: {
                    this.containerListener.componentRemoved(event);
                }
            }
        }
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeComponent(Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.layoutManager != null) {
                this.layoutManager.removeLayoutComponent(component);
            }
            if (this.componentVector.removeElement(component)) {
                component.parent = null;
                if (this.valid) {
                    this.invalidate();
                }
                super.dispatchEventImpl(new ContainerEvent(this, 301, component));
            }
        }
    }

    public void remove(Component component) {
        this.removeComponent(component);
    }

    public void remove(int position) {
        this.removeComponent((Component)this.componentVector.elementAt(position));
    }

    public void removeAll() {
        int size = this.componentVector.size();
        for (int i = 0; i < size; ++i) {
            this.removeComponent((Component)this.componentVector.elementAt(0));
        }
    }

    public synchronized void removeContainerListener(ContainerListener listener) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, listener);
    }

    public void setLayout(LayoutManager manager) {
        this.layoutManager = manager;
        if (this.valid) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (!this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                ((ContainerPeer)this.peer).beginValidate();
                this.validateTree();
                ((ContainerPeer)this.peer).endValidate();
            }
        }
    }

    public void validateTree() {
        if (!this.valid) {
            this.validate = true;
            this.valid = true;
            this.layout();
            for (int i = 0; i < this.componentVector.size(); ++i) {
                ((Component)this.componentVector.elementAt(i)).validate();
            }
            this.validate = false;
        }
    }

    public void setVisible(boolean condition) {
        super.setVisible(condition);
        this.sendComponentEvent(this, condition);
    }

    private void sendComponentEvent(Container container, boolean condition) {
        if (condition) {
            int count = container.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = container.getComponent(i);
                if (!c.visible) continue;
                if (c.componentListener != null) {
                    c.dispatchEvent(new ComponentEvent(c, 102));
                }
                if (!(c instanceof Container)) continue;
                this.sendComponentEvent((Container)c, condition);
            }
        }
    }

    void enableAllEvents() {
        this.eventsEnabled = true;
        for (int i = 0; i < this.componentVector.size(); ++i) {
            Component c = (Component)this.componentVector.elementAt(i);
            if (c instanceof Container) {
                ((Container)c).enableAllEvents();
                continue;
            }
            c.eventsEnabled = true;
        }
    }

    void disableAllEvents() {
        this.eventsEnabled = false;
        for (int i = 0; i < this.componentVector.size(); ++i) {
            Component c = (Component)this.componentVector.elementAt(i);
            if (c instanceof Container) {
                ((Container)c).disableAllEvents();
                continue;
            }
            c.eventsEnabled = false;
        }
    }

    public int countComponents() {
        return this.getComponentCount();
    }

    public Insets insets() {
        return this.getInsets();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        System.out.println("Not yet implemented");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        System.out.println("Not yet implemented");
    }
}

