/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.security;

import com.acunia.wonka.security.DefaultPermissionCollection;
import java.security.Permission;
import java.util.Hashtable;
import java.util.Vector;

public class SocketPermissionCollection
extends DefaultPermissionCollection {
    private static final long LIFETIME_MILLIS = 300000L;
    private static final int INITIAL_TABSIZE = 11;
    private Hashtable cache = new Hashtable(11);
    private Vector ageing_fifo = new Vector();
    private long next_deletion = System.currentTimeMillis();

    public synchronized boolean implies(Permission permission) {
        this.performPreAgeing();
        Boolean cached_result = (Boolean)this.cache.get(permission);
        if (cached_result != null) {
            return cached_result;
        }
        this.ageing_fifo.addElement(permission);
        this.performPostAgeing();
        if (super.implies(permission)) {
            this.cache.put(permission, new Boolean(true));
            return true;
        }
        this.cache.put(permission, new Boolean(false));
        return false;
    }

    private final void performPreAgeing() {
        long now = System.currentTimeMillis();
        while (this.ageing_fifo.size() > 0 && now > this.next_deletion) {
            this.cache.remove(this.ageing_fifo.elementAt(0));
            this.ageing_fifo.removeElementAt(0);
            if (this.ageing_fifo.size() == 0) {
                this.next_deletion = Long.MAX_VALUE;
                continue;
            }
            this.next_deletion += 300000L / (long)this.ageing_fifo.size();
        }
    }

    private final void performPostAgeing() {
        if (this.next_deletion == Long.MAX_VALUE) {
            this.next_deletion = System.currentTimeMillis() + 300000L;
        } else {
            int n = this.ageing_fifo.size();
            if (n > 1) {
                this.next_deletion -= 300000L / (long)n - 300000L / (long)(n - 1);
            }
        }
    }
}

