/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyPermission;
import java.util.Vector;

public class PropertyPermissionCollection
extends PermissionCollection {
    private static int INITIAL_TABSIZE = 11;
    private Hashtable read_prefixes = new Hashtable(INITIAL_TABSIZE);
    private Hashtable write_prefixes = new Hashtable(INITIAL_TABSIZE);

    private final void add_to(PropertyPermission newperm, Hashtable prefixes) throws SecurityException {
        Hashtable table = prefixes;
        String name = newperm.getName();
        String longest_prefix = "";
        String target_matched = "";
        int namelen = name.length();
        int longest_prefix_length = 0;
        boolean wild = false;
        if (namelen > 1 && name.charAt(namelen - 1) == '*') {
            wild = true;
            name = name.substring(0, --namelen);
        }
        while (namelen > 0) {
            Enumeration e = table.keys();
            boolean found = false;
            while (e.hasMoreElements()) {
                String prefix = name;
                int prefixlen = namelen;
                String target = (String)e.nextElement();
                while (prefixlen > longest_prefix_length) {
                    if (target.startsWith(prefix)) {
                        longest_prefix = prefix;
                        target_matched = target;
                        longest_prefix_length = prefixlen;
                        found = true;
                    }
                    prefix = prefix.substring(0, --prefixlen);
                }
            }
            if (longest_prefix_length == 0) {
                if (wild) {
                    Hashtable new_table = new Hashtable(INITIAL_TABSIZE);
                    table.put(name, new_table);
                    table = new_table;
                } else {
                    table.put(name, newperm);
                }
                name = "";
                namelen = 0;
            } else {
                Object old_data = table.get(target_matched);
                if (longest_prefix_length < target_matched.length() || old_data instanceof Permission) {
                    Hashtable new_table = new Hashtable(INITIAL_TABSIZE);
                    new_table.put(target_matched.substring(longest_prefix_length), old_data);
                    table.remove(target_matched);
                    table.put(longest_prefix, new_table);
                    table = new_table;
                } else {
                    table = (Hashtable)old_data;
                }
                name = name.substring(longest_prefix_length);
                namelen = name.length();
                longest_prefix = "";
                longest_prefix_length = 0;
            }
            if (!wild || namelen != 0) continue;
            name = "*";
            namelen = 1;
            wild = false;
        }
    }

    public synchronized void add(Permission permission) throws SecurityException {
        PropertyPermission newperm;
        if (super.isReadOnly()) {
            throw new SecurityException("read-only");
        }
        try {
            newperm = (PropertyPermission)permission;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("not a PropertyPermission");
        }
        if (newperm.getActions().indexOf("read") >= 0) {
            this.add_to(newperm, this.read_prefixes);
        }
        if (newperm.getActions().indexOf("write") >= 0) {
            this.add_to(newperm, this.write_prefixes);
        }
    }

    public boolean implies_action(String path, Hashtable prefixes) {
        if (prefixes.get("*") != null) {
            return true;
        }
        Hashtable table = prefixes;
        String name = path;
        int namelen = name.length();
        while (namelen >= 0) {
            Object data = table.get(name);
            if (data instanceof Permission) {
                return true;
            }
            data = table.get(new String("*"));
            if (data != null) {
                return true;
            }
            Enumeration e = table.keys();
            boolean found = false;
            while (e.hasMoreElements()) {
                String prefix = name;
                int prefixlen = namelen;
                String target = (String)e.nextElement();
                if (!name.startsWith(target)) continue;
                data = table.get(target);
                if (data instanceof Hashtable) {
                    table = (Hashtable)data;
                    name = name.substring(target.length());
                    namelen = name.length();
                    found = true;
                    break;
                }
                System.err.println("  Matched prefix '" + target + "', but ->Permission (?!)");
            }
            if (!found) break;
        }
        return false;
    }

    public boolean implies(Permission permission) {
        PropertyPermission tryperm;
        try {
            tryperm = (PropertyPermission)permission;
        }
        catch (ClassCastException e) {
            return false;
        }
        String trypath = tryperm.getName();
        boolean bl = false;
        if ((tryperm.getActions().indexOf("read") < 0 || this.implies_action(trypath, this.read_prefixes)) && (tryperm.getActions().indexOf("write") < 0 || this.implies_action(trypath, this.write_prefixes))) {
            bl = true;
        }
        return bl;
    }

    private final Enumeration enumerate_subtree(Hashtable table) {
        Vector temp = new Vector();
        Enumeration e = table.elements();
        while (e.hasMoreElements()) {
            Object data = e.nextElement();
            if (data instanceof Hashtable) {
                Hashtable next_table = (Hashtable)data;
                Enumeration ee = this.enumerate_subtree(next_table);
                while (ee.hasMoreElements()) {
                    temp.addElement(ee.nextElement());
                }
                continue;
            }
            temp.addElement(data);
        }
        return temp.elements();
    }

    public synchronized Enumeration elements() {
        Object p;
        Hashtable accumulator = new Hashtable();
        Enumeration e = this.enumerate_subtree(this.read_prefixes);
        while (e.hasMoreElements()) {
            p = e.nextElement();
            accumulator.put(p, p);
        }
        e = this.enumerate_subtree(this.write_prefixes);
        while (e.hasMoreElements()) {
            p = e.nextElement();
            accumulator.put(p, p);
        }
        return accumulator.keys();
    }
}

