/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.security;

import com.acunia.wonka.security.DefaultPolicy;
import com.acunia.wonka.security.PolicyPermissionCollection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.security.CodeSource;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class PolicyReader
implements PrivilegedAction {
    private static final String TRUE = "true";
    private static final String URLSTRING = "policy.url.";
    private static final String DQ = "\"";
    private static final String PK = ";";
    private static final String K = ",";
    private static final String DACO = "${";
    private static final String ACO = "{";
    private static final char ACC = '}';
    private HashMap collections;
    private KeyStore store;
    private StreamTokenizer st;
    private BufferedReader br;
    private boolean expand;
    private boolean validEntry;
    private String fileSep;
    private ClassLoader cl;

    public final Object run() {
        try {
            String userURL;
            this.cl = this.getClass().getClassLoader();
            this.fileSep = System.getProperty("file.Separator", "/");
            if (this.cl == null) {
                this.cl = ClassLoader.getSystemClassLoader();
            }
            this.collections = new HashMap();
            this.expand = TRUE.equals(Security.getProperty("policy.expandProperties"));
            int nr = 1;
            String url = Security.getProperty(URLSTRING + nr);
            if (TRUE.equals(Security.getProperty("policy.allowSystemProperty")) && (userURL = System.getProperty("java.security.policy")) != null) {
                if (userURL.startsWith("=")) {
                    url = null;
                }
                this.loadPolicyFile(userURL);
            }
            while (url != null) {
                if (this.loadPolicyFile(url)) break;
                url = Security.getProperty(URLSTRING + ++nr);
            }
            if (this.collections.get(DefaultPolicy.DEFAULT_CS) == null) {
                this.collections.put(DefaultPolicy.DEFAULT_CS, new PolicyPermissionCollection());
            }
            return this.collections;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final boolean hasMoreEntryTokens() throws Exception {
        int type = this.st.nextToken();
        if (type == 44) {
            return true;
        }
        if (type == 59) {
            return false;
        }
        throw new GeneralSecurityException("bad entry syntax encountered " + this.st);
    }

    private final String expandString(String name, boolean inCodeBase) {
        int index = name.indexOf(DACO);
        if (index == -1) {
            return name;
        }
        StringBuffer buf = new StringBuffer();
        int end = 0;
        do {
            buf.append(name.substring(end, index));
            end = name.indexOf(125, index += 2);
            if (end == -1) {
                buf.append(name.substring(index - 2));
                return buf.toString();
            }
            String key = name.substring(index, end);
            if (key == "/") {
                buf.append(this.fileSep);
                continue;
            }
            String prop = System.getProperty(key);
            if (prop == null) {
                this.validEntry = false;
                return name;
            }
            if (inCodeBase) {
                prop = prop.replace(this.fileSep.charAt(0), '/');
            }
            buf.append(prop);
        } while ((index = name.indexOf(DACO, ++end)) != -1);
        buf.append(name.substring(end));
        return buf.toString();
    }

    private final Certificate[] getCertificates(String aliases) throws GeneralSecurityException, KeyStoreException {
        if (this.expand) {
            aliases = this.expandString(aliases, false);
        }
        StringTokenizer str = new StringTokenizer(aliases, K);
        int count = str.countTokens();
        Certificate[] certs = new Certificate[count];
        int i = 0;
        while (i < count) {
            certs[i] = this.store.getCertificate(str.nextToken());
            ++i;
        }
        return certs;
    }

    private final String getToken() throws IOException {
        int type = this.st.nextToken();
        if (type == -3 || type == 34) {
            return this.st.sval;
        }
        if (type == -1) {
            return null;
        }
        return String.valueOf((char)type);
    }

    private final boolean loadPolicyFile(String url) throws Exception {
        if (this.expand) {
            url = this.expandString(url, true);
        }
        URL loc = new URL(url);
        InputStream in = null;
        try {
            in = loc.openStream();
        }
        catch (IOException ioe) {
            return true;
        }
        this.st = new StreamTokenizer(new InputStreamReader(in));
        this.st.slashSlashComments(true);
        String token = this.getToken();
        while (token != null) {
            if (token.equalsIgnoreCase("grant")) {
                this.parseGrantBlock(loc);
            } else if (token.equalsIgnoreCase("keystore")) {
                this.parseKeyStoreBlock(loc);
            } else {
                throw new GeneralSecurityException("unknown start of policy file entry '" + token + '\'');
            }
            token = this.getToken();
        }
        return false;
    }

    private final void parseGrantBlock(URL baseURL) throws Exception {
        String token;
        PermissionCollection pc;
        String token2;
        URL url = null;
        Certificate[] signers = null;
        while (!(token2 = this.getToken()).equals(ACO)) {
            if (token2.equalsIgnoreCase("signedBy")) {
                if (signers != null) {
                    throw new GeneralSecurityException("INVALID GRANT ENTRY: more then one signedBy token found");
                }
                signers = this.getCertificates(this.getToken());
                continue;
            }
            if (token2.equalsIgnoreCase("codeBase")) {
                if (url != null) {
                    throw new GeneralSecurityException("INVALID GRANT ENTRY: more then one codeBase token found");
                }
                String location = this.getToken();
                if (this.expand) {
                    location = this.expandString(location, true);
                }
                url = new URL(baseURL, location);
                continue;
            }
            throw new GeneralSecurityException("unknown token '" + token2 + "' in 'grant' entry header");
        }
        if (this.validEntry) {
            CodeSource cs = new CodeSource(url, signers);
            pc = (PermissionCollection)this.collections.get(cs);
            if (pc == null) {
                pc = new PolicyPermissionCollection();
                if (url != null) {
                    pc.add(url.openConnection().getPermission());
                }
                this.collections.put(cs, pc);
            }
        } else {
            pc = new PolicyPermissionCollection();
        }
        while ((token = this.getToken()).equalsIgnoreCase("permission")) {
            this.parsePermissionBlock(pc);
        }
        if (!token.equals("}") || this.st.nextToken() != 59) {
            throw new GeneralSecurityException("unknown token '" + token + "' in 'grant' entry body");
        }
    }

    private final void parseKeyStoreBlock(URL baseURL) throws Exception {
        String url = this.getToken();
        if (this.st.nextToken() != 44) {
            throw new GeneralSecurityException("unknown token '" + (char)this.st.ttype + "' in 'keystore' entry (,)");
        }
        String type = this.getToken();
        if (this.st.nextToken() != 59) {
            throw new GeneralSecurityException("unknown token '" + (char)this.st.ttype + "' in 'keystore' entry (;)");
        }
        if (this.store == null) {
            if (this.expand) {
                type = this.expandString(type, false);
                url = this.expandString(url, true);
            }
            if (this.validEntry) {
                this.store = KeyStore.getInstance(type);
                this.store.load(new URL(baseURL, url).openStream(), null);
            } else {
                this.validEntry = true;
            }
        }
    }

    private final void parsePermissionBlock(PermissionCollection pc) throws Exception {
        Object[] args;
        String classname = this.getToken();
        String target = this.getToken();
        Class permission = Class.forName(classname, true, this.cl);
        if (target.equals(PK)) {
            Permission perm = (Permission)permission.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            pc.add(perm);
            return;
        }
        if (this.hasMoreEntryTokens()) {
            String action = this.getToken();
            if (this.hasMoreEntryTokens()) {
                this.verifySigners(permission);
            }
            if (this.expand) {
                action = this.expandString(action, false);
            }
            args = new String[2];
            args[1] = action;
        } else {
            args = new String[1];
        }
        if (this.expand) {
            target = this.expandString(target, false);
        }
        if (this.validEntry) {
            args[0] = target;
            Class[] params = new Class[args.length];
            params[0] = target.getClass();
            if (params.length == 2) {
                params[1] = params[0];
            }
            Permission perm = (Permission)permission.getDeclaredConstructor(params).newInstance(args);
            pc.add(perm);
        } else {
            this.validEntry = true;
        }
    }

    private final void verifySigners(Class cl) throws Exception {
        String sign = this.getToken();
        String aliases = this.getToken();
        if (!sign.equalsIgnoreCase("signedBy") || this.st.nextToken() != 59) {
            throw new GeneralSecurityException("INVALID PERMISSION ENTRY: signedBy = '" + sign + "' and aliases = '" + aliases + '\'');
        }
        Certificate[] certs = this.getCertificates(aliases);
        ClassLoader loader = cl.getClassLoader();
        if (loader != null) {
            Object[] signers = cl.getSigners();
            if (signers != null) {
                int i = 0;
                while (i < signers.length) {
                    int j = 0;
                    while (j < certs.length) {
                        if (signers[i].equals(certs[j])) {
                            return;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            this.validEntry = false;
        }
    }

    private final /* synthetic */ void this() {
        this.validEntry = true;
    }

    PolicyReader() {
        this.this();
    }
}

