/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.security;

import java.io.FilePermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FilePermissionCollection
extends PermissionCollection {
    private static final String DASH = "-";
    private static final String STAR = "*";
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int INITIAL_TABSIZE = 11;
    private static final String SEP = System.getProperty("file.separator");
    private static final char SEP_CHAR = SEP.charAt(0);
    private static final String SEP_DASH = SEP + '-';
    private static final String SEP_STAR = SEP + '*';
    private Hashtable prefixes;
    private HashSet elements;
    private int allMask;

    private static final int actions2bitmask(String actions) {
        int result = 0;
        String remainder = actions;
        while (remainder != null) {
            String action;
            int comma = remainder.indexOf(44);
            if (comma < 0) {
                action = remainder;
                remainder = null;
            } else {
                action = remainder.substring(0, comma);
                remainder = remainder.substring(comma + 1);
            }
            if (action.equals("execute")) {
                result |= 1;
                continue;
            }
            if (action.equals("write")) {
                result |= 2;
                continue;
            }
            if (action.equals("read")) {
                result |= 4;
                continue;
            }
            if (!action.equals("delete")) continue;
            result |= 8;
        }
        return result;
    }

    private final void add_action(FilePermission newperm, int action) throws SecurityException {
        Hashtable table = this.prefixes;
        String name = newperm.getName();
        String longest_prefix = "";
        String target_matched = "";
        int longest_prefix_length = 0;
        int namelen = name.length();
        boolean bl = false;
        if (name.endsWith(SEP_STAR) || name.endsWith(SEP_DASH)) {
            bl = true;
        }
        boolean wild = bl;
        String wildstring = null;
        if (wild) {
            wildstring = name.substring((namelen -= 2) + 1);
            name = name.substring(0, namelen);
        }
        if (name.charAt(namelen - 1) == SEP_CHAR) {
            name = name.substring(0, --namelen);
        }
        while (namelen >= 0) {
            if (namelen > 0 && name.charAt(0) == SEP_CHAR) {
                name = name.substring(1);
                --namelen;
            }
            Enumeration e = table.keys();
            boolean found = false;
            while (e.hasMoreElements()) {
                String prefix = name;
                int prefixlen = namelen;
                String target = (String)e.nextElement();
                while (prefixlen > longest_prefix_length) {
                    int i;
                    if (target.startsWith(prefix)) {
                        longest_prefix = prefix;
                        target_matched = target;
                        longest_prefix_length = prefixlen;
                        found = true;
                    }
                    if ((i = prefix.lastIndexOf(SEP_CHAR)) < 0) {
                        prefix = "";
                        prefixlen = 0;
                        continue;
                    }
                    prefix = prefix.substring(0, i);
                    prefixlen = i;
                }
            }
            if (longest_prefix_length == 0) {
                if (wild) {
                    Hashtable new_table = new Hashtable(11);
                    table.put(name, new_table);
                    table = new_table;
                    name = wildstring;
                    namelen = 1;
                    wild = false;
                    continue;
                }
                Integer new_actions = new Integer(action);
                table.put(name, new_actions);
                name = "";
                namelen = -1;
                continue;
            }
            Object old_data = table.get(target_matched);
            if (longest_prefix_length < target_matched.length()) {
                Hashtable new_table = new Hashtable(11);
                new_table.put(target_matched.substring(longest_prefix_length + 1), old_data);
                table.remove(target_matched);
                table.put(longest_prefix, new_table);
                table = new_table;
            } else if (old_data instanceof Integer) {
                if (!wild && namelen == longest_prefix_length) {
                    Integer old_actions = (Integer)old_data;
                    if ((old_actions & action) == 0) {
                        table.put(target_matched, new Integer(old_actions | action));
                    }
                } else {
                    Hashtable new_table = new Hashtable(11);
                    table.put(target_matched, new_table);
                    table = new_table;
                    table.put("", old_data);
                }
            } else {
                table = (Hashtable)old_data;
            }
            if (wild && namelen == longest_prefix_length) {
                name = wildstring;
                namelen = 1;
                wild = false;
            } else {
                name = name.substring(longest_prefix_length);
                namelen = name.length();
            }
            longest_prefix = "";
            longest_prefix_length = 0;
        }
    }

    public synchronized void add(Permission permission) throws SecurityException {
        FilePermission newperm;
        if (super.isReadOnly()) {
            throw new SecurityException("read-only");
        }
        try {
            newperm = (FilePermission)permission;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("not a FilePermission");
        }
        if (this.elements.add(newperm)) {
            if (newperm.getName().equals("<<ALL FILES>>")) {
                this.allMask |= FilePermissionCollection.actions2bitmask(newperm.getActions());
            } else {
                this.add_action(newperm, FilePermissionCollection.actions2bitmask(newperm.getActions()));
            }
        }
    }

    public boolean implies_action(String path, int action) {
        if ((this.allMask & action) == action) {
            return true;
        }
        action &= ~this.allMask;
        Hashtable table = this.prefixes;
        String name = path;
        int namelen = name.length();
        if (namelen > 0 && name.charAt(namelen - 1) == SEP_CHAR) {
            name = name.substring(0, --namelen);
        }
        if (namelen > 0 && name.charAt(0) == SEP_CHAR) {
            name = name.substring(1);
            --namelen;
        }
        while (namelen >= 0) {
            Integer found_actions;
            Object data = table.get(name);
            if (data != null) {
                try {
                    found_actions = (Integer)data;
                    if ((found_actions & action) == action) {
                        return true;
                    }
                    action &= ~found_actions.intValue();
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if ((data = table.get(DASH)) != null && namelen > 0) {
                try {
                    found_actions = (Integer)data;
                    if ((found_actions & action) == action) {
                        return true;
                    }
                    action &= ~found_actions.intValue();
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            if ((data = table.get(STAR)) != null && namelen > 0) {
                try {
                    found_actions = (Integer)data;
                    if ((found_actions & action) == action && name.indexOf(SEP_CHAR) < 0) {
                        return true;
                    }
                    action &= ~found_actions.intValue();
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            Enumeration e = table.keys();
            boolean found = false;
            while (e.hasMoreElements()) {
                String prefix = name;
                int prefixlen = namelen;
                String target = (String)e.nextElement();
                if (!name.startsWith(target)) continue;
                data = table.get(target);
                if (data instanceof Hashtable) {
                    if (target.length() < namelen && name.charAt(target.length()) != SEP_CHAR) continue;
                    table = (Hashtable)data;
                    name = name.substring(target.length() < namelen ? target.length() + 1 : target.length());
                    namelen = name.length();
                    found = true;
                    break;
                }
                if (!name.equals(target + SEP)) continue;
                int found_actions2 = (Integer)data;
                if ((found_actions2 & action) == action) {
                    return true;
                }
                action &= ~found_actions2;
            }
            if (!found) break;
        }
        return false;
    }

    public boolean implies(Permission permission) {
        FilePermission tryperm;
        try {
            tryperm = (FilePermission)permission;
        }
        catch (ClassCastException e) {
            return false;
        }
        return this.implies_action(tryperm.getName(), FilePermissionCollection.actions2bitmask(tryperm.getActions()));
    }

    public synchronized Enumeration elements() {
        return new Vector(this.elements).elements();
    }

    private final /* synthetic */ void this() {
        this.allMask = 0;
    }

    public FilePermissionCollection() {
        this.this();
        this.prefixes = new Hashtable(11);
        this.elements = new HashSet();
    }
}

