/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.taskbar.applets;

import com.acunia.wonka.rudolph.taskbar.TaskBar;
import com.acunia.wonka.rudolph.taskbar.TaskBarApplet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class MemoryApplet
extends TaskBarApplet
implements Runnable {
    private int width;
    private int height;
    private int interval;
    private long total = 0L;
    private boolean horizontal;

    public MemoryApplet(TaskBar taskbar) {
        super(taskbar);
        this.width = Integer.parseInt(taskbar.getProperties().getProperty("applet.memory.width", "100"));
        this.height = Integer.parseInt(taskbar.getProperties().getProperty("applet.memory.height", "15"));
        this.interval = Integer.parseInt(taskbar.getProperties().getProperty("applet.memory.interval", "500"));
        this.total = Runtime.getRuntime().totalMemory();
        this.horizontal = TaskBar.getBarOrientation() == 0;
        Thread thread = new Thread(this, "MemoryApplet");
        thread.setDaemon(true);
        thread.start();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.interval);
                    this.repaint();
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void paint(Graphics g) {
        long free = Runtime.getRuntime().freeMemory();
        if (this.horizontal) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.width, this.height);
            g.setColor(Color.red);
            g.fillRect(0, 0, (int)((long)this.width * (this.total - free) / this.total), this.height);
            g.setColor(Color.black);
            g.drawRect(0, 0, this.width, this.height);
        } else {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.height, this.width);
            g.setColor(Color.red);
            g.fillRect(0, 0, this.height, (int)((long)this.width * (this.total - free) / this.total));
            g.setColor(Color.black);
            g.drawRect(0, 0, this.height, this.width);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.width, this.height);
    }
}

