/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.popupkeyboard;

import com.acunia.wonka.rudolph.popupkeyboard.KeyboardButton;
import com.acunia.wonka.rudolph.popupkeyboard.KeyboardButtonPoly;
import com.acunia.wonka.rudolph.popupkeyboard.KeyboardButtonText;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class Keyboard
extends Window
implements MouseListener {
    public static final boolean POPUPKEYBOARD = false;
    private KeyboardButton[] keys_low;
    private KeyboardButton[] keys_cap;
    private KeyboardButton[] keys_nrs;
    private KeyboardButton[] current_keys;
    private Vector pressed_keys;
    private Image keys_low_img;
    private Image keys_cap_img;
    private Image keys_nrs_img;
    private KeyboardButton k_123_1;
    private KeyboardButton k_123_2;
    private KeyboardButton k_shift;
    private KeyboardButton k_caps;
    private KeyboardButton k_ctrl;
    private KeyboardButton k_enter;
    private KeyboardButton k_enter_num;
    private KeyboardButton lastPressed = null;
    private boolean f_caps = false;
    private boolean f_shift = false;
    private boolean f_num = false;
    private boolean f_ctrl = false;
    private int kbdWidth = 360;
    private int kbdHeight = 200;
    private int textfieldheight = 40;
    private TextField textfield;
    private TextComponent target;
    private String text = "";
    private int position;
    private int selectionStart;
    private int selectionStop;

    public Keyboard(Frame owner) {
        super(owner);
        this.buildKbd();
        this.addMouseListener(this);
        this.current_keys = this.keys_low;
    }

    private void buildKbd() {
        int i;
        this.keys_low = new KeyboardButton[60];
        this.keys_cap = new KeyboardButton[60];
        this.keys_nrs = new KeyboardButton[47];
        this.pressed_keys = new Vector();
        this.k_123_1 = new KeyboardButtonText("123", new int[]{0, 19, 19, 0}, new int[]{0, 0, 16, 16}, 0, '\u0000');
        this.k_123_2 = new KeyboardButtonText("123", new int[]{0, 19, 19, 0}, new int[]{0, 0, 20, 20}, 0, '\u0000');
        this.k_shift = new KeyboardButtonText("Shift", new int[]{0, 33, 33, 0}, new int[]{48, 48, 64, 64}, 16, '\u0000');
        this.k_caps = new KeyboardButtonText("CAP", new int[]{0, 29, 29, 0}, new int[]{32, 32, 48, 48}, 20, '\u0000');
        this.k_ctrl = new KeyboardButtonText("Ctrl", new int[]{0, 22, 22, 0}, new int[]{64, 64, 80, 80}, 17, '\u0000');
        this.k_enter = new KeyboardButtonPoly(new int[]{-6, -2, -3, 4, 4, 6, 6, -3, -2}, new int[]{24, 20, 23, 23, 21, 21, 25, 25, 28}, new int[]{227, 239, 239, 213, 213, 227}, new int[]{32, 32, 64, 64, 48, 48}, 10, '\n');
        this.k_enter_num = new KeyboardButtonPoly(new int[]{2, 6, 5, 12, 12, 14, 14, 5, 6}, new int[]{10, 6, 9, 9, 7, 7, 11, 11, 14}, new int[]{221, 239, 239, 221}, new int[]{60, 60, 80, 80}, 10, '\n');
        this.keys_low[0] = this.k_123_1;
        this.keys_low[1] = new KeyboardButtonText("1", new int[]{19, 36, 36, 19}, new int[]{0, 0, 16, 16}, 49, '1');
        this.keys_low[2] = new KeyboardButtonText("2", new int[]{36, 53, 53, 36}, new int[]{0, 0, 16, 16}, 50, '2');
        this.keys_low[3] = new KeyboardButtonText("3", new int[]{53, 70, 70, 53}, new int[]{0, 0, 16, 16}, 51, '3');
        this.keys_low[4] = new KeyboardButtonText("4", new int[]{70, 87, 87, 70}, new int[]{0, 0, 16, 16}, 52, '4');
        this.keys_low[5] = new KeyboardButtonText("5", new int[]{87, 104, 104, 87}, new int[]{0, 0, 16, 16}, 53, '5');
        this.keys_low[6] = new KeyboardButtonText("6", new int[]{104, 121, 121, 104}, new int[]{0, 0, 16, 16}, 54, '6');
        this.keys_low[7] = new KeyboardButtonText("7", new int[]{121, 138, 138, 121}, new int[]{0, 0, 16, 16}, 55, '7');
        this.keys_low[8] = new KeyboardButtonText("8", new int[]{138, 155, 155, 138}, new int[]{0, 0, 16, 16}, 56, '8');
        this.keys_low[9] = new KeyboardButtonText("9", new int[]{155, 172, 172, 155}, new int[]{0, 0, 16, 16}, 57, '9');
        this.keys_low[10] = new KeyboardButtonText("0", new int[]{172, 189, 189, 172}, new int[]{0, 0, 16, 16}, 48, '0');
        this.keys_low[11] = new KeyboardButtonText("-", new int[]{189, 205, 205, 189}, new int[]{0, 0, 16, 16}, 0, '-');
        this.keys_low[12] = new KeyboardButtonText("=", new int[]{205, 221, 221, 205}, new int[]{0, 0, 16, 16}, 0, '=');
        this.keys_low[13] = new KeyboardButtonPoly(new int[]{4, 9, 9, 14, 14, 9, 9}, new int[]{8, 3, 6, 6, 10, 10, 13}, new int[]{221, 239, 239, 221}, new int[]{0, 0, 16, 16}, 8, '\u0000');
        this.keys_low[14] = new KeyboardButtonText("Tab", new int[]{0, 25, 25, 0}, new int[]{16, 16, 32, 32}, 9, '\u0000');
        this.keys_low[15] = new KeyboardButtonText("q", new int[]{25, 43, 43, 25}, new int[]{16, 16, 32, 32}, 81, 'q');
        this.keys_low[16] = new KeyboardButtonText("w", new int[]{43, 61, 61, 43}, new int[]{16, 16, 32, 32}, 87, 'w');
        this.keys_low[17] = new KeyboardButtonText("e", new int[]{61, 79, 79, 61}, new int[]{16, 16, 32, 32}, 69, 'e');
        this.keys_low[18] = new KeyboardButtonText("r", new int[]{79, 97, 97, 79}, new int[]{16, 16, 32, 32}, 82, 'r');
        this.keys_low[19] = new KeyboardButtonText("t", new int[]{97, 115, 115, 97}, new int[]{16, 16, 32, 32}, 84, 't');
        this.keys_low[20] = new KeyboardButtonText("y", new int[]{115, 133, 133, 115}, new int[]{16, 16, 32, 32}, 89, 'y');
        this.keys_low[21] = new KeyboardButtonText("u", new int[]{133, 151, 151, 133}, new int[]{16, 16, 32, 32}, 85, 'u');
        this.keys_low[22] = new KeyboardButtonText("i", new int[]{151, 169, 169, 151}, new int[]{16, 16, 32, 32}, 73, 'i');
        this.keys_low[23] = new KeyboardButtonText("o", new int[]{169, 187, 187, 169}, new int[]{16, 16, 32, 32}, 79, 'o');
        this.keys_low[24] = new KeyboardButtonText("p", new int[]{187, 205, 205, 187}, new int[]{16, 16, 32, 32}, 80, 'p');
        this.keys_low[25] = new KeyboardButtonText("[", new int[]{205, 222, 222, 205}, new int[]{16, 16, 32, 32}, 91, '[');
        this.keys_low[26] = new KeyboardButtonText("]", new int[]{222, 239, 239, 222}, new int[]{16, 16, 32, 32}, 93, ']');
        this.keys_low[27] = this.k_caps;
        this.keys_low[28] = new KeyboardButtonText("a", new int[]{29, 47, 47, 29}, new int[]{32, 32, 48, 48}, 65, 'a');
        this.keys_low[29] = new KeyboardButtonText("s", new int[]{47, 65, 65, 47}, new int[]{32, 32, 48, 48}, 83, 's');
        this.keys_low[30] = new KeyboardButtonText("d", new int[]{65, 83, 83, 65}, new int[]{32, 32, 48, 48}, 68, 'd');
        this.keys_low[31] = new KeyboardButtonText("f", new int[]{83, 101, 101, 83}, new int[]{32, 32, 48, 48}, 70, 'f');
        this.keys_low[32] = new KeyboardButtonText("g", new int[]{101, 119, 119, 101}, new int[]{32, 32, 48, 48}, 71, 'g');
        this.keys_low[33] = new KeyboardButtonText("h", new int[]{119, 137, 137, 119}, new int[]{32, 32, 48, 48}, 72, 'h');
        this.keys_low[34] = new KeyboardButtonText("j", new int[]{137, 155, 155, 137}, new int[]{32, 32, 48, 48}, 74, 'j');
        this.keys_low[35] = new KeyboardButtonText("k", new int[]{155, 173, 173, 155}, new int[]{32, 32, 48, 48}, 75, 'k');
        this.keys_low[36] = new KeyboardButtonText("l", new int[]{173, 191, 191, 173}, new int[]{32, 32, 48, 48}, 76, 'l');
        this.keys_low[37] = new KeyboardButtonText(";", new int[]{191, 209, 209, 191}, new int[]{32, 32, 48, 48}, 59, ';');
        this.keys_low[38] = new KeyboardButtonText("'", new int[]{209, 227, 227, 209}, new int[]{32, 32, 48, 48}, 222, '\'');
        this.keys_low[39] = this.k_enter;
        this.keys_low[40] = this.k_shift;
        this.keys_low[41] = new KeyboardButtonText("z", new int[]{33, 51, 51, 33}, new int[]{48, 48, 64, 64}, 90, 'z');
        this.keys_low[42] = new KeyboardButtonText("x", new int[]{51, 69, 69, 51}, new int[]{48, 48, 64, 64}, 88, 'x');
        this.keys_low[43] = new KeyboardButtonText("c", new int[]{69, 87, 87, 69}, new int[]{48, 48, 64, 64}, 67, 'c');
        this.keys_low[44] = new KeyboardButtonText("v", new int[]{87, 105, 105, 87}, new int[]{48, 48, 64, 64}, 86, 'v');
        this.keys_low[45] = new KeyboardButtonText("b", new int[]{105, 123, 123, 105}, new int[]{48, 48, 64, 64}, 66, 'b');
        this.keys_low[46] = new KeyboardButtonText("n", new int[]{123, 141, 141, 123}, new int[]{48, 48, 64, 64}, 78, 'n');
        this.keys_low[47] = new KeyboardButtonText("m", new int[]{141, 159, 159, 141}, new int[]{48, 48, 64, 64}, 77, 'm');
        this.keys_low[48] = new KeyboardButtonText(",", new int[]{159, 177, 177, 159}, new int[]{48, 48, 64, 64}, 44, ',');
        this.keys_low[49] = new KeyboardButtonText(".", new int[]{177, 195, 195, 177}, new int[]{48, 48, 64, 64}, 46, '.');
        this.keys_low[50] = new KeyboardButtonText("/", new int[]{195, 213, 213, 195}, new int[]{48, 48, 64, 64}, 47, '/');
        this.keys_low[51] = this.k_ctrl;
        this.keys_low[52] = new KeyboardButtonText("au", new int[]{22, 44, 44, 22}, new int[]{64, 64, 80, 80}, 0, '\u0000');
        this.keys_low[53] = new KeyboardButtonText("`", new int[]{44, 62, 62, 44}, new int[]{64, 64, 80, 80}, 192, '`');
        this.keys_low[54] = new KeyboardButtonText("\\", new int[]{62, 80, 80, 62}, new int[]{64, 64, 80, 80}, 92, '\\');
        this.keys_low[55] = new KeyboardButtonText(" ", new int[]{80, 167, 167, 80}, new int[]{64, 64, 80, 80}, 32, ' ');
        this.keys_low[56] = new KeyboardButtonPoly(new int[]{8, 4, 7, 7, 9, 9, 12}, new int[]{4, 8, 7, 12, 12, 7, 8}, new int[]{167, 185, 185, 167}, new int[]{64, 64, 80, 80}, 38, '\u0000');
        this.keys_low[57] = new KeyboardButtonPoly(new int[]{8, 4, 7, 7, 9, 9, 12}, new int[]{12, 8, 9, 4, 4, 9, 8}, new int[]{185, 203, 203, 185}, new int[]{64, 64, 80, 80}, 40, '\u0000');
        this.keys_low[58] = new KeyboardButtonPoly(new int[]{5, 9, 8, 13, 13, 8, 9}, new int[]{8, 4, 7, 7, 9, 9, 12}, new int[]{203, 221, 221, 203}, new int[]{64, 64, 80, 80}, 37, '\u0000');
        this.keys_low[59] = new KeyboardButtonPoly(new int[]{13, 9, 10, 5, 5, 10, 9}, new int[]{8, 4, 7, 7, 9, 9, 12}, new int[]{221, 239, 239, 221}, new int[]{64, 64, 80, 80}, 39, '\u0000');
        this.keys_cap[0] = this.k_123_1;
        this.keys_cap[1] = new KeyboardButtonText("!", new int[]{19, 36, 36, 19}, new int[]{0, 0, 16, 16}, 0, '!');
        this.keys_cap[2] = new KeyboardButtonText("@", new int[]{36, 53, 53, 36}, new int[]{0, 0, 16, 16}, 0, '@');
        this.keys_cap[3] = new KeyboardButtonText("#", new int[]{53, 70, 70, 53}, new int[]{0, 0, 16, 16}, 0, '#');
        this.keys_cap[4] = new KeyboardButtonText("$", new int[]{70, 87, 87, 70}, new int[]{0, 0, 16, 16}, 0, '$');
        this.keys_cap[5] = new KeyboardButtonText("%", new int[]{87, 104, 104, 87}, new int[]{0, 0, 16, 16}, 0, '%');
        this.keys_cap[6] = new KeyboardButtonText("^", new int[]{104, 121, 121, 104}, new int[]{0, 0, 16, 16}, 0, '^');
        this.keys_cap[7] = new KeyboardButtonText("&", new int[]{121, 138, 138, 121}, new int[]{0, 0, 16, 16}, 0, '&');
        this.keys_cap[8] = new KeyboardButtonText("*", new int[]{138, 155, 155, 138}, new int[]{0, 0, 16, 16}, 0, '*');
        this.keys_cap[9] = new KeyboardButtonText("(", new int[]{155, 172, 172, 155}, new int[]{0, 0, 16, 16}, 0, '(');
        this.keys_cap[10] = new KeyboardButtonText(")", new int[]{172, 189, 189, 172}, new int[]{0, 0, 16, 16}, 0, ')');
        this.keys_cap[11] = new KeyboardButtonText("_", new int[]{189, 205, 205, 189}, new int[]{0, 0, 16, 16}, 0, '_');
        this.keys_cap[12] = new KeyboardButtonText("+", new int[]{205, 221, 221, 205}, new int[]{0, 0, 16, 16}, 0, '+');
        this.keys_cap[13] = new KeyboardButtonText("Del", new int[]{221, 239, 239, 221}, new int[]{0, 0, 16, 16}, 127, '\u0000');
        this.keys_cap[14] = new KeyboardButtonText("Tab", new int[]{0, 25, 25, 0}, new int[]{16, 16, 32, 32}, 9, '\u0000');
        this.keys_cap[15] = new KeyboardButtonText("Q", new int[]{25, 43, 43, 25}, new int[]{16, 16, 32, 32}, 81, 'Q');
        this.keys_cap[16] = new KeyboardButtonText("W", new int[]{43, 61, 61, 43}, new int[]{16, 16, 32, 32}, 87, 'W');
        this.keys_cap[17] = new KeyboardButtonText("E", new int[]{61, 79, 79, 61}, new int[]{16, 16, 32, 32}, 69, 'E');
        this.keys_cap[18] = new KeyboardButtonText("R", new int[]{79, 97, 97, 79}, new int[]{16, 16, 32, 32}, 82, 'R');
        this.keys_cap[19] = new KeyboardButtonText("T", new int[]{97, 115, 115, 97}, new int[]{16, 16, 32, 32}, 84, 'T');
        this.keys_cap[20] = new KeyboardButtonText("Y", new int[]{115, 133, 133, 115}, new int[]{16, 16, 32, 32}, 89, 'Y');
        this.keys_cap[21] = new KeyboardButtonText("U", new int[]{133, 151, 151, 133}, new int[]{16, 16, 32, 32}, 85, 'U');
        this.keys_cap[22] = new KeyboardButtonText("I", new int[]{151, 169, 169, 151}, new int[]{16, 16, 32, 32}, 73, 'I');
        this.keys_cap[23] = new KeyboardButtonText("O", new int[]{169, 187, 187, 169}, new int[]{16, 16, 32, 32}, 79, 'O');
        this.keys_cap[24] = new KeyboardButtonText("P", new int[]{187, 205, 205, 187}, new int[]{16, 16, 32, 32}, 80, 'P');
        this.keys_cap[25] = new KeyboardButtonText("{", new int[]{205, 222, 222, 205}, new int[]{16, 16, 32, 32}, 0, '{');
        this.keys_cap[26] = new KeyboardButtonText("}", new int[]{222, 239, 239, 222}, new int[]{16, 16, 32, 32}, 0, '}');
        this.keys_cap[27] = this.k_caps;
        this.keys_cap[28] = new KeyboardButtonText("A", new int[]{29, 47, 47, 29}, new int[]{32, 32, 48, 48}, 65, 'A');
        this.keys_cap[29] = new KeyboardButtonText("S", new int[]{47, 65, 65, 47}, new int[]{32, 32, 48, 48}, 83, 'S');
        this.keys_cap[30] = new KeyboardButtonText("D", new int[]{65, 83, 83, 65}, new int[]{32, 32, 48, 48}, 68, 'D');
        this.keys_cap[31] = new KeyboardButtonText("F", new int[]{83, 101, 101, 83}, new int[]{32, 32, 48, 48}, 70, 'F');
        this.keys_cap[32] = new KeyboardButtonText("G", new int[]{101, 119, 119, 101}, new int[]{32, 32, 48, 48}, 71, 'G');
        this.keys_cap[33] = new KeyboardButtonText("H", new int[]{119, 137, 137, 119}, new int[]{32, 32, 48, 48}, 72, 'H');
        this.keys_cap[34] = new KeyboardButtonText("J", new int[]{137, 155, 155, 137}, new int[]{32, 32, 48, 48}, 74, 'J');
        this.keys_cap[35] = new KeyboardButtonText("K", new int[]{155, 173, 173, 155}, new int[]{32, 32, 48, 48}, 75, 'K');
        this.keys_cap[36] = new KeyboardButtonText("L", new int[]{173, 191, 191, 173}, new int[]{32, 32, 48, 48}, 76, 'L');
        this.keys_cap[37] = new KeyboardButtonText(":", new int[]{191, 209, 209, 191}, new int[]{32, 32, 48, 48}, 0, ':');
        this.keys_cap[38] = new KeyboardButtonText("\"", new int[]{209, 227, 227, 209}, new int[]{32, 32, 48, 48}, 0, '\\');
        this.keys_cap[39] = this.k_enter;
        this.keys_cap[40] = this.k_shift;
        this.keys_cap[41] = new KeyboardButtonText("Z", new int[]{33, 51, 51, 33}, new int[]{48, 48, 64, 64}, 90, 'Z');
        this.keys_cap[42] = new KeyboardButtonText("X", new int[]{51, 69, 69, 51}, new int[]{48, 48, 64, 64}, 88, 'X');
        this.keys_cap[43] = new KeyboardButtonText("C", new int[]{69, 87, 87, 69}, new int[]{48, 48, 64, 64}, 67, 'C');
        this.keys_cap[44] = new KeyboardButtonText("V", new int[]{87, 105, 105, 87}, new int[]{48, 48, 64, 64}, 86, 'V');
        this.keys_cap[45] = new KeyboardButtonText("B", new int[]{105, 123, 123, 105}, new int[]{48, 48, 64, 64}, 66, 'B');
        this.keys_cap[46] = new KeyboardButtonText("N", new int[]{123, 141, 141, 123}, new int[]{48, 48, 64, 64}, 78, 'N');
        this.keys_cap[47] = new KeyboardButtonText("M", new int[]{141, 159, 159, 141}, new int[]{48, 48, 64, 64}, 77, 'M');
        this.keys_cap[48] = new KeyboardButtonText("<", new int[]{159, 177, 177, 159}, new int[]{48, 48, 64, 64}, 0, '<');
        this.keys_cap[49] = new KeyboardButtonText(">", new int[]{177, 195, 195, 177}, new int[]{48, 48, 64, 64}, 0, '>');
        this.keys_cap[50] = new KeyboardButtonText("?", new int[]{195, 213, 213, 195}, new int[]{48, 48, 64, 64}, 0, '?');
        this.keys_cap[51] = this.k_ctrl;
        this.keys_cap[52] = new KeyboardButtonText("au", new int[]{22, 44, 44, 22}, new int[]{64, 64, 80, 80}, 0, '\u0000');
        this.keys_cap[53] = new KeyboardButtonText("~", new int[]{44, 62, 62, 44}, new int[]{64, 64, 80, 80}, 0, '~');
        this.keys_cap[54] = new KeyboardButtonText("|", new int[]{62, 80, 80, 62}, new int[]{64, 64, 80, 80}, 0, '|');
        this.keys_cap[55] = new KeyboardButtonText(" ", new int[]{80, 167, 167, 80}, new int[]{64, 64, 80, 80}, 32, ' ');
        this.keys_cap[56] = new KeyboardButtonPoly(new int[]{8, 4, 7, 7, 9, 9, 12}, new int[]{4, 8, 7, 12, 12, 7, 8}, new int[]{167, 185, 185, 167}, new int[]{64, 64, 80, 80}, 38, '\u0000');
        this.keys_cap[57] = new KeyboardButtonPoly(new int[]{8, 4, 7, 7, 9, 9, 12}, new int[]{12, 8, 9, 4, 4, 9, 8}, new int[]{185, 203, 203, 185}, new int[]{64, 64, 80, 80}, 40, '\u0000');
        this.keys_cap[58] = new KeyboardButtonPoly(new int[]{5, 9, 8, 13, 13, 8, 9}, new int[]{8, 4, 7, 7, 9, 9, 12}, new int[]{203, 221, 221, 203}, new int[]{64, 64, 80, 80}, 37, '\u0000');
        this.keys_cap[59] = new KeyboardButtonPoly(new int[]{13, 9, 10, 5, 5, 10, 9}, new int[]{8, 4, 7, 7, 9, 9, 12}, new int[]{221, 239, 239, 221}, new int[]{64, 64, 80, 80}, 39, '\u0000');
        this.keys_nrs[0] = this.k_123_2;
        this.keys_nrs[1] = new KeyboardButtonText("[", new int[]{19, 36, 36, 19}, new int[]{0, 0, 20, 20}, 91, '\u0000');
        this.keys_nrs[2] = new KeyboardButtonText("]", new int[]{36, 53, 53, 36}, new int[]{0, 0, 20, 20}, 93, '\u0000');
        this.keys_nrs[3] = new KeyboardButtonText("{", new int[]{53, 70, 70, 53}, new int[]{0, 0, 20, 20}, 0, '{');
        this.keys_nrs[4] = new KeyboardButtonText("}", new int[]{70, 87, 87, 70}, new int[]{0, 0, 20, 20}, 0, '}');
        this.keys_nrs[5] = new KeyboardButtonText("7", new int[]{93, 113, 113, 93}, new int[]{0, 0, 20, 20}, 103, '7');
        this.keys_nrs[6] = new KeyboardButtonText("8", new int[]{113, 133, 133, 113}, new int[]{0, 0, 20, 20}, 104, '8');
        this.keys_nrs[7] = new KeyboardButtonText("9", new int[]{133, 153, 153, 133}, new int[]{0, 0, 20, 20}, 105, '9');
        this.keys_nrs[8] = new KeyboardButtonText("#", new int[]{159, 179, 179, 159}, new int[]{0, 0, 20, 20}, 0, '#');
        this.keys_nrs[9] = new KeyboardButtonText("%", new int[]{179, 199, 199, 179}, new int[]{0, 0, 20, 20}, 0, '%');
        this.keys_nrs[10] = new KeyboardButtonText("=", new int[]{199, 219, 219, 199}, new int[]{0, 0, 20, 20}, 0, '=');
        this.keys_nrs[11] = new KeyboardButtonPoly(new int[]{5, 10, 10, 15, 15, 10, 10}, new int[]{10, 5, 8, 8, 12, 12, 15}, new int[]{219, 239, 239, 219}, new int[]{0, 0, 20, 20}, 8, '\u0000');
        this.keys_nrs[12] = new KeyboardButtonText("^", new int[]{0, 19, 19, 0}, new int[]{20, 20, 40, 40}, 0, '^');
        this.keys_nrs[13] = new KeyboardButtonText(",", new int[]{19, 36, 36, 19}, new int[]{20, 20, 40, 40}, 108, ',');
        this.keys_nrs[14] = new KeyboardButtonText(".", new int[]{36, 53, 53, 36}, new int[]{20, 20, 40, 40}, 110, '.');
        this.keys_nrs[15] = new KeyboardButtonText("<", new int[]{53, 70, 70, 53}, new int[]{20, 20, 40, 40}, 0, '<');
        this.keys_nrs[16] = new KeyboardButtonText(">", new int[]{70, 87, 87, 70}, new int[]{20, 20, 40, 40}, 0, '>');
        this.keys_nrs[17] = new KeyboardButtonText("4", new int[]{93, 113, 113, 93}, new int[]{20, 20, 40, 40}, 100, '4');
        this.keys_nrs[18] = new KeyboardButtonText("5", new int[]{113, 133, 133, 113}, new int[]{20, 20, 40, 40}, 101, '5');
        this.keys_nrs[19] = new KeyboardButtonText("6", new int[]{133, 153, 153, 133}, new int[]{20, 20, 40, 40}, 102, '6');
        this.keys_nrs[20] = new KeyboardButtonText("+", new int[]{159, 179, 179, 159}, new int[]{20, 20, 40, 40}, 107, '+');
        this.keys_nrs[21] = new KeyboardButtonText("-", new int[]{179, 199, 199, 179}, new int[]{20, 20, 40, 40}, 109, '-');
        this.keys_nrs[22] = new KeyboardButtonText("*", new int[]{199, 219, 219, 199}, new int[]{20, 20, 40, 40}, 106, '*');
        this.keys_nrs[23] = new KeyboardButtonText("/", new int[]{219, 239, 239, 219}, new int[]{20, 20, 40, 40}, 111, '/');
        this.keys_nrs[24] = new KeyboardButtonText(" ", new int[]{0, 19, 19, 0}, new int[]{40, 40, 60, 60}, 0, '\u0000');
        this.keys_nrs[25] = new KeyboardButtonText(" ", new int[]{19, 36, 36, 19}, new int[]{40, 40, 60, 60}, 0, '\u0000');
        this.keys_nrs[26] = new KeyboardButtonText(":", new int[]{36, 53, 53, 36}, new int[]{40, 40, 60, 60}, 0, ':');
        this.keys_nrs[27] = new KeyboardButtonText("\\", new int[]{53, 70, 70, 53}, new int[]{40, 40, 60, 60}, 92, '\\');
        this.keys_nrs[28] = new KeyboardButtonText("|", new int[]{70, 87, 87, 70}, new int[]{40, 40, 60, 60}, 0, '|');
        this.keys_nrs[29] = new KeyboardButtonText("1", new int[]{93, 113, 113, 93}, new int[]{40, 40, 60, 60}, 97, '1');
        this.keys_nrs[30] = new KeyboardButtonText("2", new int[]{113, 133, 133, 113}, new int[]{40, 40, 60, 60}, 98, '2');
        this.keys_nrs[31] = new KeyboardButtonText("3", new int[]{133, 153, 153, 133}, new int[]{40, 40, 60, 60}, 99, '3');
        this.keys_nrs[32] = new KeyboardButtonPoly(new int[]{10, 6, 9, 9, 11, 11, 14}, new int[]{6, 10, 9, 14, 14, 9, 10}, new int[]{159, 179, 179, 159}, new int[]{40, 40, 60, 60}, 38, '\u0000');
        this.keys_nrs[33] = new KeyboardButtonPoly(new int[]{10, 6, 9, 9, 11, 11, 14}, new int[]{14, 10, 11, 6, 6, 11, 10}, new int[]{179, 199, 199, 179}, new int[]{40, 40, 60, 60}, 40, '\u0000');
        this.keys_nrs[34] = new KeyboardButtonPoly(new int[]{6, 10, 9, 14, 14, 9, 10}, new int[]{10, 6, 9, 9, 11, 11, 14}, new int[]{199, 219, 219, 199}, new int[]{40, 40, 60, 60}, 37, '\u0000');
        this.keys_nrs[35] = new KeyboardButtonPoly(new int[]{14, 10, 11, 6, 6, 11, 10}, new int[]{10, 6, 9, 9, 11, 11, 14}, new int[]{219, 239, 239, 219}, new int[]{40, 40, 60, 60}, 39, '\u0000');
        this.keys_nrs[36] = new KeyboardButtonText("$", new int[]{0, 19, 19, 0}, new int[]{60, 60, 80, 80}, 0, '$');
        this.keys_nrs[37] = new KeyboardButtonText(" ", new int[]{19, 36, 36, 19}, new int[]{60, 60, 80, 80}, 0, '\u0000');
        this.keys_nrs[38] = new KeyboardButtonText("\u20ac", new int[]{36, 53, 53, 36}, new int[]{60, 60, 80, 80}, 0, '\u0000');
        this.keys_nrs[39] = new KeyboardButtonText("\u00a3", new int[]{53, 70, 70, 53}, new int[]{60, 60, 80, 80}, 0, '\u0000');
        this.keys_nrs[40] = new KeyboardButtonText("\u00a5", new int[]{70, 87, 87, 70}, new int[]{60, 60, 80, 80}, 0, '\u0000');
        this.keys_nrs[41] = new KeyboardButtonText("(", new int[]{93, 113, 113, 93}, new int[]{60, 60, 80, 80}, 0, '(');
        this.keys_nrs[42] = new KeyboardButtonText("0", new int[]{113, 133, 133, 113}, new int[]{60, 60, 80, 80}, 96, '0');
        this.keys_nrs[43] = new KeyboardButtonText(")", new int[]{133, 153, 153, 133}, new int[]{60, 60, 80, 80}, 0, ')');
        this.keys_nrs[44] = new KeyboardButtonText("Tab", new int[]{159, 183, 183, 159}, new int[]{60, 60, 80, 80}, 9, '\u0000');
        this.keys_nrs[45] = new KeyboardButtonText("Space", new int[]{183, 221, 221, 183}, new int[]{60, 60, 80, 80}, 32, ' ');
        this.keys_nrs[46] = this.k_enter_num;
        this.setLayout(null);
        this.textfield = new TextField("");
        this.textfield.setFont(new Font("Helvetica", 0, 12));
        this.setFont(new Font("Helvetica", 0, 12));
        this.kbdWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.kbdHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.add(this.textfield);
        this.textfield.validate();
        this.kbdHeight -= this.textfieldheight;
        this.textfield.setBounds(2, 0, this.kbdWidth - 4, this.textfieldheight);
        int size = this.keys_nrs.length;
        for (i = 0; i < size; ++i) {
            this.keys_nrs[i].setScale(this.kbdWidth, this.kbdHeight, 240, 81);
            this.keys_nrs[i].setTranslate(0, this.textfieldheight);
        }
        size = this.keys_low.length;
        for (i = 0; i < size; ++i) {
            this.keys_low[i].setScale(this.kbdWidth, this.kbdHeight, 240, 81);
            this.keys_low[i].setTranslate(0, this.textfieldheight);
        }
        size = this.keys_cap.length;
        for (i = 0; i < size; ++i) {
            this.keys_cap[i].setScale(this.kbdWidth, this.kbdHeight, 240, 81);
            this.keys_cap[i].setTranslate(0, this.textfieldheight);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    private Image drawKeyboard() {
        KeyboardButton[] local = this.current_keys;
        Image result = this.createImage(this.getSize().width, this.getSize().height);
        Graphics img = result.getGraphics();
        int size = local.length;
        for (int i = 0; i < size; ++i) {
            local[i].paint_img(img);
        }
        return result;
    }

    public void paint(Graphics g) {
        if (this.current_keys == this.keys_low) {
            if (this.keys_low_img == null) {
                this.keys_low_img = this.drawKeyboard();
            }
            g.drawImage(this.keys_low_img, 0, 0, null);
        } else if (this.current_keys == this.keys_cap) {
            if (this.keys_cap_img == null) {
                this.keys_cap_img = this.drawKeyboard();
            }
            g.drawImage(this.keys_cap_img, 0, 0, null);
        } else if (this.current_keys == this.keys_nrs) {
            if (this.keys_nrs_img == null) {
                this.keys_nrs_img = this.drawKeyboard();
            }
            g.drawImage(this.keys_nrs_img, 0, 0, null);
        }
        int size = this.pressed_keys.size();
        for (int i = 0; i < size; ++i) {
            ((KeyboardButton)this.pressed_keys.elementAt(i)).paint(g);
        }
    }

    private KeyboardButton getKey(int x, int y) {
        KeyboardButton[] local = this.current_keys;
        int size = local.length;
        for (int i = 0; i < size; ++i) {
            if (!local[i].contains(x, y)) continue;
            return local[i];
        }
        return null;
    }

    public void sendKeyEvent(int keyCode, char keyChar) {
        if (this.target != null) {
            this.target.setText(this.textfield.getText());
            this.target.setCaretPosition(this.textfield.getCaretPosition());
            this.target.select(this.textfield.getSelectionStart(), this.textfield.getSelectionEnd());
            KeyEvent ke = new KeyEvent(this.target, 401, System.currentTimeMillis(), 0, keyCode, keyChar);
            this.target.dispatchEvent(ke);
            ke = new KeyEvent(this.target, 400, System.currentTimeMillis(), 0, keyCode, keyChar);
            this.target.dispatchEvent(ke);
            this.keyTyped(keyCode, keyChar);
            this.textfield.setText(this.target.getText());
            this.textfield.setCaretPosition(this.target.getCaretPosition());
            this.textfield.select(this.target.getSelectionStart(), this.target.getSelectionEnd());
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.kbdWidth, this.kbdHeight + this.textfieldheight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.kbdWidth, this.kbdHeight + this.textfieldheight);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.kbdWidth, this.kbdHeight + this.textfieldheight);
    }

    public void open(TextComponent component) {
        if (component != this.textfield) {
            this.setBounds(0, 0, this.getPreferredSize().width, this.getPreferredSize().height);
            this.toFront();
            this.show();
            this.target = component;
            this.textfield.setText(this.target.getText());
            this.textfield.setCaretPosition(this.target.getCaretPosition());
            this.textfield.select(this.target.getSelectionStart(), this.target.getSelectionEnd());
            this.text = this.target.getText();
        }
    }

    public void close() {
        this.toBack();
        this.setVisible(false);
    }

    private void setPressed(KeyboardButton key, boolean state) {
        key.setPressed(state);
        if (state) {
            this.pressed_keys.add(key);
        } else {
            this.pressed_keys.remove(key);
        }
    }

    public void mousePressed(MouseEvent event) {
        KeyboardButton key = this.getKey(event.getX(), event.getY());
        if (key != null) {
            if (key == this.k_caps) {
                if (key.getPressed()) {
                    this.f_caps = false;
                    this.current_keys = this.keys_low;
                    this.setPressed(key, false);
                } else {
                    this.f_caps = true;
                    this.current_keys = this.keys_cap;
                    this.setPressed(key, true);
                }
                this.lastPressed = null;
                this.repaint();
            } else if (key == this.k_123_1) {
                this.f_caps = false;
                this.f_shift = false;
                this.f_num = true;
                this.current_keys = this.keys_nrs;
                this.pressed_keys.clear();
                this.setPressed(this.k_123_2, true);
                this.repaint();
            } else if (key == this.k_123_2) {
                this.setPressed(this.k_123_2, false);
                this.current_keys = this.keys_low;
                this.f_num = false;
                this.repaint();
            } else if (key == this.k_shift) {
                if (key.getPressed()) {
                    this.setPressed(key, false);
                    this.current_keys = this.f_caps ? this.keys_cap : this.keys_low;
                    this.f_shift = false;
                } else {
                    this.setPressed(key, true);
                    this.current_keys = this.f_caps ? this.keys_low : this.keys_cap;
                    this.f_shift = true;
                }
                this.repaint();
            } else if (key == this.k_enter || key == this.k_enter_num) {
                this.close();
                if (this.target != null) {
                    this.target.dispatchEvent(new ActionEvent(this.target, 1001, ""));
                }
            } else {
                this.lastPressed = key;
                this.setPressed(key, true);
                this.repaint();
                this.sendKeyEvent(key.getKeyEvent(), key.getKeyChar());
            }
        }
        this.textfield.requestFocus();
    }

    public void mouseReleased(MouseEvent event) {
        if (this.lastPressed != null) {
            this.setPressed(this.lastPressed, false);
            if (this.f_shift) {
                this.f_shift = false;
                this.setPressed(this.k_shift, false);
                this.current_keys = this.f_caps ? this.keys_cap : this.keys_low;
            }
            this.lastPressed = null;
            this.repaint();
        }
        this.textfield.requestFocus();
    }

    public void mouseClicked(MouseEvent event) {
        this.textfield.requestFocus();
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    private int getCaretPosition() {
        this.position = this.textfield.getCaretPosition();
        return this.position;
    }

    private void setCaretPosition(int newposition) {
        this.textfield.setCaretPosition(newposition);
        this.position = this.textfield.getCaretPosition();
    }

    private int getSelectionStart() {
        this.selectionStart = this.textfield.getSelectionStart();
        return this.selectionStart;
    }

    private int getSelectionEnd() {
        this.selectionStop = this.textfield.getSelectionEnd();
        return this.selectionStop;
    }

    private void select(int start, int end) {
        this.textfield.select(start, end);
        this.getSelectionStart();
        this.getSelectionEnd();
    }

    public void keyTyped(int keyCode, char keyChar) {
        this.getSelectionStart();
        this.getSelectionEnd();
        this.getCaretPosition();
        switch (keyCode) {
            case 37: {
                this.moveCaret(this.getCaretPosition() - 1);
                break;
            }
            case 39: {
                this.moveCaret(this.getCaretPosition() + 1);
                break;
            }
            case 8: {
                if (this.getSelectionStart() < this.getSelectionEnd()) {
                    this.deleteSelection();
                    break;
                }
                this.deleteCaret(this.getCaretPosition() - 1);
                break;
            }
            case 127: {
                if (this.getSelectionStart() < this.getSelectionEnd()) {
                    this.deleteSelection();
                    break;
                }
                this.deleteCaret(this.getCaretPosition());
                break;
            }
            case 16: 
            case 17: 
            case 38: 
            case 40: {
                break;
            }
            default: {
                if (keyChar == '\u0000') break;
                if (this.getSelectionStart() < this.getSelectionEnd()) {
                    this.insertSelection(keyChar);
                    break;
                }
                this.insertCaret(this.getCaretPosition(), keyChar);
            }
        }
    }

    private boolean moveCaret(int newpos) {
        if (newpos < 0 || newpos > this.text.length() || newpos == this.getCaretPosition()) {
            return false;
        }
        this.setCaretPosition(newpos);
        this.select(newpos, newpos);
        return true;
    }

    private boolean deleteCaret(int newpos) {
        if (newpos < 0 || newpos >= this.text.length()) {
            return false;
        }
        this.text = new String(new StringBuffer(this.text).deleteCharAt(newpos));
        this.textfield.setText(this.text);
        this.setCaretPosition(newpos);
        this.select(newpos, newpos);
        return true;
    }

    private void deleteSelection() {
        this.text = new String(new StringBuffer(this.text).delete(this.selectionStart, this.selectionStop));
        this.textfield.setText(this.text);
        this.setCaretPosition(this.selectionStart);
        this.select(this.position, this.position);
    }

    private boolean insertCaret(int newpos, char c) {
        if (newpos < 0 || newpos > this.text.length()) {
            return false;
        }
        this.text = new String(new StringBuffer(this.text).insert(newpos, c));
        this.textfield.setText(this.text);
        this.setCaretPosition(newpos + 1);
        this.select(this.position, this.position);
        return true;
    }

    private void insertSelection(char c) {
        StringBuffer buf = new StringBuffer(this.text);
        buf.delete(this.selectionStart, this.selectionStop);
        buf.insert(this.selectionStart, c);
        this.text = new String(buf);
        this.textfield.setText(this.text);
        this.setCaretPosition(this.selectionStart);
        this.select(this.position, this.position);
    }
}

