/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.RudolphPeer;
import com.acunia.wonka.rudolph.peers.RudolphTextAreaPeer;
import com.acunia.wonka.rudolph.peers.TextAreaPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class TextAreaPainter_WrappingVarFont
extends TextAreaPainter {
    public void setImage(String text) {
        this.textBuffer = new char[text.length()];
        text.getChars(0, this.textBuffer.length, this.textBuffer, 0);
        if (this.viewport.width > 0) {
            this.calculateVisibleLineparts();
        } else {
            this.textlineEnd = new int[0];
        }
    }

    protected void calculateVisibleLineparts() {
        if (this.textBuffer.length <= 0 || this.viewport.width <= 0) {
            this.textlineEnd = new int[0];
            this.viewTextOffset = new int[0];
            this.viewTextLength = new int[0];
            return;
        }
        int words = 1;
        int i = 0;
        while (i < this.textBuffer.length) {
            if (this.textBuffer[i] == ' ' || this.textBuffer[i] == '\n' || this.textBuffer[i] == '.' || this.textBuffer[i] == ',' || this.textBuffer[i] == '?' || this.textBuffer[i] == ':' || this.textBuffer[i] == ';') {
                ++words;
            }
            ++i;
        }
        int[] wordstart = new int[words];
        int[] wordlen = new int[words];
        int[] wordwidth = new int[words];
        char[] startchar = new char[words];
        int line = 0;
        wordstart[0] = 0;
        startchar[0] = 10;
        i = 1;
        while (i < this.textBuffer.length - 1) {
            if (this.textBuffer[i] == '\n' || this.textBuffer[i] == ' ' || this.textBuffer[i] == '.' || this.textBuffer[i] == ',' || this.textBuffer[i] == '?' || this.textBuffer[i] == ':' || this.textBuffer[i] == ';') {
                wordlen[line] = this.textBuffer[i] == '\n' || this.textBuffer[i] == ' ' ? i - wordstart[line] : i - wordstart[line] + 1;
                wordwidth[line] = this.painterMetrics.charsWidth(this.textBuffer, wordstart[line], wordlen[line]);
                wordstart[++line] = i + 1;
                startchar[line] = this.textBuffer[i];
            }
            ++i;
        }
        wordlen[line] = this.textBuffer.length - wordstart[line];
        wordwidth[line] = this.painterMetrics.charsWidth(this.textBuffer, wordstart[line], wordlen[line]);
        int last = words - 1;
        i = 0;
        while (i < last) {
            if (wordwidth[i] >= this.viewport.width) {
                startchar[i] = 10;
                wordlen[i] = RudolphPeer.getChars(this.viewport.width, wordstart[i], this.textBuffer, this.painterMetrics) - wordstart[i];
                wordwidth[i] = this.viewport.width;
                startchar[i + 1] = 10;
            }
            ++i;
        }
        if (wordwidth[i] >= this.viewport.width) {
            startchar[last] = 10;
            wordlen[last] = RudolphPeer.getChars(this.viewport.width, wordstart[last], this.textBuffer, this.painterMetrics) - wordstart[last];
            wordwidth[last] = this.viewport.width;
        }
        line = 1;
        int curwidth = wordwidth[0];
        int spacechar = this.painterMetrics.charWidth(' ');
        i = 1;
        while (i < words) {
            if (startchar[i] == '\n') {
                curwidth = wordwidth[i];
                ++line;
            } else if (startchar[i] == ' ') {
                if ((curwidth += wordwidth[i] + spacechar) > this.viewport.width) {
                    startchar[i] = 10;
                    curwidth = wordwidth[i];
                    ++line;
                }
            } else if ((curwidth += wordwidth[i]) > this.viewport.width) {
                startchar[i] = 10;
                curwidth = wordwidth[i];
                ++line;
            }
            ++i;
        }
        this.textlineEnd = new int[line];
        this.viewTextOffset = new int[line];
        this.viewTextLength = new int[line];
        line = 0;
        this.viewTextOffset[0] = wordstart[0];
        i = 1;
        while (i < words) {
            if (startchar[i] == '\n') {
                this.textlineEnd[line] = wordstart[i - 1] + wordlen[i - 1];
                this.viewTextLength[line] = this.textlineEnd[line] - this.viewTextOffset[line];
                this.viewTextOffset[++line] = wordstart[i];
            }
            ++i;
        }
        this.textlineEnd[line] = this.textBuffer[this.textBuffer.length - 1] == '\n' ? this.textBuffer.length - 1 : this.textBuffer.length;
        this.viewTextLength[line] = this.textlineEnd[line] - this.viewTextOffset[line];
    }

    public void setScreenPosition(int x, int y, int[] pointdata) {
        if (this.viewport.width <= 0 || this.viewport.height <= 0 || this.textlineEnd.length <= 0) {
            return;
        }
        pointdata[1] = RudolphTextAreaPeer.getLines(y, this.painterMetrics) + this.lineOffset;
        if (pointdata[1] >= this.textlineEnd.length) {
            pointdata[1] = this.textlineEnd.length - 1;
        }
        x = RudolphTextAreaPeer.getTextPos(x);
        pointdata[3] = RudolphPeer.getChars(RudolphTextAreaPeer.getTextPos(x), this.viewTextOffset[pointdata[1]], this.textBuffer, this.painterMetrics);
        if (pointdata[3] > this.textlineEnd[pointdata[1]]) {
            pointdata[3] = this.textlineEnd[pointdata[1]];
        }
        if (pointdata[3] > this.textlineEnd[pointdata[1]]) {
            pointdata[3] = this.textlineEnd[pointdata[1]];
        }
        pointdata[2] = this.painterMetrics.charsWidth(this.textBuffer, this.viewTextOffset[pointdata[1]], pointdata[3] - this.viewTextOffset[pointdata[1]]);
        pointdata[0] = pointdata[3];
    }

    public void setScreenPosition(int pos, int[] pointdata) {
        if (this.viewport.width <= 0 || this.viewport.height <= 0 || this.textlineEnd.length <= 0) {
            return;
        }
        if (pos < 0) {
            pointdata[0] = 0;
            pointdata[1] = 0;
            pointdata[2] = 0;
            pointdata[3] = 0;
        } else if (pos >= this.textBuffer.length) {
            pointdata[0] = this.textBuffer.length;
            pointdata[1] = this.textlineEnd.length - 1;
            pointdata[2] = this.painterMetrics.charsWidth(this.textBuffer, this.viewTextOffset[pointdata[1]], this.viewTextLength[pointdata[1]]);
            pointdata[3] = this.textBuffer.length;
        } else {
            pointdata[0] = pos;
            pointdata[1] = 0;
            while (pos > this.viewTextOffset[pointdata[1]] + this.viewTextLength[pointdata[1]]) {
                pointdata[1] = pointdata[1] + 1;
            }
            pointdata[2] = this.painterMetrics.charsWidth(this.textBuffer, this.viewTextOffset[pointdata[1]], pos - this.viewTextOffset[pointdata[1]]);
            pointdata[3] = pos;
        }
    }

    public void setScreenPositionLine(int line, int offset, int[] pointdata) {
        if (line < 0) {
            pointdata[0] = 0;
            pointdata[1] = 0;
            pointdata[2] = 0;
            pointdata[3] = 0;
        } else if (line >= this.textlineEnd.length) {
            pointdata[0] = this.textBuffer.length;
            pointdata[1] = this.textlineEnd.length - 1;
            pointdata[2] = pointdata[1] > 0 ? this.painterMetrics.charsWidth(this.textBuffer, this.textlineEnd[pointdata[1] - 1] + 1, this.viewTextLength[pointdata[1]]) : this.painterMetrics.charsWidth(this.textBuffer, 0, this.textBuffer.length);
            pointdata[3] = pointdata[0];
        } else if (offset < 0) {
            pointdata[0] = this.textlineEnd[line];
            pointdata[1] = line;
            pointdata[2] = line > 0 ? this.painterMetrics.charsWidth(this.textBuffer, this.textlineEnd[line - 1] + 1, this.viewTextLength[line]) : this.painterMetrics.charsWidth(this.textBuffer, 0, this.textlineEnd[line]);
            pointdata[3] = pointdata[0];
        } else if (offset == 0) {
            int n = 0;
            if (line > 0) {
                n = this.textlineEnd[line - 1] + 1;
            }
            pointdata[0] = n;
            pointdata[1] = line;
            pointdata[2] = 0;
            pointdata[3] = pointdata[0];
        } else {
            pointdata[1] = line;
            int n = pointdata[0] = line > 0 ? RudolphPeer.getChars(offset, this.textlineEnd[line - 1] + 1, this.textBuffer, this.painterMetrics) : RudolphPeer.getChars(offset, 0, this.textBuffer, this.painterMetrics);
            if (pointdata[0] > this.textlineEnd[line]) {
                pointdata[0] = this.textlineEnd[line];
                pointdata[2] = line > 0 ? this.painterMetrics.charsWidth(this.textBuffer, this.textlineEnd[line - 1] + 1, this.viewTextLength[line]) : this.painterMetrics.charsWidth(this.textBuffer, 0, this.textlineEnd[line]);
            } else {
                pointdata[2] = offset;
            }
            pointdata[3] = pointdata[0];
        }
    }

    public void paint(int width, int height, int cursorline, int cursoroffset, int cursorscreenpos, Graphics g) {
        RudolphTextAreaPeer.paintTextArea(0, 0, width, height, this.textBuffer, this.viewTextOffset, this.viewTextLength, this.lineOffset, cursorline, cursorscreenpos, this.painterFont, this.painterMetrics, this.textColors, g, this.drawCursor);
    }

    public void paint(int width, int height, int startline, int startbufferoffset, int starthorizontaloffset, int stopline, int stopbufferoffset, int stophorizontaloffset, Graphics g) {
        RudolphTextAreaPeer.paintTextArea(0, 0, width, height, this.textBuffer, this.viewTextOffset, this.viewTextLength, this.lineOffset, startline, startbufferoffset, starthorizontaloffset, stopline, stopbufferoffset, stophorizontaloffset, this.painterFont, this.painterMetrics, this.textColors, g, this.drawCursor);
    }

    public TextAreaPainter_WrappingVarFont(Font textfont, FontMetrics metrics, String text, Dimension size, Color[] colors) {
        super(textfont, metrics, text, size, colors);
    }
}

