/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.RudolphTextAreaPeer;
import com.acunia.wonka.rudolph.peers.TextAreaPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;

public class TextAreaPainter_ScrollingFixFont
extends TextAreaPainter {
    protected int maximumTextWidth;
    protected int painterCharWidth;
    protected int textOffset;

    public void setImage(String text) {
        super.setImage(text);
        this.calculateMaximumWidth();
    }

    public int getMaxAdvance() {
        return 1;
    }

    public void setSize(Dimension newsize) {
        this.viewport.width = RudolphTextAreaPeer.getInnerwidth(newsize.width) / this.painterCharWidth;
        this.viewport.height = RudolphTextAreaPeer.getLines(newsize.height, this.painterMetrics);
        this.calculateVisibleLineparts();
    }

    public int getMaximumWidth() {
        return this.maximumTextWidth;
    }

    public void setTextOffset(int offset) {
        this.textOffset = offset;
        this.calculateVisibleLineparts();
    }

    public void setOffset(int offsetx, int offsety) {
        this.textOffset = offsetx;
        this.lineOffset = offsety;
        this.calculateVisibleLineparts();
    }

    public int getTextOffset() {
        return this.textOffset;
    }

    public Point getOffset() {
        return new Point(this.textOffset, this.lineOffset);
    }

    protected void calculateMaximumWidth() {
        int start;
        this.maximumTextWidth = start = this.textlineEnd[0];
        int i = 1;
        while (i < this.textlineEnd.length) {
            if (this.textlineEnd[i] - start > this.maximumTextWidth) {
                this.maximumTextWidth = this.textlineEnd[i] - start;
            }
            start = this.textlineEnd[i];
            ++i;
        }
    }

    protected void calculateVisibleLineparts() {
        if (this.textBuffer.length <= 0 || this.viewport.width <= 0) {
            return;
        }
        int start = 0;
        int i = 0;
        while (i < this.textlineEnd.length) {
            if (start + this.textOffset >= this.textlineEnd[i]) {
                this.viewTextOffset[i] = this.textlineEnd[i];
                this.viewTextLength[i] = 0;
            } else {
                this.viewTextOffset[i] = start + this.textOffset;
                this.viewTextLength[i] = this.textlineEnd[i] - this.viewTextOffset[i] > this.viewport.width ? this.viewport.width : this.textlineEnd[i] - this.viewTextOffset[i];
            }
            start = this.textlineEnd[i];
            ++i;
        }
    }

    public void setScreenPosition(int x, int y, int[] pointdata) {
        if (this.viewport.width <= 0 || this.viewport.height <= 0 || this.textlineEnd.length <= 0) {
            return;
        }
        pointdata[1] = RudolphTextAreaPeer.getLine(y, this.painterMetrics) + this.lineOffset;
        if (pointdata[1] >= this.textlineEnd.length) {
            pointdata[1] = this.textlineEnd.length - 1;
        }
        pointdata[3] = RudolphTextAreaPeer.getTextPos(x) / this.painterCharWidth + this.viewTextOffset[pointdata[1]];
        if (pointdata[3] > this.textlineEnd[pointdata[1]]) {
            pointdata[3] = this.textlineEnd[pointdata[1]];
        }
        pointdata[2] = pointdata[1] > 0 ? pointdata[3] - this.textlineEnd[pointdata[1] - 1] : pointdata[3];
        pointdata[0] = pointdata[3] + pointdata[1];
    }

    public void setScreenPosition(int pos, int[] pointdata) {
        if (this.viewport.width <= 0 || this.viewport.height <= 0 || this.textlineEnd.length <= 0) {
            return;
        }
        if (pos < 0) {
            pointdata[0] = 0;
            pointdata[1] = 0;
            pointdata[3] = 0;
            pointdata[2] = 0;
        } else if (pos >= this.textBuffer.length + this.textlineEnd.length - 1) {
            pointdata[0] = this.textBuffer.length + this.textlineEnd.length;
            pointdata[1] = this.textlineEnd.length - 1;
            pointdata[3] = this.textBuffer.length;
            pointdata[2] = this.viewTextLength[this.textlineEnd.length - 1];
        } else {
            pointdata[0] = pos;
            pointdata[1] = 0;
            while (pos > this.textlineEnd[pointdata[1]]) {
                pointdata[1] = pointdata[1] + 1;
                --pos;
            }
            pointdata[3] = pos;
            pointdata[2] = pointdata[1] > 0 ? pos - this.textlineEnd[pointdata[1] - 1] : pos;
        }
    }

    public void setScreenPositionLine(int line, int offset, int[] pointdata) {
        if (line < 0) {
            pointdata[0] = 0;
            pointdata[1] = 0;
            pointdata[2] = 0;
            pointdata[3] = 0;
        } else if (line >= this.textlineEnd.length) {
            pointdata[1] = this.textlineEnd.length - 1;
            pointdata[2] = pointdata[1] > 0 ? this.textlineEnd[pointdata[1]] - this.textlineEnd[pointdata[1] - 1] : this.textlineEnd[pointdata[1]];
            pointdata[3] = this.textBuffer.length;
            pointdata[0] = pointdata[3] + pointdata[1];
        } else if (offset < 0) {
            pointdata[3] = this.textlineEnd[line];
            pointdata[2] = line > 0 ? this.textlineEnd[line] - this.textlineEnd[line - 1] : this.textlineEnd[line];
            pointdata[1] = line;
            pointdata[0] = pointdata[3] + line;
        } else {
            pointdata[1] = line;
            int n = pointdata[3] = line > 0 ? this.textlineEnd[line - 1] + offset : offset;
            if (pointdata[3] > this.textlineEnd[line]) {
                pointdata[2] = line > 0 ? this.textlineEnd[line] - this.textlineEnd[line - 1] : this.textlineEnd[line];
                pointdata[3] = this.textlineEnd[line];
            } else {
                pointdata[2] = offset;
            }
            pointdata[0] = pointdata[3] + line;
        }
    }

    public void paint(int width, int height, int cursorline, int cursoroffset, int cursorscreenpos, Graphics g) {
        RudolphTextAreaPeer.paintTextArea(0, 0, width, height, this.textBuffer, this.viewTextOffset, this.viewTextLength, this.lineOffset, cursorline, (cursorscreenpos - this.textOffset) * this.painterCharWidth, this.painterFont, this.painterMetrics, this.textColors, g, this.drawCursor);
    }

    public void paint(int width, int height, int startline, int startbufferoffset, int starthorizontaloffset, int stopline, int stopbufferoffset, int stophorizontaloffset, Graphics g) {
        RudolphTextAreaPeer.paintTextArea(0, 0, width, height, this.textBuffer, this.viewTextOffset, this.viewTextLength, this.lineOffset, startline, startbufferoffset, (starthorizontaloffset - this.textOffset) * this.painterCharWidth, stopline, stopbufferoffset, (stophorizontaloffset - this.textOffset) * this.painterCharWidth, this.painterFont, this.painterMetrics, this.textColors, g, this.drawCursor);
    }

    public TextAreaPainter_ScrollingFixFont(Font textfont, FontMetrics metrics, int fixedwidth, String text, Dimension size, Color[] colors) {
        super(metrics, size, colors);
        this.painterFont = textfont;
        this.painterMetrics = metrics;
        this.painterCharWidth = fixedwidth;
        this.viewport.width /= fixedwidth;
        this.setImage(text);
        this.textOffset = 0;
        this.calculateVisibleLineparts();
    }
}

