/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.RudolphPeer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class RudolphTextAreaPeer
extends RudolphPeer {
    public static final Font DEFAULT_FONT = new Font("courP14", 0, 14);
    public static final int DEFAULTTEXTCHARS = 20;
    public static final int DEFAULTTEXTLINES = 5;
    public static final int BORDER = 16;

    public static void paintTextArea(int x0, int y0, int width, int height, char[] text, int[] starts, int[] lengths, int lineoffset, int cursorline, int cursoroffset, Font f, FontMetrics fm, Color[] peercolors, Graphics g, boolean drawCursor) {
        g.setColor(peercolors[3]);
        g.drawLine(x0 + 1, y0 + 1, x0 + width - 2, y0 + 1);
        g.drawLine(x0 + 1, y0 + 1, x0 + 1, y0 + height - 2);
        g.setColor(peercolors[2]);
        g.drawLine(x0 + width - 2, y0 + 1, x0 + width - 2, y0 + height - 2);
        g.drawLine(x0 + 1, y0 + height - 2, x0 + width - 2, y0 + height - 2);
        int lineheight = fm.getHeight();
        int xt = x0 + 5;
        int yt = y0 + 2 + lineheight - fm.getDescent();
        int lastline = (height - 3) / lineheight + lineoffset;
        if (lastline >= starts.length) {
            lastline = starts.length;
        }
        g.setFont(f);
        g.setColor(peercolors[4]);
        int i = lineoffset;
        while (i < lastline) {
            g.drawChars(text, starts[i], lengths[i], xt, yt);
            yt += lineheight;
            ++i;
        }
        if (drawCursor && cursorline >= lineoffset && cursorline < lastline && cursoroffset >= 0 && cursoroffset < width - 4) {
            yt = y0 + 2 + (cursorline - lineoffset) * lineheight;
            xt = x0 + 5 + cursoroffset;
            g.setColor(peercolors[3]);
            g.drawLine(xt, yt, xt, yt + lineheight);
            g.drawLine(xt - 2, yt, xt + 2, yt);
            g.drawLine(xt - 2, yt + lineheight, xt + 2, yt + lineheight);
        }
    }

    public static void paintTextArea(int x0, int y0, int width, int height, char[] text, int[] starts, int[] lengths, int lineoffset, int startline, int startchar, int startoffset, int stopline, int stopchar, int stopoffset, Font f, FontMetrics fm, Color[] peercolors, Graphics g, boolean drawCursor) {
        g.setColor(peercolors[3]);
        g.drawLine(x0 + 1, y0 + 1, x0 + width - 2, y0 + 1);
        g.drawLine(x0 + 1, y0 + 1, x0 + 1, y0 + height - 2);
        g.setColor(peercolors[2]);
        g.drawLine(x0 + width - 2, y0 + 1, x0 + width - 2, y0 + height - 2);
        g.drawLine(x0 + 1, y0 + height - 2, x0 + width - 2, y0 + height - 2);
        width -= 7;
        int lineheight = fm.getHeight();
        int xt = x0 + 5;
        int yt = y0 + 2 + lineheight - fm.getDescent();
        int lastline = (height - 3) / lineheight + lineoffset;
        if (lastline >= starts.length) {
            lastline = starts.length;
        }
        int xs = x0 + 2;
        int ys = y0 + 2;
        int i = lineoffset;
        g.setFont(f);
        g.setColor(peercolors[4]);
        while (i < lastline && i < startline) {
            g.drawChars(text, starts[i], lengths[i], xt, yt);
            ys += lineheight;
            yt += lineheight;
            ++i;
        }
        if (startline == stopline && startline >= lineoffset && startline < lastline) {
            int temp;
            if (stopoffset < 0 || startoffset > width) {
                g.drawChars(text, starts[i], lengths[i], xt, yt);
            } else if (startoffset <= 0 && stopoffset > width) {
                g.setColor(peercolors[1]);
                g.fillRect(xt, ys, width - 3, lineheight);
                g.setColor(peercolors[2]);
                g.drawChars(text, starts[i], lengths[i], xt, yt);
            } else if (startoffset <= 0) {
                g.setColor(peercolors[1]);
                g.fillRect(xt, ys, stopoffset, lineheight);
                g.setColor(peercolors[2]);
                temp = stopchar - starts[i];
                if (temp > text.length - starts[i]) {
                    temp = text.length - starts[i];
                }
                g.drawChars(text, starts[i], temp, xt, yt);
                g.setColor(peercolors[4]);
                temp = starts[i] + lengths[i] - stopchar;
                if (temp > text.length - stopchar) {
                    temp = text.length - stopchar;
                }
                int n = 0;
                if (stopchar < text.length) {
                    n = stopchar;
                }
                int n2 = 0;
                if (stopchar < text.length) {
                    n2 = temp;
                }
                g.drawChars(text, n, n2, xt + stopoffset, yt);
            } else if (startoffset > 0 && stopoffset > width) {
                g.drawChars(text, starts[i], startchar - starts[i], xt, yt);
                g.setColor(peercolors[1]);
                g.fillRect(xt + startoffset, ys, width - startoffset - 2, lineheight);
                g.setColor(peercolors[2]);
                g.drawChars(text, startchar, starts[i] + lengths[i] - startchar, xt + startoffset, yt);
                g.setColor(peercolors[4]);
            } else {
                temp = startchar - starts[i];
                if (temp > text.length - starts[i]) {
                    temp = text.length - starts[i];
                }
                g.drawChars(text, starts[i], temp, xt, yt);
                g.setColor(peercolors[1]);
                g.fillRect(xt + startoffset, ys, stopoffset - startoffset, lineheight);
                g.setColor(peercolors[2]);
                temp = stopchar - startchar;
                if (temp > text.length - startchar) {
                    temp = text.length - startchar;
                }
                int n = 0;
                if (startchar < text.length) {
                    n = startchar;
                }
                int n3 = 0;
                if (startchar < text.length) {
                    n3 = temp;
                }
                g.drawChars(text, n, n3, xt + startoffset, yt);
                g.setColor(peercolors[4]);
                temp = starts[i] + lengths[i] - stopchar;
                if (temp > text.length - stopchar) {
                    temp = text.length - stopchar;
                }
                int n4 = 0;
                if (stopchar < text.length) {
                    n4 = stopchar;
                }
                int n5 = 0;
                if (stopchar < text.length) {
                    n5 = temp;
                }
                g.drawChars(text, n4, n5, xt + stopoffset, yt);
            }
            yt += lineheight;
            ++i;
        } else if (stopline >= lineoffset && startline < lastline) {
            if (startline >= lineoffset) {
                if (startoffset < 0) {
                    g.setColor(peercolors[1]);
                    g.fillRect(xt, ys, width, lineheight);
                    g.setColor(peercolors[2]);
                    g.drawChars(text, starts[i], lengths[i], xt, yt);
                } else if (startoffset > width) {
                    g.setColor(peercolors[4]);
                    g.drawChars(text, starts[i], lengths[i], xt, yt);
                } else {
                    g.setColor(peercolors[4]);
                    g.drawChars(text, starts[i], startchar - starts[i], xt, yt);
                    g.setColor(peercolors[1]);
                    g.fillRect(xt + startoffset, ys, width - startoffset, lineheight);
                    g.setColor(peercolors[2]);
                    if (startchar < text.length && lengths[i] + starts[i] < text.length && startchar <= lengths[i] + starts[i]) {
                        g.drawChars(text, startchar, lengths[i] + starts[i] - startchar, xt + startoffset, yt);
                    }
                }
                ys += lineheight;
                yt += lineheight;
                ++i;
            }
            while (i < stopline && i < lastline) {
                g.setColor(peercolors[1]);
                g.fillRect(xt, ys, width, lineheight);
                g.setColor(peercolors[2]);
                g.drawChars(text, starts[i], lengths[i], xt, yt);
                ys += lineheight;
                yt += lineheight;
                ++i;
            }
            if (i < lastline) {
                if (stopoffset < 0) {
                    g.setColor(peercolors[4]);
                    g.drawChars(text, starts[i], lengths[i], xt, yt);
                } else if (stopoffset > width) {
                    g.setColor(peercolors[1]);
                    g.fillRect(xt, ys, width, lineheight);
                    g.setColor(peercolors[2]);
                    g.drawChars(text, starts[i], lengths[i], xt, yt);
                    g.setColor(peercolors[4]);
                } else {
                    g.setColor(peercolors[1]);
                    g.fillRect(xt, ys, stopoffset, lineheight);
                    g.setColor(peercolors[2]);
                    g.drawChars(text, starts[i], stopchar - starts[i], xt, yt);
                    g.setColor(peercolors[4]);
                    if (stopchar < text.length && lengths[i] + starts[i] < text.length && stopchar <= lengths[i] + starts[i]) {
                        g.drawChars(text, stopchar, starts[i] + lengths[i] - stopchar, xt + stopoffset, yt);
                    }
                }
                yt += lineheight;
                ++i;
            }
        }
        while (i < lastline) {
            g.drawChars(text, starts[i], lengths[i], xt, yt);
            yt += lineheight;
            ++i;
        }
    }

    public static void paintTextAreaNoScroll(int x0, int y0, int width, int height, char[] text, int[] starts, int[] lengths, int lineoffset, int startline, int startchar, int startoffset, int stopline, int stopchar, int stopoffset, Font f, FontMetrics fm, Color[] peercolors, Graphics g) {
        g.setColor(peercolors[3]);
        g.drawLine(x0 + 1, y0 + 1, x0 + width - 2, y0 + 1);
        g.drawLine(x0 + 1, y0 + 1, x0 + 1, y0 + height - 2);
        g.setColor(peercolors[2]);
        g.drawLine(x0 + width - 2, y0 + 1, x0 + width - 2, y0 + height - 2);
        g.drawLine(x0 + 1, y0 + height - 2, x0 + width - 2, y0 + height - 2);
        int lineheight = fm.getHeight();
        int xt = x0 + 5;
        int yt = y0 + 2 + lineheight - fm.getDescent();
        int lastline = (height - 3) / lineheight + lineoffset;
        if (lastline >= starts.length) {
            lastline = starts.length;
        }
        int xs = x0 + 2;
        int ys = y0 + 2;
        int i = lineoffset;
        g.setFont(f);
        g.setColor(peercolors[4]);
        while (i < lastline && i < startline) {
            g.drawChars(text, starts[i], lengths[i], xt, yt);
            ys += lineheight;
            yt += lineheight;
            ++i;
        }
        if (startline == stopline && startline >= lineoffset && startline < lastline) {
            xs = xt + startoffset;
            g.drawChars(text, starts[i], startchar - starts[i], xt, yt);
            g.setColor(peercolors[1]);
            g.fillRect(xs, ys, stopoffset - startoffset, lineheight);
            g.setColor(peercolors[2]);
            g.drawChars(text, startchar, stopchar - startchar, xs, yt);
            g.setColor(peercolors[4]);
            g.drawChars(text, stopchar, starts[i] + lengths[i] - stopchar, xt + stopoffset, yt);
            yt += lineheight;
            ++i;
        } else if (stopline >= lineoffset && startline < lastline) {
            if (startline >= lineoffset) {
                xs = xt + startoffset;
                g.setColor(peercolors[4]);
                g.drawChars(text, starts[i], startchar - starts[i], xt, yt);
                g.setColor(peercolors[1]);
                g.fillRect(xs, ys, width - startoffset - 6, lineheight);
                g.setColor(peercolors[2]);
                g.drawChars(text, startchar, lengths[i] + starts[i] - startchar, xs, yt);
                ys += lineheight;
                yt += lineheight;
                ++i;
            }
            xs = width - 6;
            while (i < stopline && i < lastline) {
                g.setColor(peercolors[1]);
                g.fillRect(xt, ys, xs, lineheight);
                g.setColor(peercolors[2]);
                g.drawChars(text, starts[i], lengths[i], xt, yt);
                ys += lineheight;
                yt += lineheight;
                ++i;
            }
            if (i < lastline) {
                g.setColor(peercolors[1]);
                g.fillRect(xt, ys, stopoffset, lineheight);
                g.setColor(peercolors[2]);
                g.drawChars(text, starts[i], stopchar - starts[i], xt, yt);
                g.setColor(peercolors[4]);
                g.drawChars(text, stopchar, starts[i] + lengths[i] - stopchar, xt + stopoffset, yt);
                yt += lineheight;
                ++i;
            }
        }
        while (i < lastline) {
            g.drawChars(text, starts[i], lengths[i], xt, yt);
            yt += lineheight;
            ++i;
        }
    }

    public static int getLines(int height, FontMetrics fm) {
        int n = 0;
        if (fm.getHeight() > 0) {
            n = (height - 3) / fm.getHeight();
        }
        return n;
    }

    public static int getHeight(int lines, FontMetrics fm) {
        return lines * fm.getHeight() + 3;
    }

    public static int getLine(int height, FontMetrics fm) {
        int n = 0;
        if (fm.getHeight() > 0) {
            n = (height - 1) / fm.getHeight();
        }
        return n;
    }

    public static int getYPos(int lines, FontMetrics fm) {
        return lines * fm.getHeight() + 1;
    }

    public static int getInnerwidth(int screensize) {
        int n = 0;
        if (screensize > 6) {
            n = screensize - 6;
        }
        return n;
    }

    public static int getScreenSize(int innerwidth) {
        return innerwidth + 6;
    }

    public static int getTextPos(int x) {
        int n = 0;
        if (x > 5) {
            n = x - 5;
        }
        return n;
    }
}

