/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.rudolph.peers;

import com.acunia.wonka.rudolph.peers.DefaultTextComponent;
import com.acunia.wonka.rudolph.peers.RudolphPeer;
import com.acunia.wonka.rudolph.peers.RudolphScrollbarPeer;
import com.acunia.wonka.rudolph.peers.ScrollPainter;
import com.acunia.wonka.rudolph.peers.ScrollRunner;
import com.acunia.wonka.rudolph.peers.TextAreaPainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.peer.TextAreaPeer;

public class DefaultTextArea
extends DefaultTextComponent
implements TextAreaPeer,
MouseListener,
MouseMotionListener {
    private static final int TEXTSCROLL_STOP = -1;
    private static final int TEXTSCROLL_UP = 1;
    private static final int TEXTSCROLL_DOWN = 2;
    private static final int TEXTSCROLL_LEFT = 3;
    private static final int TEXTSCROLL_RIGHT = 4;
    private HAreaScrollPainter hScroll;
    private VAreaScrollPainter vScroll;
    private boolean vScrollVisible;
    private TextAreaPainter textPainter;
    private Color[] textAreaColors;
    private Dimension textScreen;
    private Dimension totalScreen;
    private Point lastMousePosition;
    static final ScrollRunner mouseEventThread = new ScrollRunner();
    private Image backgroundImage;
    private Graphics backgroundGraphics;
    private boolean repaintText;
    private boolean repaintHScroll;
    private boolean repaintVScroll;
    protected int cursorLine;
    protected int cursorBufferOffset;
    protected int cursorHorizontalOffset;
    protected int startLine;
    protected int startBufferOffset;
    protected int startHorizontalOffset;
    protected int stopLine;
    protected int stopBufferOffset;
    protected int stopHorizontalOffset;
    private boolean initialized = false;
    private int[] tempData;

    public DefaultTextArea(TextArea textArea) {
        super(textArea);
    }

    private synchronized void init() {
        this.initialized = true;
        this.position = 0;
        this.cursorLine = -1;
        this.cursorBufferOffset = -1;
        this.cursorHorizontalOffset = -1;
        this.selectionStart = 0;
        this.startLine = -1;
        this.startBufferOffset = -1;
        this.startHorizontalOffset = -1;
        this.selectionStop = 0;
        this.stopLine = -1;
        this.stopBufferOffset = -1;
        this.stopHorizontalOffset = -1;
        this.tempData = new int[4];
        this.textAreaColors = RudolphPeer.getBarColors();
        this.textScreen = new Dimension();
        this.totalScreen = new Dimension();
        this.vScroll = new VAreaScrollPainter();
        int scrollbarVis = ((TextArea)this.component).getScrollbarVisibility();
        if (scrollbarVis == 3) {
            this.hScroll = null;
            this.vScrollVisible = false;
            this.textPainter = TextAreaPainter.getNewPainter(((TextArea)this.component).getFont(), this.text, this.textAreaColors, this.textScreen, false);
        } else if (scrollbarVis == 2) {
            this.hScroll = new HAreaScrollPainter();
            this.hScroll.setBarColors(this.textAreaColors);
            this.vScrollVisible = false;
            this.textPainter = TextAreaPainter.getNewPainter(((TextArea)this.component).getFont(), this.text, this.textAreaColors, this.textScreen, true);
            this.hScroll.setLineStep(this.textPainter.getMaxAdvance());
        } else if (scrollbarVis == 1) {
            this.hScroll = null;
            this.vScrollVisible = true;
            this.vScroll.setBarColors(this.textAreaColors);
            this.textPainter = TextAreaPainter.getNewPainter(((TextArea)this.component).getFont(), this.text, this.textAreaColors, this.textScreen, false);
        } else {
            this.hScroll = new HAreaScrollPainter();
            this.hScroll.setBarColors(this.textAreaColors);
            this.vScrollVisible = true;
            this.vScroll.setBarColors(this.textAreaColors);
            this.textPainter = TextAreaPainter.getNewPainter(((TextArea)this.component).getFont(), this.text, this.textAreaColors, this.textScreen, true);
            this.hScroll.setLineStep(this.textPainter.getMaxAdvance());
        }
        ((TextArea)this.component).addMouseListener(this);
        ((TextArea)this.component).addMouseMotionListener(this);
        this.lastMousePosition = new Point(0, 0);
        this.backgroundImage = null;
        this.backgroundGraphics = null;
        this.repaintText = false;
        this.repaintHScroll = false;
        this.repaintVScroll = false;
    }

    public Dimension getMinimumSize(int rows, int cols) {
        if (!this.initialized) {
            this.init();
        }
        return this.getPreferredSize(rows, cols);
    }

    public Dimension getPreferredSize(int rows, int cols) {
        if (!this.initialized) {
            this.init();
        }
        Dimension size = this.textPainter.getScreenSize(cols, rows);
        if (this.hScroll != null) {
            size.height += 16;
        }
        if (this.vScrollVisible) {
            size.width += 16;
        }
        return size;
    }

    public synchronized void insert(String newtext, int pos) {
        if (!this.initialized) {
            this.init();
        }
        if (this.updatePosition(pos)) {
            this.selectionStart = this.position;
            this.selectionStop = this.position;
            this.text = new String(new StringBuffer(this.text).insert(pos, newtext));
            this.textPainter.setImage(this.text);
            if (this.hScroll != null) {
                this.hScroll.setBarRange(this.textPainter.getMaximumWidth());
            }
            this.vScroll.setBarRange(this.textPainter.getMaximumLines());
            this.fireTextEvent();
            this.repaintText = true;
            this.repaintHScroll = true;
            this.repaintVScroll = true;
            this.paint(this.getGraphics());
        }
    }

    public synchronized void replaceRange(String newtext, int start, int stop) {
        if (!this.initialized) {
            this.init();
        }
        if (start > stop) {
            return;
        }
        if (start < 0 || start > this.text.length() || stop < 0 || stop > this.text.length()) {
            return;
        }
        this.text = new String(new StringBuffer(this.text).replace(start, stop, newtext));
        this.textPainter.setImage(this.text);
        if (this.hScroll != null) {
            this.hScroll.setBarRange(this.textPainter.getMaximumWidth());
        }
        this.vScroll.setBarRange(this.textPainter.getMaximumLines());
        this.updatePosition(start + newtext.length());
        this.selectionStart = this.position;
        this.selectionStop = this.position;
        this.fireTextEvent();
        this.repaintText = true;
        this.repaintHScroll = true;
        this.repaintVScroll = true;
        this.paint(this.getGraphics());
    }

    public void insertText(String text, int pos) {
    }

    public Dimension minimumSize(int rows, int cols) {
        return null;
    }

    public Dimension preferredSize(int rows, int cols) {
        return null;
    }

    public void replaceText(String str, int start, int end) {
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
        boolean imagechanged = false;
        switch (evt.getKeyCode()) {
            case 37: {
                if (evt.isShiftDown()) {
                    this.textPainter.setScreenPosition(this.position - 1, this.tempData);
                    imagechanged = this.setNewSelection(this.tempData);
                    break;
                }
                imagechanged = this.updatePosition(this.position - 1);
                this.selectionStart = this.position;
                this.selectionStop = this.position;
                break;
            }
            case 39: {
                if (evt.isShiftDown()) {
                    this.textPainter.setScreenPosition(this.position + 1, this.tempData);
                    imagechanged = this.setNewSelection(this.tempData);
                    break;
                }
                imagechanged = this.updatePosition(this.position + 1);
                this.selectionStart = this.position;
                this.selectionStop = this.position;
                break;
            }
            case 36: {
                if (evt.isShiftDown()) {
                    this.textPainter.setScreenPositionLine(this.cursorLine, 0, this.tempData);
                    imagechanged = this.setNewSelection(this.tempData);
                    break;
                }
                this.textPainter.setScreenPositionLine(this.cursorLine, 0, this.tempData);
                imagechanged = this.updateCursor(this.tempData);
                break;
            }
            case 35: {
                if (evt.isShiftDown()) {
                    this.textPainter.setScreenPositionLine(this.cursorLine, -1, this.tempData);
                    imagechanged = this.setNewSelection(this.tempData);
                    break;
                }
                this.textPainter.setScreenPositionLine(this.cursorLine, -1, this.tempData);
                imagechanged = this.updateCursor(this.tempData);
                break;
            }
            case 38: {
                if (evt.isShiftDown()) {
                    this.textPainter.setScreenPositionLine(this.cursorLine - 1, this.cursorHorizontalOffset, this.tempData);
                    imagechanged = this.setNewSelection(this.tempData);
                    break;
                }
                this.textPainter.setScreenPositionLine(this.cursorLine - 1, this.cursorHorizontalOffset, this.tempData);
                imagechanged = this.updateCursor(this.tempData);
                break;
            }
            case 40: {
                if (evt.isShiftDown()) {
                    this.textPainter.setScreenPositionLine(this.cursorLine + 1, this.cursorHorizontalOffset, this.tempData);
                    imagechanged = this.setNewSelection(this.tempData);
                    break;
                }
                this.textPainter.setScreenPositionLine(this.cursorLine + 1, this.cursorHorizontalOffset, this.tempData);
                imagechanged = this.updateCursor(this.tempData);
                break;
            }
            case 33: {
                if (evt.isShiftDown()) {
                    this.textPainter.setScreenPositionLine(this.cursorLine - this.textPainter.getViewportLines(), this.cursorHorizontalOffset, this.tempData);
                    imagechanged = this.setNewSelection(this.tempData);
                    break;
                }
                this.textPainter.setScreenPositionLine(this.cursorLine - this.textPainter.getViewportLines(), this.cursorHorizontalOffset, this.tempData);
                imagechanged = this.updateCursor(this.tempData);
                break;
            }
            case 34: {
                if (evt.isShiftDown()) {
                    this.textPainter.setScreenPositionLine(this.cursorLine + this.textPainter.getViewportLines(), this.cursorHorizontalOffset, this.tempData);
                    imagechanged = this.setNewSelection(this.tempData);
                    break;
                }
                this.textPainter.setScreenPositionLine(this.cursorLine + this.textPainter.getViewportLines(), this.cursorHorizontalOffset, this.tempData);
                imagechanged = this.updateCursor(this.tempData);
                break;
            }
            case 8: {
                if (this.selectionStart < this.selectionStop) {
                    this.text = new String(new StringBuffer(this.text).delete(this.selectionStart, this.selectionStop));
                    this.textPainter.setImage(this.text);
                    this.updatePosition(this.selectionStart);
                    this.selectionStart = this.position;
                    this.selectionStop = this.position;
                    imagechanged = true;
                    this.fireTextEvent();
                    break;
                }
                if (this.position <= 1 || this.position > this.text.length()) break;
                this.text = new String(new StringBuffer(this.text).deleteCharAt(this.position - 1));
                this.textPainter.setImage(this.text);
                this.updatePosition(this.position - 1);
                this.selectionStart = this.position;
                this.selectionStop = this.position;
                imagechanged = true;
                this.fireTextEvent();
                break;
            }
            case 127: {
                if (this.selectionStart < this.selectionStop) {
                    this.text = new String(new StringBuffer(this.text).delete(this.selectionStart, this.selectionStop));
                    this.textPainter.setImage(this.text);
                    this.updatePosition(this.selectionStart);
                    this.selectionStart = this.position;
                    this.selectionStop = this.position;
                    imagechanged = true;
                    this.fireTextEvent();
                    break;
                }
                if (this.position <= 0 || this.position >= this.text.length()) break;
                this.text = new String(new StringBuffer(this.text).deleteCharAt(this.position));
                this.textPainter.setImage(this.text);
                this.updatePosition(this.position);
                this.selectionStart = this.position;
                this.selectionStop = this.position;
                imagechanged = true;
                this.fireTextEvent();
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 10: {
                if (this.selectionStart < this.selectionStop) {
                    StringBuffer buf = new StringBuffer(this.text);
                    buf.delete(this.selectionStart, this.selectionStop);
                    buf.insert(this.selectionStart, '\n');
                    this.text = new String(buf);
                    this.textPainter.setImage(this.text);
                    this.updatePosition(this.selectionStart + 1);
                    this.selectionStart = this.position;
                    this.selectionStop = this.position;
                    imagechanged = true;
                    this.fireTextEvent();
                    break;
                }
                if (this.position < 0 || this.position > this.text.length()) break;
                this.text = new String(new StringBuffer(this.text).insert(this.position, '\n'));
                this.textPainter.setImage(this.text);
                this.updatePosition(this.position + 1);
                this.selectionStart = this.position;
                this.selectionStop = this.position;
                imagechanged = true;
                this.fireTextEvent();
                break;
            }
            default: {
                if (this.selectionStart < this.selectionStop) {
                    StringBuffer buf = new StringBuffer(this.text);
                    buf.delete(this.selectionStart, this.selectionStop);
                    buf.insert(this.selectionStart, evt.getKeyChar());
                    this.text = new String(buf);
                    this.textPainter.setImage(this.text);
                    this.updatePosition(this.selectionStart + 1);
                    this.selectionStart = this.position;
                    this.selectionStop = this.position;
                    imagechanged = true;
                    this.fireTextEvent();
                    break;
                }
                if (this.position < 0 || this.position > this.text.length()) break;
                this.text = new String(new StringBuffer(this.text).insert(this.position, evt.getKeyChar()));
                this.textPainter.setImage(this.text);
                this.updatePosition(this.position + 1);
                this.selectionStart = this.position;
                this.selectionStop = this.position;
                imagechanged = true;
                this.fireTextEvent();
            }
        }
        if (imagechanged) {
            this.repaintVScroll = this.adjustVerticalViewport(this.cursorLine);
            if (this.hScroll != null) {
                this.repaintHScroll = this.adjustHorizontalViewport(this.cursorHorizontalOffset);
            }
            this.repaintText = true;
            this.paint(this.getGraphics());
        }
    }

    public void setBackground(Color c) {
        if (!this.initialized) {
            this.init();
        }
        this.textAreaColors = RudolphPeer.getBarColors(c, this.component.getForeground());
        if (this.hScroll != null) {
            this.hScroll.setBarColors(this.textAreaColors);
        }
        this.vScroll.setBarColors(this.textAreaColors);
        this.textPainter.setTextColors(this.textAreaColors);
        this.repaintText = true;
        this.repaintHScroll = true;
        this.repaintVScroll = true;
        if (this.component.isVisible()) {
            this.paint(this.getGraphics());
        }
        super.setBackground(c);
    }

    public void setForeground(Color c) {
        this.textAreaColors[4] = c;
        if (this.hScroll != null) {
            this.hScroll.setBarColors(this.textAreaColors);
        }
        this.vScroll.setBarColors(this.textAreaColors);
        this.textPainter.setTextColors(this.textAreaColors);
        this.repaintText = true;
        this.repaintHScroll = true;
        this.repaintVScroll = true;
        this.paint(this.getGraphics());
        super.setForeground(c);
    }

    public void setFont(Font f) {
        if (!this.initialized) {
            this.init();
        }
        this.textPainter = TextAreaPainter.getNewPainter(f, this.text, this.textAreaColors, this.textScreen, this.hScroll != null);
        if (this.hScroll != null) {
            this.hScroll.setLineStep(this.textPainter.getMaxAdvance());
            this.hScroll.setScreenWidth(this.textScreen.width, this.textPainter.getViewportWidth(), this.textPainter.getMaximumWidth());
            this.textPainter.setTextOffset(this.hScroll.getBarPos());
        }
        this.vScroll.setScreenHeight(this.textScreen.height, this.textPainter.getViewportLines(), this.textPainter.getMaximumLines());
        this.textPainter.setLineOffset(this.vScroll.getBarPos());
        this.updatePosition(this.position);
        this.updateStart(this.selectionStart);
        this.updateStop(this.selectionStop);
        this.repaintText = true;
        this.repaintHScroll = true;
        this.repaintVScroll = true;
        this.paint(this.getGraphics());
        super.setFont(f);
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        this.textPainter.setCursor(((TextArea)this.component).isEditable());
        if (this.component.getSize().width <= 0 || this.component.getSize().height <= 0) {
            return;
        }
        if (this.backgroundImage == null || !this.totalScreen.equals(this.component.getSize())) {
            this.setFields(this.component.getSize());
            this.backgroundImage = this.createImage(this.totalScreen.width, this.totalScreen.height);
            if (this.backgroundImage != null && this.backgroundGraphics != null) {
                this.backgroundGraphics.dispose();
            }
            this.backgroundGraphics = this.backgroundImage.getGraphics();
            this.repaintText = true;
            this.repaintHScroll = true;
            this.repaintVScroll = true;
            super.paint(g);
        }
        Color back = this.component.getBackground();
        Color fore = this.component.getForeground();
        boolean setcolors = false;
        if (fore != null && !fore.equals(this.textAreaColors[4])) {
            this.textAreaColors[4] = fore;
            setcolors = true;
        }
        if (back != null && !back.equals(this.textAreaColors[0])) {
            this.textAreaColors = RudolphPeer.getBarColors(back, this.textAreaColors[4]);
            setcolors = true;
        }
        if (setcolors) {
            if (this.hScroll != null) {
                this.hScroll.setBarColors(this.textAreaColors);
            }
            this.vScroll.setBarColors(this.textAreaColors);
            this.textPainter.setTextColors(this.textAreaColors);
        }
        if (this.repaintText && this.textScreen.width > 2 && this.textScreen.height > 2) {
            this.backgroundGraphics.setColor(this.textAreaColors[0]);
            this.backgroundGraphics.fillRect(1, 1, this.textScreen.width - 2, this.textScreen.height - 2);
            if (this.selectionStart == this.selectionStop) {
                this.textPainter.paint(this.textScreen.width, this.textScreen.height, this.cursorLine, this.cursorBufferOffset, this.cursorHorizontalOffset, this.backgroundGraphics);
            } else {
                this.textPainter.paint(this.textScreen.width, this.textScreen.height, this.startLine, this.startBufferOffset, this.startHorizontalOffset, this.stopLine, this.stopBufferOffset, this.stopHorizontalOffset, this.backgroundGraphics);
            }
            this.repaintText = false;
        }
        if (this.hScroll != null && this.repaintHScroll) {
            this.hScroll.paint(this.backgroundGraphics);
            this.repaintHScroll = false;
        }
        if (this.vScrollVisible && this.repaintVScroll) {
            this.vScroll.paint(this.backgroundGraphics);
            this.repaintVScroll = false;
        }
        g.drawImage(this.backgroundImage, 0, 0, this.component);
    }

    private boolean setNewSelection(int[] newposition) {
        if (!this.initialized) {
            this.init();
        }
        if (newposition[0] == this.position) {
            return false;
        }
        if (this.selectionStart == this.selectionStop && newposition[0] < this.position) {
            this.selectionStart = newposition[0];
            this.startLine = newposition[1];
            this.startHorizontalOffset = newposition[2];
            this.startBufferOffset = newposition[3];
            this.selectionStop = this.position;
            this.stopLine = this.cursorLine;
            this.stopHorizontalOffset = this.cursorHorizontalOffset;
            this.stopBufferOffset = this.cursorBufferOffset;
        } else if (this.selectionStart == this.selectionStop && newposition[0] > this.position) {
            this.selectionStart = this.position;
            this.startLine = this.cursorLine;
            this.startHorizontalOffset = this.cursorHorizontalOffset;
            this.startBufferOffset = this.cursorBufferOffset;
            this.selectionStop = newposition[0];
            this.stopLine = newposition[1];
            this.stopHorizontalOffset = newposition[2];
            this.stopBufferOffset = newposition[3];
        } else if (this.position == this.selectionStart && newposition[0] > this.selectionStop) {
            this.selectionStart = this.selectionStop;
            this.startLine = this.stopLine;
            this.startHorizontalOffset = this.stopHorizontalOffset;
            this.startBufferOffset = this.stopBufferOffset;
            this.selectionStop = newposition[0];
            this.stopLine = newposition[1];
            this.stopHorizontalOffset = newposition[2];
            this.stopBufferOffset = newposition[3];
        } else if (this.position == this.selectionStart && newposition[0] == this.selectionStop) {
            this.selectionStart = newposition[0];
        } else if (this.position == this.selectionStart) {
            this.selectionStart = newposition[0];
            this.startLine = newposition[1];
            this.startHorizontalOffset = newposition[2];
            this.startBufferOffset = newposition[3];
        } else if (newposition[0] < this.selectionStart) {
            this.selectionStop = this.selectionStart;
            this.stopLine = this.startLine;
            this.stopHorizontalOffset = this.startHorizontalOffset;
            this.stopBufferOffset = this.startBufferOffset;
            this.selectionStart = newposition[0];
            this.startLine = newposition[1];
            this.startHorizontalOffset = newposition[2];
            this.startBufferOffset = newposition[3];
        } else if (newposition[0] == this.selectionStart) {
            this.selectionStop = newposition[0];
        } else {
            this.selectionStop = newposition[0];
            this.stopLine = newposition[1];
            this.stopHorizontalOffset = newposition[2];
            this.stopBufferOffset = newposition[3];
        }
        this.position = newposition[0];
        this.cursorLine = newposition[1];
        this.cursorHorizontalOffset = newposition[2];
        this.cursorBufferOffset = newposition[3];
        return true;
    }

    public void repaint(ScrollPainter alignation) {
        if (alignation == this.vScroll) {
            this.textPainter.setLineOffset(this.vScroll.getBarPos());
            this.repaintVScroll = true;
        } else {
            this.textPainter.setTextOffset(this.hScroll.getBarPos());
            this.repaintHScroll = true;
        }
        this.repaintText = true;
        this.paint(this.getGraphics());
    }

    private boolean adjustHorizontalViewport(int offset) {
        boolean viewportadjusted = false;
        if (offset < this.textPainter.getTextOffset()) {
            this.textPainter.setTextOffset(this.cursorHorizontalOffset);
            this.hScroll.setBarPos(this.cursorHorizontalOffset);
            viewportadjusted = true;
        } else {
            int topline = offset - this.textPainter.getViewportWidth() + 1;
            if (topline > this.textPainter.getTextOffset()) {
                this.textPainter.setTextOffset(topline);
                this.hScroll.setBarPos(topline);
                viewportadjusted = true;
            }
        }
        return viewportadjusted;
    }

    private boolean adjustVerticalViewport(int line) {
        boolean viewportadjusted = false;
        if (line < this.textPainter.getLineOffset()) {
            this.textPainter.setLineOffset(this.cursorLine);
            this.vScroll.setBarPos(this.cursorLine);
            viewportadjusted = true;
        } else {
            int topline = line - this.textPainter.getViewportLines() + 1;
            if (topline > this.textPainter.getLineOffset()) {
                this.textPainter.setLineOffset(topline);
                this.vScroll.setBarPos(topline);
                viewportadjusted = true;
            }
        }
        return viewportadjusted;
    }

    private boolean updatePosition(int newpos) {
        if (newpos < 0 || newpos > this.text.length()) {
            return false;
        }
        this.textPainter.setScreenPosition(newpos, this.tempData);
        this.position = this.tempData[0];
        this.cursorLine = this.tempData[1];
        this.cursorHorizontalOffset = this.tempData[2];
        this.cursorBufferOffset = this.tempData[3];
        super.setCaretPosition(newpos);
        return true;
    }

    private boolean updateStart(int newpos) {
        if (newpos < 0 || newpos > this.text.length()) {
            return false;
        }
        this.textPainter.setScreenPosition(newpos, this.tempData);
        this.selectionStart = this.tempData[0];
        this.startLine = this.tempData[1];
        this.startBufferOffset = this.tempData[2];
        this.startHorizontalOffset = this.tempData[3];
        return true;
    }

    private boolean updateStop(int newpos) {
        if (newpos < 0 || newpos > this.text.length()) {
            return false;
        }
        this.textPainter.setScreenPosition(newpos, this.tempData);
        this.selectionStop = this.tempData[0];
        this.stopLine = this.tempData[1];
        this.stopBufferOffset = this.tempData[2];
        this.stopHorizontalOffset = this.tempData[3];
        return true;
    }

    private boolean updateCursor(int[] newdata) {
        if (this.position == newdata[0]) {
            return false;
        }
        this.position = newdata[0];
        this.cursorLine = newdata[1];
        this.cursorHorizontalOffset = newdata[2];
        this.cursorBufferOffset = newdata[3];
        this.selectionStart = this.position;
        this.selectionStop = this.position;
        return true;
    }

    private void setFields(Dimension newsize) {
        this.totalScreen.setSize(newsize);
        this.textScreen.setSize(newsize);
        if (this.hScroll != null) {
            this.textScreen.height -= this.hScroll.getMinimumThickness();
            this.hScroll.setOffset(this.textScreen.height);
        }
        if (this.vScrollVisible) {
            this.textScreen.width -= this.vScroll.getMinimumThickness();
            this.vScroll.setOffset(this.textScreen.width);
        }
        this.textPainter.setSize(this.textScreen);
        if (this.hScroll != null) {
            this.hScroll.setScreenWidth(this.textScreen.width, this.textPainter.getViewportWidth(), this.textPainter.getMaximumWidth());
        }
        this.vScroll.setScreenHeight(this.textScreen.height, this.textPainter.getViewportLines(), this.textPainter.getMaximumLines());
        this.updatePosition(this.position);
        this.updateStart(this.selectionStart);
        this.updateStop(this.selectionStop);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < this.textScreen.width && y < this.textScreen.height) {
            this.lastMousePosition.setLocation(x, y);
            this.textPainter.setScreenPosition(x, y, this.tempData);
            if (this.updateCursor(this.tempData)) {
                this.repaintText = true;
                this.paint(this.getGraphics());
            }
        } else if (this.hScroll != null && y > this.textScreen.height) {
            int active = this.hScroll.setActive(x, y);
            if (active == 5) {
                this.lastMousePosition.setLocation(x, y);
                this.repaintHScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 2 && this.hScroll.lineUp()) {
                mouseEventThread.setRunner(this.hScroll, this.component);
                this.repaint(this.hScroll);
            } else if (active == 2) {
                this.repaintHScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 1 && this.hScroll.lineDn()) {
                mouseEventThread.setRunner(this.hScroll, this.component);
                this.repaint(this.hScroll);
            } else if (active == 1) {
                this.repaintHScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 3 && this.hScroll.pageUp()) {
                mouseEventThread.setRunner(this.hScroll, this.component);
                this.repaint(this.hScroll);
            } else if (active == 4 && this.hScroll.pageDn()) {
                mouseEventThread.setRunner(this.hScroll, this.component);
                this.repaint(this.hScroll);
            }
        } else if (this.vScrollVisible && x > this.textScreen.width) {
            int active = this.vScroll.setActive(x, y);
            if (active == 5) {
                this.lastMousePosition.setLocation(x, y);
                this.repaintVScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 2 && this.vScroll.lineUp()) {
                mouseEventThread.setRunner(this.vScroll, this.component);
                this.repaint(this.vScroll);
            } else if (active == 2) {
                this.repaintVScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 1 && this.vScroll.lineDn()) {
                mouseEventThread.setRunner(this.vScroll, this.component);
                this.repaint(this.vScroll);
            } else if (active == 1) {
                this.repaintVScroll = true;
                this.paint(this.getGraphics());
            } else if (active == 3 && this.vScroll.pageUp()) {
                mouseEventThread.setRunner(this.vScroll, this.component);
                this.repaint(this.vScroll);
            } else if (active == 4 && this.vScroll.pageDn()) {
                mouseEventThread.setRunner(this.vScroll, this.component);
                this.repaint(this.vScroll);
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.hScroll != null) {
            if (this.hScroll.isSelected()) {
                this.hScroll.setNoSelected();
                this.repaintHScroll = true;
            }
            mouseEventThread.stopRunner(this.hScroll);
        }
        if (this.vScrollVisible && this.vScroll.isSelected()) {
            this.vScroll.setNoSelected();
            this.repaintVScroll = true;
        }
        mouseEventThread.stopRunner(this.vScroll);
        if (this.repaintHScroll || this.repaintVScroll) {
            this.paint(this.getGraphics());
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.hScroll != null) {
            if (this.hScroll.isSelected()) {
                this.hScroll.setNoSelected();
                this.repaintHScroll = true;
            }
            mouseEventThread.stopRunner(this.hScroll);
        }
        if (this.vScrollVisible && this.vScroll.isSelected()) {
            this.vScroll.setNoSelected();
            this.repaintVScroll = true;
        }
        mouseEventThread.stopRunner(this.vScroll);
        if (this.repaintHScroll || this.repaintVScroll) {
            this.paint(this.getGraphics());
        }
    }

    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.hScroll != null && this.hScroll.getActive() == 5) {
            if (this.hScroll.moveBar(x - this.lastMousePosition.x)) {
                this.textPainter.setTextOffset(this.hScroll.getBarPos());
                this.lastMousePosition.setLocation(x, y);
                this.repaintText = true;
                this.repaintHScroll = true;
                this.paint(this.getGraphics());
            }
        } else if (this.vScrollVisible && this.vScroll.getActive() == 5) {
            if (this.vScroll.moveBar(y - this.lastMousePosition.y)) {
                this.textPainter.setLineOffset(this.vScroll.getBarPos());
                this.lastMousePosition.setLocation(x, y);
                this.repaintText = true;
                this.repaintVScroll = true;
                this.paint(this.getGraphics());
            }
        } else if (x < this.textScreen.width && y < this.textScreen.height) {
            if (this.hScroll != null) {
                if (y < 0 || y > this.textScreen.height) {
                    mouseEventThread.stopRunner(this.hScroll);
                } else if (x > 0 && x < this.textPainter.getBorder() && x < this.lastMousePosition.x && this.hScroll.lineUp()) {
                    mouseEventThread.setRunner(this.hScroll, this.component, 1);
                    this.repaint(this.vScroll);
                    this.lastMousePosition.x = x;
                } else if (x > this.textPainter.getBorder() && x < this.lastMousePosition.x) {
                    mouseEventThread.stopRunner(this.hScroll);
                    this.lastMousePosition.x = x;
                } else if (x < this.textScreen.width && x > this.textScreen.width - this.textPainter.getBorder() && x > this.lastMousePosition.x && this.hScroll.lineDn()) {
                    mouseEventThread.setRunner(this.hScroll, this.component, 2);
                    this.repaint(this.vScroll);
                    this.lastMousePosition.x = x;
                } else if (x < this.textScreen.width - this.textPainter.getBorder() && x > this.lastMousePosition.x) {
                    mouseEventThread.stopRunner(this.hScroll);
                    this.lastMousePosition.x = x;
                }
            }
            if (x < 0 || x > this.textScreen.width) {
                mouseEventThread.stopRunner(this.vScroll);
            } else if (y > 0 && y < this.textPainter.getBorder() && y < this.lastMousePosition.y && this.vScroll.lineUp()) {
                mouseEventThread.setRunner(this.vScroll, this.component, 1);
                this.repaint(this.vScroll);
                this.lastMousePosition.y = y;
            } else if (y > this.textPainter.getBorder() && y < this.lastMousePosition.y) {
                mouseEventThread.stopRunner(this.vScroll);
                this.lastMousePosition.y = y;
            } else if (y < this.textScreen.height && y > this.textScreen.height - this.textPainter.getBorder() && y > this.lastMousePosition.y && this.vScroll.lineDn()) {
                mouseEventThread.setRunner(this.vScroll, this.component, 2);
                this.repaint(this.vScroll);
                this.lastMousePosition.y = y;
            } else if (y < this.textScreen.height - this.textPainter.getBorder() && y > this.lastMousePosition.y) {
                mouseEventThread.stopRunner(this.vScroll);
                this.lastMousePosition.y = y;
            }
            this.textPainter.setScreenPosition(x, y, this.tempData);
            if (this.setNewSelection(this.tempData)) {
                this.lastMousePosition.setLocation(x, y);
                this.repaintText = true;
                this.paint(this.getGraphics());
            }
        }
    }

    public synchronized void setText(String newtext) {
        if (!this.initialized) {
            this.init();
        }
        super.setText(newtext);
        this.text = newtext;
        this.textPainter.setImage(this.text);
        if (this.hScroll != null) {
            this.hScroll.setBarRange(this.textPainter.getMaximumWidth());
            this.hScroll.setBarPos(0);
        }
        this.vScroll.setBarRange(this.textPainter.getMaximumLines());
        this.vScroll.setBarPos(0);
        this.textPainter.setOffset(0, 0);
        this.updatePosition(0);
        this.selectionStart = this.position;
        this.selectionStop = this.position;
        this.repaintText = true;
        this.repaintHScroll = true;
        this.repaintVScroll = true;
        this.paint(this.getGraphics());
        this.fireTextEvent();
    }

    public void setCaretPosition(int newpos) {
        if (!this.initialized) {
            this.init();
        }
        if (newpos != this.position && this.updatePosition(newpos)) {
            this.repaintVScroll = this.adjustVerticalViewport(this.cursorLine);
            if (this.hScroll != null) {
                this.repaintHScroll = this.adjustHorizontalViewport(this.cursorHorizontalOffset);
            }
            this.repaintText = true;
            this.paint(this.getGraphics());
        }
    }

    public synchronized void setSelectionStart(int newpos) {
        if (!this.initialized) {
            this.init();
        }
        if (newpos != this.position && this.updateStart(newpos)) {
            this.repaintVScroll = this.adjustVerticalViewport(this.startLine);
            if (this.hScroll != null) {
                this.repaintHScroll = this.adjustHorizontalViewport(this.startHorizontalOffset);
            }
            this.repaintText = true;
            this.paint(this.getGraphics());
        }
    }

    public synchronized void setSelectionEnd(int newpos) {
        if (!this.initialized) {
            this.init();
        }
        if (newpos != this.position && this.updateStop(newpos)) {
            this.repaintVScroll = this.adjustVerticalViewport(this.stopLine);
            if (this.hScroll != null) {
                this.repaintHScroll = this.adjustHorizontalViewport(this.stopHorizontalOffset);
            }
            this.repaintText = true;
            this.paint(this.getGraphics());
        }
    }

    protected void fireTextEvent() {
        this.component.dispatchEvent(new TextEvent(this.component, 900));
    }

    public boolean inRange(MouseEvent e) {
        return e.getX() < this.textScreen.width && e.getY() < this.textScreen.height;
    }

    class VAreaScrollPainter
    extends ScrollPainter {
        public VAreaScrollPainter() {
            super(16, 16, 16, 16);
        }

        public int getPos(int x, int y) {
            return y;
        }

        public int getThickness(int width, int height) {
            return width;
        }

        public Dimension getSize(int scrollbarlength, int scrollbarthickness) {
            return new Dimension(scrollbarthickness, scrollbarlength);
        }

        public Dimension getPreferredSize(int width, int height) {
            return new Dimension(this.minimumThickness, height);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.minimumThickness, this.lineUpSpan + this.lineDnSpan + this.minimumScreenSpan);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.minimumThickness, this.lineUpSpan + this.lineDnSpan + this.screenRange);
        }

        public Dimension getCurrentSize() {
            return new Dimension(this.minimumThickness, this.lineUpSpan + this.lineDnSpan + this.screenRange);
        }

        public void setThickness(int width, int height) {
            this.currentThickness = width > this.minimumThickness ? width : this.minimumThickness;
        }

        public boolean setRange(int width, int height) {
            return this.setRange(height);
        }

        public boolean setScreenHeight(int totalheight, int newvisible, int newrange) {
            this.screenRange = totalheight - 16 - 16;
            this.barSpan = newvisible;
            this.barRange = newrange;
            int n = this.blockStep = newvisible > 1 ? newvisible - 1 : 1;
            if (this.screenRange <= 0) {
                this.screenRange = 0;
                this.screenSpan = 0;
                this.screenRange = 0;
                this.crippledSpan = totalheight;
            } else {
                this.crippledSpan = -1;
                if (this.barSpan > this.barRange) {
                    this.barSpan = this.barRange;
                    this.barPos = 0;
                } else if (this.barPos + this.barSpan > this.barRange) {
                    this.barPos = this.barRange - this.barSpan;
                }
                this.setScreen();
            }
            return true;
        }

        public synchronized int setActive(int x, int y) {
            this.currentActive = x > this.barOffset ? this.getField(y) : -1;
            return this.currentActive;
        }

        public void paint(Graphics g) {
            if (this.crippledSpan < 0) {
                RudolphScrollbarPeer.paintVScrollbar(this.barOffset, 0, this.minimumThickness, this.paintedScreenPos, this.screenSpan, this.screenRange, this.currentActive, this.barColors, g);
            } else {
                RudolphScrollbarPeer.paintCrippledVScrollbar(this.barOffset, 0, this.minimumThickness, this.crippledSpan, this.currentActive, this.barColors, g);
            }
        }
    }

    class HAreaScrollPainter
    extends ScrollPainter {
        public HAreaScrollPainter() {
            super(16, 16, 16, 16);
        }

        public int getPos(int x, int y) {
            return x;
        }

        public int getThickness(int width, int height) {
            return height;
        }

        public Dimension getSize(int scrollbarlength, int scrollbarthickness) {
            return new Dimension(scrollbarlength, scrollbarthickness);
        }

        public Dimension getPreferredSize(int width, int height) {
            return new Dimension(width, this.minimumThickness);
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.minimumScreenSpan, this.minimumThickness);
        }

        public Dimension getPreferredSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.minimumThickness);
        }

        public Dimension getCurrentSize() {
            return new Dimension(this.lineUpSpan + this.lineDnSpan + this.screenRange, this.minimumThickness);
        }

        public void setThickness(int width, int height) {
            this.currentThickness = height > this.minimumThickness ? height : this.minimumThickness;
        }

        public boolean setRange(int width, int height) {
            return this.setRange(width);
        }

        public boolean setScreenWidth(int totalwidth, int newvisible, int newrange) {
            this.screenRange = totalwidth - this.lineUpSpan - this.lineDnSpan;
            this.barSpan = newvisible;
            this.barRange = newrange;
            int n = this.blockStep = newvisible > this.lineStep ? newvisible - this.lineStep : this.lineStep;
            if (this.screenRange <= 0) {
                this.screenRange = 0;
                this.screenSpan = 0;
                this.screenPos = 0;
                this.crippledSpan = totalwidth;
            } else {
                this.crippledSpan = -1;
                if (this.barSpan > this.barRange) {
                    this.barSpan = this.barRange;
                    this.barPos = 0;
                } else if (this.barPos + this.barSpan > this.barRange) {
                    this.barPos = this.barRange - this.barSpan;
                }
                this.setScreen();
            }
            return true;
        }

        public synchronized int setActive(int x, int y) {
            this.currentActive = y > this.barOffset ? this.getField(x) : -1;
            return this.currentActive;
        }

        public void paint(Graphics g) {
            if (this.crippledSpan < 0) {
                RudolphScrollbarPeer.paintHScrollbar(0, this.barOffset, this.minimumThickness, this.paintedScreenPos, this.screenSpan, this.screenRange, this.currentActive, this.barColors, g);
            } else {
                RudolphScrollbarPeer.paintCrippledHScrollbar(0, this.barOffset, this.minimumThickness, this.crippledSpan, this.currentActive, this.barColors, g);
            }
        }
    }
}

